/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.server.AbstractLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MobLootPoolBuilder
extends AbstractLootPoolBuilder {
    final HashMap<List<TextKey>, ChestLootPoolBuilder> map = new HashMap();
    final List<LootTableParser.LootConditionResult> conditions;
    final List<LootTableParser.LootFunctionResult> functions;
    HashMap<List<TextKey>, ChestLootPoolBuilder> builtMap = new HashMap();

    public MobLootPoolBuilder(float rollWeight, List<LootTableParser.LootConditionResult> conditions, List<LootTableParser.LootFunctionResult> functions) {
        super(rollWeight);
        this.conditions = conditions;
        this.functions = functions;
    }

    @Override
    public void addItem(LootTableParser.ItemEntryResult result) {
        LinkedList<TextKey> testKey = new LinkedList<TextKey>();
        testKey.addAll(result.functions());
        testKey.addAll(result.conditions());
        ChestLootPoolBuilder builder = this.map.getOrDefault(testKey, new ChestLootPoolBuilder(this.rollWeight));
        builder.addItem(result);
        this.map.put(testKey, builder);
    }

    @Override
    public void build() {
        if (this.map.isEmpty()) {
            this.isEmpty = true;
            return;
        }
        for (List<TextKey> key : this.map.keySet()) {
            ChestLootPoolBuilder builder = this.map.getOrDefault(key, new ChestLootPoolBuilder(this.rollWeight));
            builder.build();
            if (this.map.size() == 1 && builder.isEmpty) {
                this.isEmpty = true;
                return;
            }
            if (this.map.size() == 1 && builder.isSimple && this.conditions.isEmpty() && this.functions.isEmpty() && key.isEmpty()) {
                this.simpleStack = builder.simpleStack;
                this.isSimple = true;
            }
            this.builtMap.put(key, builder);
        }
    }

    @Override
    public List<LootTableParser.ItemEntryResult> revert() {
        LinkedList<LootTableParser.ItemEntryResult> list = new LinkedList<LootTableParser.ItemEntryResult>();
        LinkedList topLevelKeys = new LinkedList();
        this.conditions.forEach(condition -> topLevelKeys.add(condition.text()));
        this.functions.forEach(function -> topLevelKeys.add(function.text()));
        this.map.forEach((keyList, builder) -> {
            List<LootTableParser.ItemEntryResult> builderList = builder.revert();
            builderList.forEach(builderEntry -> {
                builderEntry.functions().addAll((Collection<TextKey>)keyList);
                builderEntry.conditions().addAll(topLevelKeys);
            });
            list.addAll(builderList);
        });
        return list;
    }
}

