/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire;

import com.iafenvoy.iceandfire.config.IafClientConfig;
import com.iafenvoy.iceandfire.data.DragonArmor;
import com.iafenvoy.iceandfire.data.SeaSerpent;
import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.event.ClientEvents;
import com.iafenvoy.iceandfire.network.ClientNetworkHelper;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafKeybindings;
import com.iafenvoy.iceandfire.registry.IafRenderers;
import com.iafenvoy.iceandfire.registry.IafScreenHandlers;
import com.iafenvoy.iceandfire.render.TEISRItemRenderer;
import com.iafenvoy.iceandfire.render.TideTridentRenderer;
import com.iafenvoy.iceandfire.render.TrollWeaponRenderer;
import com.iafenvoy.iceandfire.render.armor.CopperArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.DeathWormArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.DragonSteelArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.ScaleArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.SeaSerpentArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.SilverArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.TrollArmorRenderer;
import com.iafenvoy.iceandfire.render.item.DeathwormGauntletRenderer;
import com.iafenvoy.iceandfire.render.item.GorgonHeadRenderer;
import com.iafenvoy.iceandfire.render.model.util.DragonAnimationsLibrary;
import com.iafenvoy.iceandfire.render.model.util.EnumDragonModelTypes;
import com.iafenvoy.iceandfire.render.model.util.EnumDragonPoses;
import com.iafenvoy.iceandfire.render.model.util.EnumSeaSerpentAnimations;
import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import java.util.Iterator;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1935;

@Environment(value=EnvType.CLIENT)
public class IceAndFireClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ConfigManager.getInstance().registerConfigHandler((AbstractConfigContainer)IafClientConfig.INSTANCE);
        IafScreenHandlers.registerGui();
        EnumSeaSerpentAnimations.initializeSerpentModels();
        DragonAnimationsLibrary.register(EnumDragonPoses.values(), EnumDragonModelTypes.values());
        IafRenderers.registerRenderers();
        IafBlockEntities.registerRenderers();
        IafBlocks.registerRenderLayers();
        IafItems.registerModelPredicates();
        IafKeybindings.init();
        IafRenderers.registerParticleRenderers();
        ArmorRenderer.register((ArmorRenderer)new CopperArmorRenderer(), (class_1935[])new class_1935[]{IafItems.COPPER_HELMET, IafItems.COPPER_CHESTPLATE, IafItems.COPPER_LEGGINGS, IafItems.COPPER_BOOTS});
        ArmorRenderer.register((ArmorRenderer)new DeathWormArmorRenderer(), (class_1935[])new class_1935[]{IafItems.DEATHWORM_WHITE_HELMET, IafItems.DEATHWORM_WHITE_CHESTPLATE, IafItems.DEATHWORM_WHITE_LEGGINGS, IafItems.DEATHWORM_WHITE_BOOTS});
        ArmorRenderer.register((ArmorRenderer)new DeathWormArmorRenderer(), (class_1935[])new class_1935[]{IafItems.DEATHWORM_YELLOW_HELMET, IafItems.DEATHWORM_YELLOW_CHESTPLATE, IafItems.DEATHWORM_YELLOW_LEGGINGS, IafItems.DEATHWORM_YELLOW_BOOTS});
        ArmorRenderer.register((ArmorRenderer)new DeathWormArmorRenderer(), (class_1935[])new class_1935[]{IafItems.DEATHWORM_RED_HELMET, IafItems.DEATHWORM_RED_CHESTPLATE, IafItems.DEATHWORM_RED_LEGGINGS, IafItems.DEATHWORM_RED_BOOTS});
        ArmorRenderer.register((ArmorRenderer)new DragonSteelArmorRenderer(), (class_1935[])new class_1935[]{IafItems.DRAGONSTEEL_FIRE_HELMET, IafItems.DRAGONSTEEL_FIRE_CHESTPLATE, IafItems.DRAGONSTEEL_FIRE_LEGGINGS, IafItems.DRAGONSTEEL_FIRE_BOOTS});
        ArmorRenderer.register((ArmorRenderer)new DragonSteelArmorRenderer(), (class_1935[])new class_1935[]{IafItems.DRAGONSTEEL_ICE_HELMET, IafItems.DRAGONSTEEL_ICE_CHESTPLATE, IafItems.DRAGONSTEEL_ICE_LEGGINGS, IafItems.DRAGONSTEEL_ICE_BOOTS});
        ArmorRenderer.register((ArmorRenderer)new DragonSteelArmorRenderer(), (class_1935[])new class_1935[]{IafItems.DRAGONSTEEL_LIGHTNING_HELMET, IafItems.DRAGONSTEEL_LIGHTNING_CHESTPLATE, IafItems.DRAGONSTEEL_LIGHTNING_LEGGINGS, IafItems.DRAGONSTEEL_LIGHTNING_BOOTS});
        ArmorRenderer.register((ArmorRenderer)new SilverArmorRenderer(), (class_1935[])new class_1935[]{IafItems.SILVER_HELMET, IafItems.SILVER_CHESTPLATE, IafItems.SILVER_LEGGINGS, IafItems.SILVER_BOOTS});
        for (DragonArmor armor : DragonArmor.values()) {
            ArmorRenderer.register((ArmorRenderer)new ScaleArmorRenderer(), (class_1935[])new class_1935[]{armor.helmet, armor.chestplate, armor.leggings, armor.boots});
        }
        for (SeaSerpent seaSerpent : SeaSerpent.values()) {
            ArmorRenderer.register((ArmorRenderer)new SeaSerpentArmorRenderer(), (class_1935[])new class_1935[]{seaSerpent.helmet, seaSerpent.chestplate, seaSerpent.leggings, seaSerpent.boots});
        }
        for (TrollType troll : TrollType.values()) {
            ArmorRenderer.register((ArmorRenderer)new TrollArmorRenderer(), (class_1935[])new class_1935[]{troll.helmet, troll.chestplate, troll.leggings, troll.boots});
        }
        for (Iterator<Object> iterator : TrollType.BuiltinWeapon.values()) {
            BuiltinItemRendererRegistry.INSTANCE.register((class_1935)((TrollType.BuiltinWeapon)((Object)iterator)).getItem(), (BuiltinItemRendererRegistry.DynamicItemRenderer)new TrollWeaponRenderer());
        }
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafItems.DEATHWORM_GAUNTLET_RED, (BuiltinItemRendererRegistry.DynamicItemRenderer)new DeathwormGauntletRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafItems.DEATHWORM_GAUNTLET_YELLOW, (BuiltinItemRendererRegistry.DynamicItemRenderer)new DeathwormGauntletRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafItems.DEATHWORM_GAUNTLET_WHITE, (BuiltinItemRendererRegistry.DynamicItemRenderer)new DeathwormGauntletRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafItems.GORGON_HEAD, (BuiltinItemRendererRegistry.DynamicItemRenderer)new GorgonHeadRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafItems.TIDE_TRIDENT, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TideTridentRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.PIXIE_HOUSE_BIRCH, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.PIXIE_HOUSE_OAK, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.PIXIE_HOUSE_DARK_OAK, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.PIXIE_HOUSE_SPRUCE, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.PIXIE_HOUSE_MUSHROOM_RED, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.DREAD_PORTAL, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)IafBlocks.GHOST_CHEST, (BuiltinItemRendererRegistry.DynamicItemRenderer)new TEISRItemRenderer());
        UseEntityCallback.EVENT.register(ClientEvents::onEntityInteract);
        ClientNetworkHelper.registerReceivers();
    }
}

