/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public record DragonColor(String name, class_124 color, DragonType dragonType, Supplier<class_1792> eggItem, Supplier<class_1792> scaleItem) {
    private static final List<DragonColor> VALUES = new ArrayList<DragonColor>();
    private static final Map<String, DragonColor> ID_MAP = new HashMap<String, DragonColor>();
    private static final Map<DragonType, List<DragonColor>> BY_DRAGON_TYPE = new HashMap<DragonType, List<DragonColor>>();
    public static final DragonColor RED = new DragonColor("red", class_124.field_1079, DragonType.FIRE, () -> IafItems.DRAGONEGG_RED, () -> IafItems.DRAGONSCALES_RED);
    public static final DragonColor GREEN = new DragonColor("green", class_124.field_1077, DragonType.FIRE, () -> IafItems.DRAGONEGG_GREEN, () -> IafItems.DRAGONSCALES_GREEN);
    public static final DragonColor BRONZE = new DragonColor("bronze", class_124.field_1065, DragonType.FIRE, () -> IafItems.DRAGONEGG_BRONZE, () -> IafItems.DRAGONSCALES_BRONZE);
    public static final DragonColor GRAY = new DragonColor("gray", class_124.field_1080, DragonType.FIRE, () -> IafItems.DRAGONEGG_GRAY, () -> IafItems.DRAGONSCALES_GRAY);
    public static final DragonColor BLUE = new DragonColor("blue", class_124.field_1075, DragonType.ICE, () -> IafItems.DRAGONEGG_BLUE, () -> IafItems.DRAGONSCALES_BLUE);
    public static final DragonColor WHITE = new DragonColor("white", class_124.field_1068, DragonType.ICE, () -> IafItems.DRAGONEGG_WHITE, () -> IafItems.DRAGONSCALES_WHITE);
    public static final DragonColor SAPPHIRE = new DragonColor("sapphire", class_124.field_1078, DragonType.ICE, () -> IafItems.DRAGONEGG_SAPPHIRE, () -> IafItems.DRAGONSCALES_SAPPHIRE);
    public static final DragonColor SILVER = new DragonColor("silver", class_124.field_1063, DragonType.ICE, () -> IafItems.DRAGONEGG_SILVER, () -> IafItems.DRAGONSCALES_SILVER);
    public static final DragonColor ELECTRIC = new DragonColor("electric", class_124.field_1058, DragonType.LIGHTNING, () -> IafItems.DRAGONEGG_ELECTRIC, () -> IafItems.DRAGONSCALES_ELECTRIC);
    public static final DragonColor AMETHYST = new DragonColor("amethyst", class_124.field_1076, DragonType.LIGHTNING, () -> IafItems.DRAGONEGG_AMETHYST, () -> IafItems.DRAGONSCALES_AMETHYST);
    public static final DragonColor COPPER = new DragonColor("copper", class_124.field_1065, DragonType.LIGHTNING, () -> IafItems.DRAGONEGG_COPPER, () -> IafItems.DRAGONSCALES_COPPER);
    public static final DragonColor BLACK = new DragonColor("black", class_124.field_1063, DragonType.LIGHTNING, () -> IafItems.DRAGONEGG_BLACK, () -> IafItems.DRAGONSCALES_BLACK);

    public DragonColor(String name, class_124 color, DragonType dragonType, Supplier<class_1792> eggItem, Supplier<class_1792> scaleItem) {
        this.name = name;
        this.color = color;
        this.dragonType = dragonType;
        this.eggItem = eggItem;
        this.scaleItem = scaleItem;
        VALUES.add(this);
        ID_MAP.put(name, this);
        if (!BY_DRAGON_TYPE.containsKey(dragonType)) {
            BY_DRAGON_TYPE.put(dragonType, new ArrayList());
        }
        BY_DRAGON_TYPE.get(dragonType).add(this);
    }

    public static List<DragonColor> values() {
        return ImmutableList.copyOf(VALUES);
    }

    public static DragonColor byMetadata(int meta) {
        DragonColor i = DragonColor.values().get(meta);
        return i == null ? RED : i;
    }

    public static DragonColor getById(String id) {
        return ID_MAP.getOrDefault(id, RED);
    }

    public static List<DragonColor> getColorsByType(DragonType type) {
        return ImmutableList.copyOf((Collection)BY_DRAGON_TYPE.getOrDefault(type, new ArrayList()));
    }

    public class_1792 getEggItem() {
        return this.eggItem.get();
    }

    public class_1792 getScaleItem() {
        return this.scaleItem.get();
    }

    public class_2960 getEggTexture() {
        return new class_2960("iceandfire", String.format("textures/models/%sdragon/egg_%s.png", this.dragonType.getName(), this.name));
    }

    @Override
    public String toString() {
        return "EnumDragonColor[name=" + this.name + ", color=" + this.color + ", dragonType=" + this.dragonType + "]";
    }

    public class_2960 getTextureByEntity(EntityDragonBase dragon) {
        int stage = dragon.getDragonStage();
        if (dragon.isModelDead()) {
            if (dragon.getDeathStage() >= dragon.getAgeInDays() / 5 / 2) {
                return this.getSkeletonTexture(stage);
            }
            return this.getSleepTexture(stage);
        }
        if (dragon.method_6113() || dragon.isBlinking()) {
            return this.getSleepTexture(stage);
        }
        return this.getBodyTexture(stage);
    }

    public class_2960 getBodyTexture(int stage) {
        return new class_2960("iceandfire", String.format("textures/models/%sdragon/%s_%d.png", this.dragonType.getName(), this.name, stage));
    }

    public class_2960 getSleepTexture(int stage) {
        return new class_2960("iceandfire", String.format("textures/models/%sdragon/%s_%d_sleeping.png", this.dragonType.getName(), this.name, stage));
    }

    public class_2960 getEyesTexture(int stage) {
        return new class_2960("iceandfire", String.format("textures/models/%sdragon/%s_%d_eyes.png", this.dragonType.getName(), this.name, stage));
    }

    public class_2960 getSkeletonTexture(int stage) {
        return new class_2960("iceandfire", String.format("textures/models/%sdragon/%s_skeleton_%d.png", this.dragonType.getName(), this.dragonType.getName(), stage));
    }

    public class_2960 getMaleOverlay() {
        return new class_2960("iceandfire", String.format("textures/models/%sdragon/male_%s.png", this.dragonType.getName(), this.name));
    }
}

