/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class DragonType {
    private static final List<DragonType> TYPES = new ArrayList<DragonType>();
    private static final Map<String, DragonType> BY_NAME = new HashMap<String, DragonType>();
    public static final DragonType FIRE = new DragonType("fire", () -> IafEntities.FIRE_DRAGON, () -> IafItems.DRAGON_SKULL_FIRE, () -> IafItems.SUMMONING_CRYSTAL_FIRE);
    public static final DragonType ICE = new DragonType("ice", () -> IafEntities.ICE_DRAGON, () -> IafItems.DRAGON_SKULL_ICE, () -> IafItems.SUMMONING_CRYSTAL_ICE).setPiscivore();
    public static final DragonType LIGHTNING = new DragonType("lightning", () -> IafEntities.LIGHTNING_DRAGON, () -> IafItems.DRAGON_SKULL_LIGHTNING, () -> IafItems.SUMMONING_CRYSTAL_LIGHTNING);
    private final String name;
    private final Supplier<class_1299<? extends EntityDragonBase>> entityType;
    private final Supplier<class_1792> skullItem;
    private final Supplier<class_1792> crystalItem;
    private boolean piscivore;

    public DragonType(String name, Supplier<class_1299<? extends EntityDragonBase>> entityType, Supplier<class_1792> skullItem, Supplier<class_1792> crystalItem) {
        this.name = name;
        this.entityType = entityType;
        this.skullItem = skullItem;
        this.crystalItem = crystalItem;
        TYPES.add(this);
        BY_NAME.put(name, this);
    }

    public static String getNameFromInt(int type) {
        return DragonType.TYPES.get((int)type).name;
    }

    public static DragonType getTypeById(String id) {
        return BY_NAME.getOrDefault(id, FIRE);
    }

    public static DragonType getTypeByEntityType(class_1299<?> type) {
        return TYPES.stream().filter(x -> x.entityType.get() == type).findFirst().orElse(FIRE);
    }

    public int getIntFromType() {
        return TYPES.indexOf(this);
    }

    public class_1299<? extends EntityDragonBase> getEntity() {
        return this.entityType.get();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPiscivore() {
        return this.piscivore;
    }

    public DragonType setPiscivore() {
        this.piscivore = true;
        return this;
    }

    public class_2960 getSkeletonTexture(int stage) {
        return new class_2960("iceandfire", String.format("textures/models/%sdragon/%s_skeleton_%d.png", this.name, this.name, stage));
    }

    public class_1792 getSkullItem() {
        return this.skullItem.get();
    }

    public class_1792 getCrystalItem() {
        return this.crystalItem.get();
    }
}

