/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.item.ItemSeaSerpentScales;
import com.iafenvoy.iceandfire.item.armor.IafArmorMaterial;
import com.iafenvoy.iceandfire.item.armor.ItemSeaSerpentArmor;
import com.iafenvoy.iceandfire.item.block.BlockSeaSerpentScales;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.object.IdUtil;
import com.iafenvoy.uranus.object.item.CustomArmorMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3417;

public class SeaSerpent {
    private static final List<SeaSerpent> TYPES = new ArrayList<SeaSerpent>();
    private static final Map<String, SeaSerpent> BY_NAME = new HashMap<String, SeaSerpent>();
    public static final SeaSerpent BLUE = new SeaSerpent("blue", class_124.field_1078);
    public static final SeaSerpent BRONZE = new SeaSerpent("bronze", class_124.field_1065);
    public static final SeaSerpent DEEPBLUE = new SeaSerpent("deepblue", class_124.field_1058);
    public static final SeaSerpent GREEN = new SeaSerpent("green", class_124.field_1077);
    public static final SeaSerpent PURPLE = new SeaSerpent("purple", class_124.field_1064);
    public static final SeaSerpent RED = new SeaSerpent("red", class_124.field_1079);
    public static final SeaSerpent TEAL = new SeaSerpent("teal", class_124.field_1075);
    private final String name;
    private final class_124 color;
    public CustomArmorMaterial armorMaterial;
    public class_1792 scale;
    public class_1792 helmet;
    public class_1792 chestplate;
    public class_1792 leggings;
    public class_1792 boots;
    public class_2248 scaleBlock;

    public SeaSerpent(String name, class_124 color) {
        this.name = name;
        this.color = color;
        TYPES.add(this);
        BY_NAME.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public class_124 getColor() {
        return this.color;
    }

    public class_2960 getTexture(boolean blink) {
        return new class_2960("iceandfire", String.format("textures/models/seaserpent/seaserpent_%s%s.png", this.name, blink ? "_blink" : ""));
    }

    public static List<SeaSerpent> values() {
        return ImmutableList.copyOf(TYPES);
    }

    public static void initArmors() {
        for (SeaSerpent color : SeaSerpent.values()) {
            color.armorMaterial = new IafArmorMaterial(IdUtil.build((String)"iceandfire", (String)"sea_serpent_scales_") + color.name, 30, new int[]{4, 8, 7, 4}, 25, class_3417.field_14761, 2.5f);
            color.scaleBlock = IafBlocks.register("sea_serpent_scale_block_" + color.name, new BlockSeaSerpentScales(color.name, color.color));
            color.scale = IafItems.register("sea_serpent_scales_" + color.name, new ItemSeaSerpentScales(color.name, color.color));
            color.helmet = IafItems.register("tide_" + color.name + "_helmet", new ItemSeaSerpentArmor(color, color.armorMaterial, class_1738.class_8051.field_41934));
            color.chestplate = IafItems.register("tide_" + color.name + "_chestplate", new ItemSeaSerpentArmor(color, color.armorMaterial, class_1738.class_8051.field_41935));
            color.leggings = IafItems.register("tide_" + color.name + "_leggings", new ItemSeaSerpentArmor(color, color.armorMaterial, class_1738.class_8051.field_41936));
            color.boots = IafItems.register("tide_" + color.name + "_boots", new ItemSeaSerpentArmor(color, color.armorMaterial, class_1738.class_8051.field_41937));
        }
    }

    public static SeaSerpent getByName(String name) {
        return BY_NAME.getOrDefault(name, BLUE);
    }
}

