/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.item.armor.ItemTrollArmor;
import com.iafenvoy.iceandfire.item.tool.ItemTrollWeapon;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import com.iafenvoy.uranus.object.item.CustomArmorMaterial;
import com.iafenvoy.uranus.util.RandomHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

public class TrollType {
    private static final List<TrollType> TYPES = new ArrayList<TrollType>();
    private static final Map<String, TrollType> BY_NAME = new HashMap<String, TrollType>();
    public static final TrollType FOREST = new TrollType("forest", IafItems.TROLL_FOREST_ARMOR_MATERIAL, biome -> biome.method_40220(IafBiomeTags.FOREST_TROLL), new class_2960("iceandfire", "entities/troll_forest"), BuiltinWeapon.TRUNK, BuiltinWeapon.COLUMN_FOREST, BuiltinWeapon.AXE, BuiltinWeapon.HAMMER);
    public static final TrollType FROST = new TrollType("frost", IafItems.TROLL_FROST_ARMOR_MATERIAL, biome -> biome.method_40220(IafBiomeTags.SNOWY_TROLL), new class_2960("iceandfire", "entities/troll_frost"), BuiltinWeapon.COLUMN_FROST, BuiltinWeapon.TRUNK_FROST, BuiltinWeapon.AXE, BuiltinWeapon.HAMMER);
    public static final TrollType MOUNTAIN = new TrollType("mountain", IafItems.TROLL_MOUNTAIN_ARMOR_MATERIAL, biome -> biome.method_40220(IafBiomeTags.MOUNTAIN_TROLL), new class_2960("iceandfire", "entities/troll_mountain"), BuiltinWeapon.COLUMN, BuiltinWeapon.AXE, BuiltinWeapon.HAMMER);
    public final class_1792 leather;
    public final class_1792 helmet;
    public final class_1792 chestplate;
    public final class_1792 leggings;
    public final class_1792 boots;
    private final String name;
    private final CustomArmorMaterial material;
    private final Predicate<class_6880<class_1959>> biomePredicate;
    private final class_2960 lootTable;
    private final List<BuiltinWeapon> weapons;

    public TrollType(String name, CustomArmorMaterial material, Predicate<class_6880<class_1959>> biomePredicate, class_2960 lootTable, BuiltinWeapon ... weapons) {
        this.name = name;
        this.weapons = List.of(weapons);
        this.material = material;
        this.biomePredicate = biomePredicate;
        this.lootTable = lootTable;
        this.leather = new class_1792((class_1792.class_1793)new FabricItemSettings());
        this.helmet = new ItemTrollArmor(this, material, class_1738.class_8051.field_41934);
        this.chestplate = new ItemTrollArmor(this, material, class_1738.class_8051.field_41935);
        this.leggings = new ItemTrollArmor(this, material, class_1738.class_8051.field_41936);
        this.boots = new ItemTrollArmor(this, material, class_1738.class_8051.field_41937);
        TYPES.add(this);
        BY_NAME.put(name, this);
    }

    public static TrollType getBiomeType(class_6880<class_1959> biome) {
        List<TrollType> types = TYPES.stream().filter(x -> x.allowSpawn(biome)).toList();
        if (types.isEmpty()) {
            RandomHelper.randomOne(TYPES);
        }
        return (TrollType)RandomHelper.randomOne(types);
    }

    public static BuiltinWeapon getWeaponForType(TrollType troll) {
        return troll.weapons.get(ThreadLocalRandom.current().nextInt(troll.weapons.size()));
    }

    public static void initArmors() {
        for (TrollType troll : TYPES) {
            IafItems.register("troll_leather_%s".formatted(troll.name.toLowerCase(Locale.ROOT)), troll.leather);
            IafItems.register(ItemTrollArmor.getName(troll, class_1304.field_6169), troll.helmet);
            IafItems.register(ItemTrollArmor.getName(troll, class_1304.field_6174), troll.chestplate);
            IafItems.register(ItemTrollArmor.getName(troll, class_1304.field_6172), troll.leggings);
            IafItems.register(ItemTrollArmor.getName(troll, class_1304.field_6166), troll.boots);
        }
    }

    public static List<TrollType> values() {
        return ImmutableList.copyOf(TYPES);
    }

    public static TrollType getByName(String name) {
        return BY_NAME.getOrDefault(name, FOREST);
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getLootTable() {
        return this.lootTable;
    }

    public CustomArmorMaterial getMaterial() {
        return this.material;
    }

    public class_2960 getTexture() {
        return new class_2960("iceandfire", "textures/models/troll/troll_" + this.name + ".png");
    }

    public class_2960 getStatueTexture() {
        return new class_2960("iceandfire", "textures/models/troll/troll_" + this.name + "_stone.png");
    }

    public class_2960 getEyesTexture() {
        return new class_2960("iceandfire", "textures/models/troll/troll_" + this.name + "_eyes.png");
    }

    public boolean allowSpawn(class_6880<class_1959> biome) {
        return this.biomePredicate.test(biome);
    }

    public static enum BuiltinWeapon implements ITrollWeapon
    {
        AXE,
        COLUMN,
        COLUMN_FOREST,
        COLUMN_FROST,
        HAMMER,
        TRUNK,
        TRUNK_FROST;

        private final class_1792 item = IafItems.register("troll_weapon_" + this.name().toLowerCase(Locale.ROOT), new ItemTrollWeapon(this));

        private BuiltinWeapon() {
            ITrollWeapon.addWeapons(this);
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public class_2960 getTexture() {
            return new class_2960("iceandfire", "textures/models/troll/weapon/weapon_" + this.name().toLowerCase(Locale.ROOT) + ".png");
        }

        @Override
        public class_1792 getItem() {
            return this.item;
        }
    }

    public static interface ITrollWeapon {
        @ApiStatus.Internal
        public static final List<ITrollWeapon> WEAPONS = new ArrayList<ITrollWeapon>();
        @ApiStatus.Internal
        public static final Map<String, ITrollWeapon> BY_NAME = new HashMap<String, ITrollWeapon>();

        public static void addWeapons(ITrollWeapon ... weapons) {
            for (ITrollWeapon weapon : weapons) {
                WEAPONS.add(weapon);
                BY_NAME.put(weapon.getName(), weapon);
            }
        }

        public static List<ITrollWeapon> values() {
            return ImmutableList.copyOf(WEAPONS);
        }

        public static ITrollWeapon getByName(String name) {
            return BY_NAME.getOrDefault(name, BuiltinWeapon.AXE);
        }

        public String getName();

        public class_2960 getTexture();

        public class_1792 getItem();
    }
}

