/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.EntityDataComponent;
import com.iafenvoy.iceandfire.entity.ai.AmphithereAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.AmphithereAIFleePlayer;
import com.iafenvoy.iceandfire.entity.ai.AmphithereAIFollowOwner;
import com.iafenvoy.iceandfire.entity.ai.AmphithereAIHurtByTarget;
import com.iafenvoy.iceandfire.entity.ai.AmphithereAITargetItems;
import com.iafenvoy.iceandfire.entity.ai.EntityAIWatchClosestIgnoreRider;
import com.iafenvoy.iceandfire.entity.pathfinding.PathNavigateFlyingCreature;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.IFlapable;
import com.iafenvoy.iceandfire.entity.util.IFlyingMount;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IPhasesThroughBlock;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IDragonFlute;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.render.model.IFChainBuffer;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1331;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1410;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1924;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8103;

public class EntityAmphithere
extends class_1321
implements ISyncMount,
IAnimatedEntity,
IPhasesThroughBlock,
IFlapable,
IDragonFlute,
IFlyingMount,
IHasCustomizableAttributes,
ICustomMoveController {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_BITE_RIDER = Animation.create((int)15);
    public static final Animation ANIMATION_WING_BLAST = Animation.create((int)30);
    public static final Animation ANIMATION_TAIL_WHIP = Animation.create((int)30);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(EntityAmphithere.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(EntityAmphithere.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> FLAP_TICKS = class_2945.method_12791(EntityAmphithere.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Byte> CONTROL_STATE = class_2945.method_12791(EntityAmphithere.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> COMMAND = class_2945.method_12791(EntityAmphithere.class, (class_2941)class_2943.field_13327);
    public float flapProgress;
    public float groundProgress = 0.0f;
    public float sitProgress = 0.0f;
    public float diveProgress = 0.0f;
    public IFChainBuffer roll_buffer;
    public IFChainBuffer tail_buffer;
    public IFChainBuffer pitch_buffer;
    public class_2338 orbitPos = null;
    public float orbitRadius = 0.0f;
    public boolean isFallen;
    public class_2338 homePos;
    public boolean hasHomePosition = false;
    protected FlightBehavior flightBehavior = FlightBehavior.WANDER;
    protected int ticksCircling = 0;
    private int animationTick;
    private Animation currentAnimation;
    private int flapTicks = 0;
    private int flightCooldown = 0;
    private int ticksFlying = 0;
    private boolean isFlying;
    private boolean changedFlightBehavior = false;
    private int ticksStill = 0;
    private int ridingTime = 0;
    private boolean isSitting;
    private int navigatorType = 0;

    public EntityAmphithere(class_1299<EntityAmphithere> type, class_1937 worldIn) {
        super(type, worldIn);
        if (worldIn.field_9236) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.tail_buffer = new IFChainBuffer();
        }
        this.method_49477(1.0f);
        this.switchNavigator(0);
    }

    public static class_2338 getPositionRelativetoGround(class_1297 entity, class_1937 world, int x, int z, class_5819 rand) {
        class_2338 pos = new class_2338(x, entity.method_31478(), z);
        for (int yDown = 0; yDown < 6 + rand.method_43048(6); ++yDown) {
            if (world.method_22347(pos.method_10087(yDown))) continue;
            return pos.method_10086(yDown);
        }
        return pos;
    }

    public static boolean canAmphithereSpawnOn(class_1299<EntityAmphithere> parrotIn, class_5425 worldIn, class_3730 reason, class_2338 p_223317_3_, class_5819 random) {
        class_2680 blockState = worldIn.method_8320(p_223317_3_.method_10074());
        class_2248 block = blockState.method_26204();
        return blockState.method_26164(class_3481.field_15503) || block == class_2246.field_10219 || blockState.method_26164(class_3481.field_15475) || block == class_2246.field_10124;
    }

    public static class_2338 getPositionInOrbit(EntityAmphithere entity, class_1937 world, class_2338 orbit, class_5819 rand) {
        float possibleOrbitRadius = entity.orbitRadius + 10.0f;
        float radius = 10.0f;
        if (entity.getCommand() == 2) {
            if (entity.method_35057() != null) {
                orbit = entity.method_35057().method_24515().method_10086(7);
                radius = 5.0f;
            }
        } else if (entity.hasHomePosition) {
            orbit = entity.homePos.method_10086(30);
            radius = 30.0f;
        }
        float angle = (float)Math.PI / 180 * possibleOrbitRadius;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = class_2338.method_49637((double)((double)orbit.method_10263() + extraX), (double)orbit.method_10264(), (double)((double)orbit.method_10260() + extraZ));
        entity.orbitRadius = possibleOrbitRadius;
        return radialPos;
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)IafCommonConfig.INSTANCE.amphithere.maxHealth.getValue()).doubleValue()).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23721, ((Double)IafCommonConfig.INSTANCE.amphithere.attackDamage.getValue()).doubleValue()).method_26868(class_5134.field_23720, ((Double)IafCommonConfig.INSTANCE.amphithere.flightSpeed.getValue()).doubleValue()).method_26868(class_5134.field_23717, 32.0);
    }

    public boolean method_5957(class_4538 worldIn) {
        if (worldIn.method_8606((class_1297)this) && !worldIn.method_22345(this.method_5829())) {
            class_2338 blockpos = this.method_24515();
            if (blockpos.method_10264() < worldIn.method_8615()) {
                return false;
            }
            class_2680 blockstate = worldIn.method_8320(blockpos.method_10074());
            return blockstate.method_27852(class_2246.field_10219) || blockstate.method_26164(class_3481.field_15503);
        }
        return false;
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public float method_6149(class_2338 pos) {
        if (this.isFlying()) {
            return this.method_37908().method_22347(pos) ? 10.0f : 0.0f;
        }
        return super.method_6149(pos);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (itemstack != null && itemstack.method_31573(IafItemTags.BREED_AMPITHERE)) {
            if (this.method_5618() == 0 && !this.method_6479()) {
                this.method_24346(false);
                this.method_6480(player);
                this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                if (!player.method_7337()) {
                    itemstack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        if (itemstack != null && itemstack.method_31573(IafItemTags.HEAL_AMPITHERE) && this.method_6032() < this.method_6063()) {
            this.method_6025(5.0f);
            this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemstack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (super.method_5992(player, hand) == class_1269.field_5811) {
            if (itemstack != null && itemstack.method_7909() == IafItems.DRAGON_STAFF && this.method_6171((class_1309)player)) {
                if (player.method_5715()) {
                    this.homePos = this.method_24515();
                    this.hasHomePosition = true;
                    player.method_7353((class_2561)class_2561.method_43469((String)"amphithere.command.new_home", (Object[])new Object[]{this.homePos.method_10263(), this.homePos.method_10264(), this.homePos.method_10260()}), true);
                    return class_1269.field_5812;
                }
                return class_1269.field_5812;
            }
            if (player.method_5715() && this.method_6171((class_1309)player)) {
                if (player.method_5998(hand).method_7960()) {
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() > 2) {
                        this.setCommand(0);
                    }
                    player.method_7353((class_2561)class_2561.method_43471((String)("amphithere.command." + this.getCommand())), true);
                    this.method_5783(class_3417.field_14986, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
                return class_1269.field_5812;
            }
            if (!(this.method_6181() && !this.method_6171((class_1309)player) || this.method_6109())) {
                assert (itemstack != null);
                if (itemstack.method_7960()) {
                    player.method_5804((class_1297)this);
                    return class_1269.field_5812;
                }
            }
        }
        return super.method_5992(player, hand);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new AmphithereAIAttackMelee(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new AmphithereAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_6201.method_6277(3, (class_1352)new AmphithereAIFleePlayer(this, 32.0f, 0.8, 1.8));
        this.field_6201.method_6277(3, (class_1352)new AIFlyWander());
        this.field_6201.method_6277(3, (class_1352)new AIFlyCircle());
        this.field_6201.method_6277(3, (class_1352)new AILandWander((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new EntityAIWatchClosestIgnoreRider((class_1308)this, class_1309.class, 6.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new AmphithereAIHurtByTarget(this, false, new Class[0]));
        this.field_6185.method_6277(3, new AmphithereAITargetItems((class_1308)this, false));
    }

    public boolean isStill() {
        return Math.abs(this.method_18798().field_1352) < 0.05 && Math.abs(this.method_18798().field_1350) < 0.05;
    }

    protected void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = new class_1410((class_1308)this, this.method_37908());
            this.navigatorType = 0;
        } else if (navigatorType == 1) {
            this.field_6207 = new FlyMoveHelper(this);
            this.field_6189 = new PathNavigateFlyingCreature((class_1308)this, this.method_37908());
            this.navigatorType = 1;
        } else {
            this.field_6207 = new class_1331((class_1308)this, 20, false);
            this.field_6189 = new PathNavigateFlyingCreature((class_1308)this, this.method_37908());
            this.navigatorType = 2;
        }
    }

    public boolean onLeaves() {
        class_2680 state = this.method_37908().method_8320(this.method_24515().method_10074());
        return state.method_26204() instanceof class_2397;
    }

    public boolean method_5643(class_1282 source, float damage) {
        if (!this.method_6181() && this.isFlying() && !this.method_24828() && source.method_48789(class_8103.field_42247) && !this.method_37908().field_9236) {
            this.isFallen = true;
        }
        if (source.method_5529() instanceof class_1309 && source.method_5529().method_5794((class_1297)this) && this.method_6181() && this.method_6171((class_1309)source.method_5529())) {
            return false;
        }
        return super.method_5643(source, damage);
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (this.method_5626(passenger) && this.method_6181()) {
            this.method_5636(passenger.method_36454());
            this.method_5847(passenger.method_5791());
        }
        if (!this.method_37908().field_9236 && !this.method_6181() && passenger instanceof class_1657 && this.getAnimation() == NO_ANIMATION && this.field_5974.method_43048(15) == 0) {
            this.setAnimation(ANIMATION_BITE_RIDER);
        }
        if (!this.method_37908().field_9236 && this.getAnimation() == ANIMATION_BITE_RIDER && this.getAnimationTick() == 6 && !this.method_6181()) {
            passenger.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), 1.0f);
        }
        float pitch_forward = this.method_36455() > 0.0f && this.isFlying() ? this.method_36455() / 45.0f * 0.45f : 0.0f;
        float scaled_ground = this.groundProgress * 0.1f;
        float radius = (this.method_6181() ? 0.5f : 0.3f) - scaled_ground * 0.5f + pitch_forward;
        float angle = (float)Math.PI / 180 * this.field_6283;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        passenger.method_5814(this.method_23317() + extraX, this.method_23318() + (double)0.7f - (double)(scaled_ground * 0.14f) + (double)pitch_forward, this.method_23321() + extraZ);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(IafItemTags.BREED_AMPITHERE);
    }

    public void method_6007() {
        boolean notGrounded;
        super.method_6007();
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_5980(null);
        }
        if (this.method_5799() && this.field_6282) {
            this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 + 0.1, this.method_18798().field_1350);
        }
        if (this.method_6109() && this.method_5968() != null) {
            this.method_5980(null);
        }
        if (this.method_6479()) {
            this.setFlying(false);
        }
        if (this.method_24345() && this.method_5968() != null) {
            this.method_5980(null);
        }
        boolean flapping = this.method_5776();
        boolean flying = this.isFlying() && this.isOverAir() || this.isOverAir() && !this.onLeaves();
        boolean diving = flying && this.method_18798().field_1351 <= (double)-0.1f || this.isFallen;
        boolean sitting = this.method_24345() && !this.isFlying();
        boolean bl = notGrounded = flying || this.getAnimation() == ANIMATION_WING_BLAST;
        if (!this.method_37908().field_9236) {
            if (this.method_24345() && (this.getCommand() != 1 || this.method_5642() != null)) {
                this.method_24346(false);
            }
            if (!this.method_24345() && this.getCommand() == 1 && this.method_5642() == null) {
                this.method_24346(true);
            }
            if (this.method_24345()) {
                this.method_5942().method_6340();
            }
            this.ticksFlying = flying ? ++this.ticksFlying : 0;
        }
        if (this.isFlying() && this.method_24828()) {
            this.setFlying(false);
        }
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.flightCooldown > 0) {
            --this.flightCooldown;
        }
        if (!this.method_37908().field_9236) {
            this.ticksCircling = this.flightBehavior == FlightBehavior.CIRCLE ? ++this.ticksCircling : 0;
        }
        if (this.getUntamedRider() != null && !this.method_6181()) {
            ++this.ridingTime;
        }
        if (this.getUntamedRider() == null) {
            this.ridingTime = 0;
        }
        if (!this.method_6181() && this.ridingTime > (Integer)IafCommonConfig.INSTANCE.amphithere.tameTime.getValue() && this.getUntamedRider() != null && this.getUntamedRider() instanceof class_1657) {
            this.method_37908().method_8421((class_1297)this, (byte)45);
            this.method_6170((class_1657)this.getUntamedRider());
            if (this.method_5968() == this.getUntamedRider()) {
                this.method_5980(null);
            }
        }
        this.ticksStill = this.isStill() ? ++this.ticksStill : 0;
        if (!this.isFlying() && !this.method_6109() && (this.method_24828() && this.field_5974.method_43048(200) == 0 && this.flightCooldown == 0 && this.method_5685().isEmpty() && !this.method_5987() && this.canMove() || this.method_23318() < -1.0)) {
            this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 + 0.5, this.method_18798().field_1350);
            this.setFlying(true);
        }
        if (this.method_5642() != null && this.isFlying() && !this.method_24828()) {
            if (this.method_5642().method_36455() > 25.0f && this.method_18798().field_1351 > -1.0) {
                this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 - 0.1, this.method_18798().field_1350);
            }
            if (this.method_5642().method_36455() < -25.0f && this.method_18798().field_1351 < 1.0) {
                this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 + 0.1, this.method_18798().field_1350);
            }
        }
        if (notGrounded && this.groundProgress > 0.0f) {
            this.groundProgress -= 2.0f;
        } else if (!notGrounded && this.groundProgress < 20.0f) {
            this.groundProgress += 2.0f;
        }
        if (diving && this.diveProgress < 20.0f) {
            this.diveProgress += 1.0f;
        } else if (!diving && this.diveProgress > 0.0f) {
            this.diveProgress -= 1.0f;
        }
        if (this.isFallen && this.flightBehavior != FlightBehavior.NONE) {
            this.flightBehavior = FlightBehavior.NONE;
        }
        if (this.flightBehavior == FlightBehavior.NONE && this.method_5642() == null && this.isFlying()) {
            this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 - 0.3, this.method_18798().field_1350);
        }
        if (this.isFlying() && !this.method_24828() && this.isFallen && this.method_5642() == null) {
            this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 - 0.2, this.method_18798().field_1350);
            this.method_36457(Math.max(this.method_36455() + 5.0f, 75.0f));
        }
        if (this.isFallen && this.method_24828()) {
            this.setFlying(false);
            this.flightCooldown = this.method_6181() ? 50 : 12000;
            this.isFallen = false;
        }
        if (flying && this.isOverAir()) {
            if (this.getRidingPlayer() == null && this.navigatorType != 1) {
                this.switchNavigator(1);
            }
            if (this.getRidingPlayer() != null && this.navigatorType != 2) {
                this.switchNavigator(2);
            }
        }
        if (!flying && this.navigatorType != 0) {
            this.switchNavigator(0);
        }
        if ((this.hasHomePosition || this.getCommand() == 2) && this.flightBehavior == FlightBehavior.WANDER) {
            this.flightBehavior = FlightBehavior.CIRCLE;
        }
        if (flapping && this.flapProgress < 10.0f) {
            this.flapProgress += 1.0f;
        } else if (!flapping && this.flapProgress > 0.0f) {
            this.flapProgress -= 1.0f;
        }
        if (this.flapTicks > 0) {
            --this.flapTicks;
        }
        if (this.method_37908().field_9236) {
            if (!this.method_24828()) {
                if (this.method_5782()) {
                    this.roll_buffer.calculateChainFlapBufferHead(40.0f, 1, 2.0f, 0.5f, (class_1309)this);
                } else {
                    this.field_6283 = this.method_36454();
                    this.roll_buffer.calculateChainFlapBuffer(70.0f, 1, 2.0f, 0.5f, (class_1309)this);
                }
                this.pitch_buffer.calculateChainPitchBuffer(90.0f, 10, 10.0f, 0.5f, (class_1309)this);
            }
            this.tail_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (class_1309)this);
        }
        if (this.changedFlightBehavior) {
            this.changedFlightBehavior = false;
        }
        if (!flapping && (this.method_18798().field_1351 > (double)0.15f || this.method_18798().field_1351 > 0.0 && this.field_6012 % 200 == 0) && this.isOverAir()) {
            this.flapWings();
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
    }

    public boolean method_5776() {
        return this.flapTicks > 0;
    }

    public int getCommand() {
        return (Integer)this.field_6011.method_12789(COMMAND);
    }

    public void setCommand(int command) {
        this.field_6011.method_12778(COMMAND, (Object)command);
        this.method_24346(command == 1);
    }

    @Override
    public void flapWings() {
        this.flapTicks = 20;
    }

    @Override
    public boolean isFlapping() {
        return this.method_5776();
    }

    public boolean method_24345() {
        if (this.method_37908().field_9236) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_6011.method_12789(field_6322) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void method_24346(boolean sitting) {
        if (!this.method_37908().field_9236) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_6011.method_12789(field_6322);
        if (sitting) {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b0 | 1)));
        } else {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public class_1309 method_5642() {
        for (class_1297 passenger : this.method_5685()) {
            if (!(passenger instanceof class_1657)) continue;
            class_1657 player = (class_1657)passenger;
            if (this.method_5968() == passenger || !this.method_6181() || this.method_6139() == null || !this.method_6139().equals(player.method_5667())) continue;
            return player;
        }
        return null;
    }

    public class_1297 getUntamedRider() {
        for (class_1297 passenger : this.method_5685()) {
            if (!(passenger instanceof class_1657)) continue;
            return passenger;
        }
        return null;
    }

    public boolean method_5722(class_1297 entityIn) {
        if (this.method_6181()) {
            class_1309 livingentity = this.method_35057();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof class_1321) {
                class_1321 tameable = (class_1321)entityIn;
                return tameable.method_6171(livingentity);
            }
            if (livingentity != null) {
                return livingentity.method_5722(entityIn);
            }
        }
        return super.method_5722(entityIn);
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(((Double)IafCommonConfig.INSTANCE.amphithere.maxHealth.getValue()).doubleValue());
        this.method_5996(class_5134.field_23721).method_6192(((Double)IafCommonConfig.INSTANCE.amphithere.attackDamage.getValue()).doubleValue());
        this.method_5996(class_5134.field_23720).method_6192(((Double)IafCommonConfig.INSTANCE.amphithere.flightSpeed.getValue()).doubleValue());
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(FLAP_TICKS, (Object)0);
        this.field_6011.method_12784(CONTROL_STATE, (Object)0);
        this.field_6011.method_12784(COMMAND, (Object)0);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant());
        compound.method_10556("Flying", this.isFlying());
        compound.method_10569("FlightCooldown", this.flightCooldown);
        compound.method_10569("RidingTime", this.ridingTime);
        compound.method_10556("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.method_10569("HomeAreaX", this.homePos.method_10263());
            compound.method_10569("HomeAreaY", this.homePos.method_10264());
            compound.method_10569("HomeAreaZ", this.homePos.method_10260());
        }
        compound.method_10569("Command", this.getCommand());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_10550("Variant"));
        this.setFlying(compound.method_10577("Flying"));
        this.flightCooldown = compound.method_10550("FlightCooldown");
        this.ridingTime = compound.method_10550("RidingTime");
        this.hasHomePosition = compound.method_10577("HasHomePosition");
        if (this.hasHomePosition && compound.method_10550("HomeAreaX") != 0 && compound.method_10550("HomeAreaY") != 0 && compound.method_10550("HomeAreaZ") != 0) {
            this.homePos = new class_2338(compound.method_10550("HomeAreaX"), compound.method_10550("HomeAreaY"), compound.method_10550("HomeAreaZ"));
        }
        this.setCommand(compound.method_10550("Command"));
        this.setConfigurableAttributes();
    }

    public boolean getCanSpawnHere() {
        int i = class_3532.method_15357((double)this.method_23317());
        int j = class_3532.method_15357((double)this.method_5829().field_1322);
        int k = class_3532.method_15357((double)this.method_23321());
        class_2338 blockpos = new class_2338(i, j, k);
        class_2248 block = this.method_37908().method_8320(blockpos.method_10074()).method_26204();
        return this.method_37908().method_22348(blockpos.method_10084());
    }

    public void method_5773() {
        double dist;
        super.method_5773();
        class_1309 target = this.method_5968();
        if (target != null && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 7 && (dist = this.method_5858((class_1297)target)) < 10.0) {
            target.method_6005((double)0.6f, (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            target.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
        }
        if (this.getAnimation() == ANIMATION_WING_BLAST && this.getAnimationTick() == 5) {
            this.method_5783(IafSounds.AMPHITHERE_GUST, 1.0f, 1.0f);
        }
        if ((this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_BITE_RIDER) && this.getAnimationTick() == 1) {
            this.method_5783(IafSounds.AMPHITHERE_BITE, 1.0f, 1.0f);
        }
        if (target != null && this.getAnimation() == ANIMATION_WING_BLAST && this.getAnimationTick() > 5 && this.getAnimationTick() < 22 && (dist = this.method_5858((class_1297)target)) < 25.0) {
            target.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()) / 2.0f);
            target.field_6007 = true;
            if (!(this.field_5974.method_43058() < this.method_5996(class_5134.field_23718).method_6194())) {
                this.field_6007 = true;
                double d1 = target.method_23317() - this.method_23317();
                double d0 = target.method_23321() - this.method_23321();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                class_243 Vector3d = this.method_18798();
                class_243 Vector3d1 = new class_243(d0, 0.0, d1).method_1029().method_1021(0.5);
                this.method_18800(Vector3d.field_1352 / 2.0 - Vector3d1.field_1352, this.method_24828() ? Math.min(0.4, Vector3d.field_1351 / 2.0 + 0.5) : Vector3d.field_1351, Vector3d.field_1350 / 2.0 - Vector3d1.field_1350);
            }
        }
        if (this.getAnimation() == ANIMATION_TAIL_WHIP && target != null && this.getAnimationTick() == 7 && (dist = this.method_5858((class_1297)target)) < 10.0) {
            target.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            target.field_6007 = true;
            float f = class_3532.method_15355((float)0.5f);
            double d1 = target.method_23317() - this.method_23317();
            double d0 = target.method_23321() - this.method_23321();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            class_243 Vector3d = this.method_18798();
            class_243 Vector3d1 = new class_243(d0, 0.0, d1).method_1029().method_1021(0.5);
            this.method_18800(Vector3d.field_1352 / 2.0 - Vector3d1.field_1352, this.method_24828() ? Math.min(0.4, Vector3d.field_1351 / 2.0 + 0.5) : Vector3d.field_1351, Vector3d.field_1350 / 2.0 - Vector3d1.field_1350);
        }
        if (this.isGoingUp() && !this.method_37908().field_9236 && !this.isFlying()) {
            this.method_18799(this.method_18798().method_1031(0.0, 1.0, 0.0));
            this.setFlying(true);
        }
        if (!this.isOverAir() && this.isFlying() && this.ticksFlying > 25) {
            this.setFlying(false);
        }
        if (this.dismountIAF() && this.isFlying() && this.method_24828()) {
            this.setFlying(false);
        }
        if (this.getUntamedRider() != null && this.getUntamedRider().method_5715()) {
            class_1297 class_12972 = this.getUntamedRider();
            if (class_12972 instanceof class_1309) {
                class_1309 rider = (class_1309)class_12972;
                EntityDataComponent data = EntityDataComponent.get(rider);
                data.miscData.setDismounted(true);
            }
            this.getUntamedRider().method_5848();
        }
        if (this.attack() && this.method_5642() != null && this.method_5642() instanceof class_1657) {
            class_1309 riderTarget = DragonUtils.riderLookingAtEntity((class_1309)this, this.method_5642(), 2.5);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
            }
            if (riderTarget != null) {
                riderTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            }
        }
        if (target != null && this.method_6171(target)) {
            this.method_5980(null);
        }
        if (target != null && this.method_24828() && this.isFlying() && this.ticksFlying > 40) {
            this.setFlying(false);
        }
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_TAIL_WHIP && this.getAnimation() != ANIMATION_WING_BLAST && this.method_5642() == null) {
            if (this.field_5974.method_43056()) {
                this.setAnimation(ANIMATION_BITE);
            } else {
                this.setAnimation(this.method_6051().method_43056() || this.isFlying() ? ANIMATION_WING_BLAST : ANIMATION_TAIL_WHIP);
            }
            return true;
        }
        return false;
    }

    @Override
    public class_1657 getRidingPlayer() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    @Override
    public boolean isFlying() {
        if (this.method_37908().field_9236) {
            this.isFlying = (Boolean)this.field_6011.method_12789(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
        if (!this.method_37908().field_9236) {
            this.isFlying = flying;
        }
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean dismountIAF() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 3 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
        this.setStateField(1, down);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(3, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_6011.method_12789(CONTROL_STATE);
        if (newState) {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.field_6011.method_12789(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.field_6011.method_12778(CONTROL_STATE, (Object)state);
    }

    protected class_3414 method_5994() {
        return IafSounds.AMPHITHERE_IDLE;
    }

    protected class_3414 method_6011(class_1282 source) {
        return IafSounds.AMPHITHERE_HURT;
    }

    protected class_3414 method_6002() {
        return IafSounds.AMPHITHERE_DIE;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_BITE_RIDER, ANIMATION_WING_BLAST, ANIMATION_TAIL_WHIP, ANIMATION_SPEAK};
    }

    public void method_5966() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_5966();
    }

    protected void method_6013(class_1282 source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_6013(source);
    }

    public boolean isBlinking() {
        return this.field_6012 % 50 > 40;
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageableEntity) {
        EntityAmphithere amphithere = new EntityAmphithere(IafEntities.AMPHITHERE, this.method_37908());
        amphithere.setVariant(this.getVariant());
        return amphithere;
    }

    public int method_6110() {
        return 10;
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.method_6051().method_43048(5));
        return spawnDataIn;
    }

    @Override
    public boolean canPhaseThroughBlock(class_1936 world, class_2338 pos) {
        return world.method_8320(pos).method_26204() instanceof class_2397;
    }

    protected float method_49485(class_1657 pPlayer) {
        return this.isFlying() || this.isHovering() ? (float)this.method_26825(class_5134.field_23720) * 2.0f : (float)this.method_26825(class_5134.field_23719) * 0.5f;
    }

    public void method_6091(class_243 travelVector) {
        if (this.method_5787()) {
            if (this.method_5799()) {
                this.method_5724(0.02f, travelVector);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.8f));
            } else if (this.method_5771()) {
                this.method_5724(0.02f, travelVector);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.5));
            } else if (this.isFlying() || this.isHovering()) {
                this.method_5724(0.1f, travelVector);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.9));
            } else {
                super.method_6091(travelVector);
            }
        } else {
            super.method_6091(travelVector);
        }
    }

    protected void method_49481(class_1657 player, class_243 travelVector) {
        super.method_49481(player, travelVector);
        class_241 vec2 = this.getRiddenRotation((class_1309)player);
        this.method_5710(vec2.field_1342, vec2.field_1343);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        if (this.method_5787()) {
            float vertical;
            class_243 vec3 = this.method_18798();
            float f = this.isGoingUp() ? 0.2f : (vertical = this.isGoingDown() ? -0.2f : 0.0f);
            if (!this.isFlying() && !this.isHovering()) {
                vertical = (float)travelVector.field_1351;
            }
            this.method_18799(vec3.method_1031(0.0, (double)vertical, 0.0));
        }
    }

    protected class_243 method_49482(class_1657 player, class_243 travelVector) {
        float f = player.field_6212 * 0.5f;
        float f1 = player.field_6250;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new class_243((double)f, 0.0, (double)f1);
    }

    protected class_241 getRiddenRotation(class_1309 entity) {
        return new class_241(entity.method_36455() * 0.5f, entity.method_36454());
    }

    public boolean canMove() {
        return this.method_5642() == null && this.sitProgress == 0.0f && !this.method_24345();
    }

    public void method_5711(byte id) {
        if (id == 45) {
            this.playEffect();
        } else {
            super.method_5711(id);
        }
    }

    protected void playEffect() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            double d2 = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d1, d2);
        }
    }

    @Override
    public void onHearFlute(class_1657 player) {
        if (!this.method_24828() && this.method_6181()) {
            this.isFallen = true;
        }
    }

    public boolean method_5947() {
        return true;
    }

    @Override
    public double getFlightSpeedModifier() {
        return 0.555;
    }

    @Override
    public boolean fliesLikeElytra() {
        return !this.method_24828();
    }

    private boolean isOverAir() {
        return this.method_37908().method_22347(this.method_24515().method_10074());
    }

    public boolean canBlockPosBeSeen(class_2338 pos) {
        class_243 Vector3d = new class_243(this.method_23317(), this.method_23320(), this.method_23321());
        class_243 Vector3d1 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        return this.method_37908().method_17742(new class_3959(Vector3d, Vector3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public static enum FlightBehavior {
        CIRCLE,
        WANDER,
        NONE;

    }

    class AIFlyWander
    extends class_1352 {
        class_2338 target;

        public boolean method_6264() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.WANDER || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                this.target = EntityAmphithere.getPositionRelativetoGround((class_1297)EntityAmphithere.this, EntityAmphithere.this.method_37908(), EntityAmphithere.this.method_31477() + EntityAmphithere.this.field_5974.method_43048(30) - 15, EntityAmphithere.this.method_31479() + EntityAmphithere.this.field_5974.method_43048(30) - 15, EntityAmphithere.this.field_5974);
                EntityAmphithere.this.orbitPos = null;
                return !EntityAmphithere.this.method_5962().method_6241() || EntityAmphithere.this.ticksStill >= 50;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints(class_1297 e) {
            return EntityAmphithere.this.canBlockPosBeSeen(this.target);
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6268() {
            if (!this.isDirectPathBetweenPoints((class_1297)EntityAmphithere.this)) {
                this.target = EntityAmphithere.getPositionRelativetoGround((class_1297)EntityAmphithere.this, EntityAmphithere.this.method_37908(), EntityAmphithere.this.method_31477() + EntityAmphithere.this.field_5974.method_43048(30) - 15, EntityAmphithere.this.method_31479() + EntityAmphithere.this.field_5974.method_43048(30) - 15, EntityAmphithere.this.field_5974);
            }
            if (EntityAmphithere.this.method_37908().method_22347(this.target)) {
                EntityAmphithere.this.field_6207.method_6239((double)this.target.method_10263() + 0.5, (double)this.target.method_10264() + 0.5, (double)this.target.method_10260() + 0.5, 0.25);
                if (EntityAmphithere.this.method_5968() == null) {
                    EntityAmphithere.this.method_5988().method_6230((double)this.target.method_10263() + 0.5, (double)this.target.method_10264() + 0.5, (double)this.target.method_10260() + 0.5, 180.0f, 20.0f);
                }
            }
        }

        public boolean method_38846() {
            return true;
        }
    }

    class AIFlyCircle
    extends class_1352 {
        class_2338 target;

        public boolean method_6264() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.CIRCLE || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                EntityAmphithere.this.orbitPos = EntityAmphithere.getPositionRelativetoGround((class_1297)EntityAmphithere.this, EntityAmphithere.this.method_37908(), EntityAmphithere.this.method_31477() + EntityAmphithere.this.field_5974.method_43048(30) - 15, EntityAmphithere.this.method_31479() + EntityAmphithere.this.field_5974.method_43048(30) - 15, EntityAmphithere.this.field_5974);
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.method_37908(), EntityAmphithere.this.orbitPos, EntityAmphithere.this.field_5974);
                return true;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints() {
            return EntityAmphithere.this.canBlockPosBeSeen(this.target);
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6268() {
            if (!this.isDirectPathBetweenPoints()) {
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.method_37908(), EntityAmphithere.this.orbitPos, EntityAmphithere.this.field_5974);
            }
            if (EntityAmphithere.this.method_37908().method_22347(this.target)) {
                EntityAmphithere.this.field_6207.method_6239((double)this.target.method_10263() + 0.5, (double)this.target.method_10264() + 0.5, (double)this.target.method_10260() + 0.5, 0.25);
                if (EntityAmphithere.this.method_5968() == null) {
                    EntityAmphithere.this.method_5988().method_6230((double)this.target.method_10263() + 0.5, (double)this.target.method_10264() + 0.5, (double)this.target.method_10260() + 0.5, 180.0f, 20.0f);
                }
            }
        }

        public boolean method_38846() {
            return true;
        }
    }

    static class AILandWander
    extends class_1394 {
        public AILandWander(class_1314 creature, double speed) {
            super(creature, speed, 10.0f);
        }

        public boolean method_6264() {
            return this.field_6566.method_24828() && super.method_6264() && ((EntityAmphithere)this.field_6566).canMove();
        }

        public boolean method_38846() {
            return true;
        }
    }

    class FlyMoveHelper
    extends class_1335 {
        public FlyMoveHelper(EntityAmphithere entity) {
            super((class_1308)entity);
            this.field_6372 = 1.75;
        }

        public void method_6240() {
            if (!EntityAmphithere.this.canMove()) {
                return;
            }
            if (EntityAmphithere.this.field_5976) {
                EntityAmphithere.this.method_36456(EntityAmphithere.this.method_36454() + 180.0f);
                this.field_6372 = 0.1f;
                class_2338 target = EntityAmphithere.getPositionRelativetoGround((class_1297)EntityAmphithere.this, EntityAmphithere.this.method_37908(), EntityAmphithere.this.method_31477() + EntityAmphithere.this.field_5974.method_43048(15) - 7, EntityAmphithere.this.method_31479() + EntityAmphithere.this.field_5974.method_43048(15) - 7, EntityAmphithere.this.field_5974);
                this.field_6370 = target.method_10263();
                this.field_6369 = target.method_10264();
                this.field_6367 = target.method_10260();
            }
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                double d0 = this.field_6370 - EntityAmphithere.this.method_23317();
                double d1 = this.field_6369 - EntityAmphithere.this.method_23318();
                double d2 = this.field_6367 - EntityAmphithere.this.method_23321();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)class_3532.method_15355((float)((float)d3))) < 6.0 && EntityAmphithere.this.method_5968() == null) {
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.WANDER && EntityAmphithere.this.field_5974.method_43048(30) == 0) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.CIRCLE && EntityAmphithere.this.field_5974.method_43048(5) == 0 && EntityAmphithere.this.ticksCircling > 150) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.WANDER;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (EntityAmphithere.this.hasHomePosition && EntityAmphithere.this.flightBehavior != FlightBehavior.NONE || EntityAmphithere.this.getCommand() == 2) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                    }
                }
                if (d3 < 1.0 && EntityAmphithere.this.method_5968() == null) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    EntityAmphithere.this.method_18799(EntityAmphithere.this.method_18798().method_18805(0.5, 0.5, 0.5));
                } else {
                    EntityAmphithere.this.method_18799(EntityAmphithere.this.method_18798().method_1031(d0 / d3 * 0.5 * this.field_6372, d1 / d3 * 0.5 * this.field_6372, d2 / d3 * 0.5 * this.field_6372));
                    float f1 = (float)(-(class_3532.method_15349((double)d1, (double)d3) * 57.29577951308232));
                    EntityAmphithere.this.method_36457(f1);
                    if (EntityAmphithere.this.method_5968() == null) {
                        EntityAmphithere.this.method_36456(-((float)class_3532.method_15349((double)EntityAmphithere.this.method_18798().field_1352, (double)EntityAmphithere.this.method_18798().field_1350)) * 57.295776f);
                    } else {
                        double d4 = EntityAmphithere.this.method_5968().method_23317() - EntityAmphithere.this.method_23317();
                        double d5 = EntityAmphithere.this.method_5968().method_23321() - EntityAmphithere.this.method_23321();
                        EntityAmphithere.this.method_36456(-((float)class_3532.method_15349((double)d4, (double)d5)) * 57.295776f);
                    }
                    EntityAmphithere.this.field_6283 = EntityAmphithere.this.method_36454();
                }
            }
        }
    }
}

