/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntitySlowPart;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIAttack;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIFindSandTarget;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIGetInSand;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIJump;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAITarget;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIWander;
import com.iafenvoy.iceandfire.entity.ai.DeathwormAITargetItems;
import com.iafenvoy.iceandfire.entity.ai.EntityGroundAIRide;
import com.iafenvoy.iceandfire.entity.ai.IAFLookHelper;
import com.iafenvoy.iceandfire.entity.pathfinding.PathNavigateDeathWormLand;
import com.iafenvoy.iceandfire.entity.pathfinding.PathNavigateDeathWormSand;
import com.iafenvoy.iceandfire.entity.util.BlockLaunchExplosion;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.EntityUtil;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.IGroundMount;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.object.entity.collision.ICustomCollisions;
import com.iafenvoy.uranus.util.RandomHelper;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2376;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.minecraft.class_8111;

public class EntityDeathWorm
extends class_1321
implements ISyncMount,
ICustomCollisions,
IBlacklistedFromStatues,
IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IGroundMount,
IHasCustomizableAttributes,
ICustomMoveController {
    public static final class_2960 TAN_LOOT = new class_2960("iceandfire", "entities/deathworm_tan");
    public static final class_2960 WHITE_LOOT = new class_2960("iceandfire", "entities/deathworm_white");
    public static final class_2960 RED_LOOT = new class_2960("iceandfire", "entities/deathworm_red");
    public static final class_2960 TAN_GIANT_LOOT = new class_2960("iceandfire", "entities/deathworm_tan_giant");
    public static final class_2960 WHITE_GIANT_LOOT = new class_2960("iceandfire", "entities/deathworm_white_giant");
    public static final class_2960 RED_GIANT_LOOT = new class_2960("iceandfire", "entities/deathworm_red_giant");
    public static final Animation ANIMATION_BITE = Animation.create((int)10);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(EntityDeathWorm.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> SCALE = class_2945.method_12791(EntityDeathWorm.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> JUMP_TICKS = class_2945.method_12791(EntityDeathWorm.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Byte> CONTROL_STATE = class_2945.method_12791(EntityDeathWorm.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> WORM_AGE = class_2945.method_12791(EntityDeathWorm.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> HOME = class_2945.method_12791(EntityDeathWorm.class, (class_2941)class_2943.field_13324);
    private final class_1333 lookHelper;
    public ChainBuffer tail_buffer;
    public float jumpProgress;
    public float prevJumpProgress;
    public DeathwormAITargetItems<?> targetItemsGoal;
    private int animationTick;
    private boolean willExplode = false;
    private int ticksTillExplosion = 60;
    private Animation currentAnimation;
    private final EntitySlowPart[] segments = new EntitySlowPart[7];
    private boolean isSandNavigator;
    private int growthCounter = 0;
    private class_1657 thrower;

    public EntityDeathWorm(class_1299<EntityDeathWorm> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_5941(class_7.field_7, 2.0f);
        this.method_5941(class_7.field_18, 4.0f);
        this.method_5941(class_7.field_4, 4.0f);
        this.lookHelper = new IAFLookHelper((class_1308)this);
        this.field_5985 = true;
        if (worldIn.field_9236) {
            this.tail_buffer = new ChainBuffer();
        }
        this.method_49477(1.0f);
        this.switchNavigator(false);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue()).doubleValue()).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23721, ((Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue()).doubleValue()).method_26868(class_5134.field_23717, (double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue()).method_26868(class_5134.field_23724, 3.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, new EntityGroundAIRide<EntityDeathWorm>(this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DeathWormAIAttack(this));
        this.field_6201.method_6277(3, (class_1352)new DeathWormAIJump(this, 12));
        this.field_6201.method_6277(4, (class_1352)new DeathWormAIFindSandTarget(this, 10));
        this.field_6201.method_6277(5, (class_1352)new DeathWormAIGetInSand(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new DeathWormAIWander(this, 1.0));
        this.field_6185.method_6277(2, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.targetItemsGoal = new DeathwormAITargetItems(this, false, false);
        this.field_6185.method_6277(4, this.targetItemsGoal);
        this.field_6185.method_6277(5, new DeathWormAITarget<class_1309>(this, class_1309.class, false, input -> {
            if (this.method_6181()) {
                return input instanceof class_1588;
            }
            if (input != null) {
                if (input.method_5799() || !DragonUtils.isAlive(input) || this.method_6171((class_1309)input)) {
                    return false;
                }
                if (input instanceof class_1657 || input instanceof class_1429) {
                    return true;
                }
                return (Boolean)IafCommonConfig.INSTANCE.deathworm.attackMonsters.getValue();
            }
            return false;
        }));
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(Math.max(6.0, (Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue()));
        this.method_5996(class_5134.field_23721).method_6192(Math.max(1.0, (Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue()));
        this.method_5996(class_5134.field_23717).method_6192((double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue());
    }

    public class_1333 method_5988() {
        return this.lookHelper;
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public boolean getCanSpawnHere() {
        int i = class_3532.method_15357((double)this.method_23317());
        int j = class_3532.method_15357((double)this.method_5829().field_1322);
        int k = class_3532.method_15357((double)this.method_23321());
        class_2338 blockpos = new class_2338(i, j, k);
        this.method_37908().method_8320(blockpos.method_10074()).method_26164(class_3481.field_15466);
        return this.method_37908().method_8320(blockpos.method_10074()).method_26164(class_3481.field_15466) && this.method_37908().method_22339(blockpos) > 8;
    }

    public void onUpdateParts() {
        if (this.method_31481()) {
            return;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] != null && !this.segments[i].method_31481()) continue;
            this.segments[i] = new EntitySlowPart((class_1297)this, -0.8f - (float)i * 0.8f, 0.0f, 0.0f, 0.7f, 0.7f, 1.0f);
            this.segments[i].method_5719((class_1297)this);
            this.segments[i].setParent((class_1297)this);
            this.segments[i].updateScale(this.method_17825());
            this.method_37908().method_8649((class_1297)this.segments[i]);
        }
        for (EntitySlowPart entity : this.segments) {
            EntityUtil.updatePart(entity, (class_1309)this);
        }
    }

    public void updateScale(float scale) {
        for (EntitySlowPart entity : this.segments) {
            if (entity == null || entity.method_31481()) continue;
            entity.updateScale(scale);
        }
    }

    public int method_6110() {
        return this.method_17825() > 3.0f ? 20 : 10;
    }

    private void clearSegments() {
        for (EntitySlowPart entity : this.segments) {
            if (entity == null || entity.method_31481()) continue;
            entity.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public void setExplosive(boolean explosive, class_1657 thrower) {
        this.willExplode = true;
        this.ticksTillExplosion = 60;
        this.thrower = thrower;
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.method_5783(this.method_17825() > 3.0f ? IafSounds.DEATHWORM_GIANT_ATTACK : IafSounds.DEATHWORM_ATTACK, 1.0f, 1.0f);
        }
        if (this.method_6051().method_43048(3) == 0 && this.method_17825() > 1.0f && this.method_37908().method_8450().method_8355(class_1928.field_19388) && !((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((class_1309)this, entityIn.method_23317(), entityIn.method_23318(), entityIn.method_23321())) {
            BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.method_37908(), (class_1308)this, entityIn.method_23317(), entityIn.method_23318(), entityIn.method_23321(), this.method_17825());
            explosion.method_8348();
            explosion.method_8350(true);
        }
        return false;
    }

    public void method_6078(class_1282 cause) {
        this.clearSegments();
        super.method_6078(cause);
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    protected class_2960 method_5991() {
        return switch (this.getVariant()) {
            case 0 -> {
                if (this.method_17825() > 3.0f) {
                    yield TAN_GIANT_LOOT;
                }
                yield TAN_LOOT;
            }
            case 1 -> {
                if (this.method_17825() > 3.0f) {
                    yield RED_GIANT_LOOT;
                }
                yield RED_LOOT;
            }
            case 2 -> {
                if (this.method_17825() > 3.0f) {
                    yield WHITE_GIANT_LOOT;
                }
                yield WHITE_LOOT;
            }
            default -> null;
        };
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageable) {
        return null;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(SCALE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(CONTROL_STATE, (Object)0);
        this.field_6011.method_12784(WORM_AGE, (Object)10);
        this.field_6011.method_12784(HOME, (Object)class_2338.field_10980);
        this.field_6011.method_12784(JUMP_TICKS, (Object)0);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant());
        compound.method_10569("GrowthCounter", this.growthCounter);
        compound.method_10548("Scale", this.getDeathwormScale());
        compound.method_10569("WormAge", this.getWormAge());
        compound.method_10544("WormHome", this.getWormHome().method_10063());
        compound.method_10556("WillExplode", this.willExplode);
        this.clearSegments();
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_10550("Variant"));
        this.growthCounter = compound.method_10550("GrowthCounter");
        this.setDeathWormScale(compound.method_10583("Scale"));
        this.setWormAge(compound.method_10550("WormAge"));
        this.setWormHome(class_2338.method_10092((long)compound.method_10537("WormHome")));
        this.willExplode = compound.method_10577("WillExplode");
        this.setConfigurableAttributes();
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_6011.method_12789(CONTROL_STATE);
        if (newState) {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.field_6011.method_12789(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.field_6011.method_12778(CONTROL_STATE, (Object)state);
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public int getWormJumping() {
        return (Integer)this.field_6011.method_12789(JUMP_TICKS);
    }

    public void setWormJumping(int jump) {
        this.field_6011.method_12778(JUMP_TICKS, (Object)jump);
    }

    public class_2338 getWormHome() {
        return (class_2338)this.field_6011.method_12789(HOME);
    }

    public void setWormHome(class_2338 home) {
        if (home instanceof class_2338) {
            this.field_6011.method_12778(HOME, (Object)home);
        }
    }

    public int getWormAge() {
        return Math.max(1, (Integer)this.field_6011.method_12789(WORM_AGE));
    }

    public void setWormAge(int age) {
        this.field_6011.method_12778(WORM_AGE, (Object)age);
    }

    public float method_17825() {
        return Math.min(this.getDeathwormScale() * ((float)this.getWormAge() / 5.0f), 7.0f);
    }

    public float getDeathwormScale() {
        float scale = ((Float)this.field_6011.method_12789(SCALE)).floatValue();
        if (scale == 0.0f) {
            scale = (float)RandomHelper.nextDouble((double)1.0, (double)7.0);
            this.setDeathWormScale(scale);
        }
        return scale;
    }

    public void setDeathWormScale(float scale) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
        this.updateScale(scale * ((float)this.getWormAge() / 5.0f));
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.method_6051().method_43048(3));
        float size = 0.25f + (float)(Math.random() * (double)0.35f);
        this.setDeathWormScale(this.method_6051().method_43048(20) == 0 ? size * 4.0f : size);
        return spawnDataIn;
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (this.method_5626(passenger)) {
            this.method_5636(passenger.method_36454());
            float radius = -0.5f * this.method_17825();
            float angle = (float)Math.PI / 180 * this.field_6283;
            double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * class_3532.method_15362((float)angle);
            passenger.method_5814(this.method_23317() + extraX, this.method_23318() + (double)this.method_5751() - (double)0.55f, this.method_23321() + extraZ);
        }
    }

    public class_1309 method_5642() {
        for (class_1297 passenger : this.method_5685()) {
            if (!(passenger instanceof class_1657)) continue;
            class_1657 player = (class_1657)passenger;
            return player;
        }
        return null;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (this.getWormAge() > 4 && player.method_5854() == null && player.method_6047().method_7909() == class_1802.field_8378 && player.method_6079().method_7909() == class_1802.field_8378 && !this.method_37908().field_9236) {
            player.method_5804((class_1297)this);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private void switchNavigator(boolean inSand) {
        if (inSand) {
            this.field_6207 = new SandMoveHelper();
            this.field_6189 = new PathNavigateDeathWormSand(this, this.method_37908());
            this.isSandNavigator = true;
        } else {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = new PathNavigateDeathWormLand(this, this.method_37908());
            this.isSandNavigator = false;
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42340) || source.method_49708(class_8111.field_42356)) {
            return false;
        }
        if (this.method_5782() && source.method_5529() != null && this.method_5642() != null && source.method_5529() == this.method_5642()) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void method_5784(class_1313 typeIn, class_243 pos) {
        super.method_5784(typeIn, pos);
    }

    public boolean method_5757() {
        if (this.isInSand()) {
            return false;
        }
        return super.method_5757();
    }

    protected void method_5632(double x, double y, double z) {
        class_2376 blockpos = new class_2376(x, y, z);
        class_2382 vec3i = new class_2382((int)Math.round(blockpos.method_10216()), (int)Math.round(blockpos.method_10214()), (int)Math.round(blockpos.method_10215()));
        class_243 vector3d = new class_243(x - blockpos.method_10216(), y - blockpos.method_10214(), z - blockpos.method_10215());
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        class_2350 direction = class_2350.field_11036;
        double d0 = Double.MAX_VALUE;
        for (class_2350 direction1 : new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, class_2350.field_11036}) {
            double d2;
            blockpos$mutable.method_25505(vec3i, direction1);
            if (this.method_37908().method_8320((class_2338)blockpos$mutable).method_26234((class_1922)this.method_37908(), (class_2338)blockpos$mutable) && !this.method_37908().method_8320((class_2338)blockpos$mutable).method_26164(class_3481.field_15466)) continue;
            double d1 = vector3d.method_18043(direction1.method_10166());
            double d = d2 = direction1.method_10171() == class_2350.class_2352.field_11056 ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_5974.method_43057() * 0.2f + 0.1f;
        float f1 = direction.method_10171().method_10181();
        class_243 vector3d1 = this.method_18798().method_1021(0.75);
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            this.method_18800(f1 * f, vector3d1.field_1351, vector3d1.field_1350);
        } else if (direction.method_10166() == class_2350.class_2351.field_11052) {
            this.method_18800(vector3d1.field_1352, f1 * f, vector3d1.field_1350);
        } else if (direction.method_10166() == class_2350.class_2351.field_11051) {
            this.method_18800(vector3d1.field_1352, vector3d1.field_1351, f1 * f);
        }
    }

    private void updateAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(Math.min(0.2, 0.15 * (double)this.method_17825()));
        this.method_5996(class_5134.field_23721).method_6192(Math.max(1.0, (Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue() * (double)this.method_17825()));
        this.method_5996(class_5134.field_23716).method_6192(Math.max(6.0, (Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue() * (double)this.method_17825()));
        this.method_5996(class_5134.field_23717).method_6192((double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue());
        this.method_6033((float)this.method_5996(class_5134.field_23716).method_6201());
    }

    public boolean method_5874(class_3218 world, class_1309 entity) {
        if (this.method_6181()) {
            this.method_6025(14.0f);
            return false;
        }
        return true;
    }

    public boolean method_5722(class_1297 entityIn) {
        if (this.method_6181()) {
            class_1309 livingentity = this.method_35057();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof class_1321) {
                return ((class_1321)entityIn).method_6171(livingentity);
            }
            if (livingentity != null) {
                return livingentity.method_5722(entityIn);
            }
        }
        return super.method_5722(entityIn);
    }

    public void method_6007() {
        super.method_6007();
        this.prevJumpProgress = this.jumpProgress;
        if (this.getWormJumping() > 0 && this.jumpProgress < 5.0f) {
            this.jumpProgress += 1.0f;
        }
        if (this.getWormJumping() == 0 && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 1.0f;
        }
        if (this.isInSand() && this.field_5976) {
            this.method_18799(this.method_18798().method_1031(0.0, 0.05, 0.0));
        }
        if (this.getWormJumping() > 0) {
            float f2 = (float)(-((double)((float)this.method_18798().field_1351) * 57.2957763671875));
            this.method_36457(f2);
            if (this.isInSand() || this.method_24828()) {
                this.setWormJumping(this.getWormJumping() - 1);
            }
        }
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_5980(null);
        }
        if (!(this.method_5968() == null || this.method_5968().method_5805() && DragonUtils.isAlive(this.method_5968()))) {
            this.method_5980(null);
        }
        if (this.willExplode) {
            if (this.ticksTillExplosion == 0) {
                if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((class_1309)this, this.method_23317(), this.method_23318(), this.method_23321())) {
                    this.method_37908().method_8537((class_1297)this.thrower, this.method_23317(), this.method_23318(), this.method_23321(), 2.5f * this.method_17825(), false, class_1937.class_7867.field_40890);
                }
                this.thrower = null;
            } else {
                --this.ticksTillExplosion;
            }
        }
        if (this.isInSandStrict()) {
            this.method_18799(this.method_18798().method_1031(0.0, 0.08, 0.0));
        }
        if (this.growthCounter > 1000 && this.getWormAge() < 5) {
            this.growthCounter = 0;
            this.setWormAge(Math.min(5, this.getWormAge() + 1));
            this.clearSegments();
            this.method_6025(15.0f);
            this.setDeathWormScale(this.getDeathwormScale());
            if (this.method_37908().field_9236) {
                int i = 0;
                while ((float)i < 10.0f * this.method_17825()) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), (double)((float)this.getSurface((int)Math.floor(this.method_23317()), (int)Math.floor(this.method_23318()), (int)Math.floor(this.method_23321())) + 0.5f), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02);
                    ++i;
                }
            }
        }
        if (this.getWormAge() < 5) {
            ++this.growthCounter;
        }
        if (this.method_5642() != null && this.method_5968() != null) {
            this.method_5942().method_6340();
            this.method_5980(null);
        }
        if (this.method_5968() != null && (double)this.method_5739((class_1297)this.method_5968()) < Math.min(4.0, 4.0 * (double)this.method_17825()) && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            float f = (float)this.method_5996(class_5134.field_23721).method_6194();
            this.method_5968().method_5643(this.method_37908().method_48963().method_48812((class_1309)this), f);
            this.method_18799(this.method_18798().method_1031(0.0, (double)-0.4f, 0.0));
        }
    }

    public int getWormBrightness(boolean sky) {
        class_243 vec3 = this.method_5836(1.0f);
        class_2338 eyePos = class_2338.method_49638((class_2374)vec3);
        while (eyePos.method_10264() < 256 && !this.method_37908().method_22347(eyePos)) {
            eyePos = eyePos.method_10084();
        }
        return this.method_37908().method_8314(sky ? class_1944.field_9284 : class_1944.field_9282, eyePos.method_10084());
    }

    public int getSurface(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        while (!this.method_37908().method_22347(pos)) {
            pos = pos.method_10084();
        }
        return pos.method_10264();
    }

    protected class_3414 method_5994() {
        return this.method_17825() > 3.0f ? IafSounds.DEATHWORM_GIANT_IDLE : IafSounds.DEATHWORM_IDLE;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return this.method_17825() > 3.0f ? IafSounds.DEATHWORM_GIANT_HURT : IafSounds.DEATHWORM_HURT;
    }

    protected class_3414 method_6002() {
        return this.method_17825() > 3.0f ? IafSounds.DEATHWORM_GIANT_DIE : IafSounds.DEATHWORM_DIE;
    }

    public void method_5773() {
        boolean inSand;
        super.method_5773();
        this.method_18382();
        this.onUpdateParts();
        if (this.field_6012 == 1) {
            this.updateScale(this.method_17825());
        }
        if (this.attack() && this.method_5642() != null && this.method_5642() instanceof class_1657) {
            class_1309 target = DragonUtils.riderLookingAtEntity((class_1309)this, this.method_5642(), 3.0);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
                this.method_5783(this.method_17825() > 3.0f ? IafSounds.DEATHWORM_GIANT_ATTACK : IafSounds.DEATHWORM_ATTACK, 1.0f, 1.0f);
                if (this.method_6051().method_43048(3) == 0 && this.method_17825() > 1.0f) {
                    float radius = 1.5f * this.method_17825();
                    float angle = (float)Math.PI / 180 * this.field_6283;
                    double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * class_3532.method_15362((float)angle);
                    BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.method_37908(), (class_1308)this, this.method_23317() + extraX, this.method_23318() - (double)this.method_5751(), this.method_23321() + extraZ, this.method_17825() * 0.75f);
                    explosion.method_8348();
                    explosion.method_8350(true);
                }
            }
            if (target != null) {
                target.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            }
        }
        if (this.isInSand()) {
            class_2338 pos = new class_2338(this.method_31477(), this.getSurface(this.method_31477(), this.method_31478(), this.method_31479()), this.method_31479()).method_10074();
            class_2680 state = this.method_37908().method_8320(pos);
            if (state.method_26216((class_1922)this.method_37908(), pos) && this.method_37908().field_9236) {
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, state), this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), (double)((float)this.getSurface((int)Math.floor(this.method_23317()), (int)Math.floor(this.method_23318()), (int)Math.floor(this.method_23321())) + 0.5f), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02);
            }
            if (this.field_6012 % 10 == 0) {
                this.method_5783(class_3417.field_15074, 1.0f, 0.5f);
            }
        }
        if (this.up() && this.method_24828()) {
            this.method_6043();
        }
        boolean bl = inSand = this.isInSand() || this.method_5642() == null;
        if (inSand && !this.isSandNavigator) {
            this.switchNavigator(true);
        }
        if (!inSand && this.isSandNavigator) {
            this.switchNavigator(false);
        }
        if (this.method_37908().field_9236) {
            this.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (class_1309)this);
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
    }

    public boolean up() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) & 1) == 1;
    }

    public boolean dismountIAF() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 2 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(1, dismount);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
    }

    public boolean isSandBelow() {
        int i = class_3532.method_15357((double)this.method_23317());
        int j = class_3532.method_15357((double)(this.method_23318() + 1.0));
        int k = class_3532.method_15357((double)this.method_23321());
        class_2338 blockpos = new class_2338(i, j, k);
        class_2680 BlockState = this.method_37908().method_8320(blockpos);
        return BlockState.method_26164(class_3481.field_15466);
    }

    public boolean isInSand() {
        return this.method_5642() == null && this.isInSandStrict();
    }

    public boolean isInSandStrict() {
        return this.method_37908().method_8320(this.method_24515()).method_26164(class_3481.field_15466);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public class_1297[] getWormParts() {
        return this.segments;
    }

    public int method_5986() {
        return 10;
    }

    @Override
    public boolean shouldAnimalsFear(class_1297 entity) {
        return true;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean canPassThrough(class_2338 pos, class_2680 state, class_265 shape) {
        return this.method_37908().method_8320(pos).method_26164(class_3481.field_15466);
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRidingPlayer(class_1657 player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().method_5667().equals(player.method_5667());
    }

    @Override
    public class_1657 getRidingPlayer() {
        if (this.method_5642() instanceof class_1657) {
            return (class_1657)this.method_5642();
        }
        return null;
    }

    @Override
    public double getRideSpeedModifier() {
        return this.isInSand() ? 1.5 : 1.0;
    }

    public double processRiderY(double y) {
        return this.isInSand() ? y + (double)0.2f : y;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public class SandMoveHelper
    extends class_1335 {
        private final EntityDeathWorm worm;

        public SandMoveHelper() {
            super((class_1308)EntityDeathWorm.this);
            this.worm = EntityDeathWorm.this;
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                double d1 = this.field_6369 - this.worm.method_23318();
                double d2 = this.field_6367 - this.worm.method_23321();
                class_243 Vector3d = new class_243(this.field_6370 - this.worm.method_23317(), this.field_6369 - this.worm.method_23318(), this.field_6367 - this.worm.method_23321());
                double d0 = Vector3d.method_1033();
                if (d0 < 2.500000277905201E-7) {
                    this.field_6371.method_5930(0.0f);
                } else {
                    this.field_6372 = 1.0;
                    this.worm.method_18799(this.worm.method_18798().method_1019(Vector3d.method_1021(this.field_6372 * 0.05 / d0)));
                    class_243 Vector3d1 = this.worm.method_18798();
                    this.worm.method_36456(-((float)class_3532.method_15349((double)Vector3d1.field_1352, (double)Vector3d1.field_1350)) * 57.295776f);
                }
            }
        }
    }
}

