/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDragonLightningCharge;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonDestructionManager;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7;

public class EntityLightningDragon
extends EntityDragonBase {
    public static final class_2960 FEMALE_LOOT = new class_2960("iceandfire", "entities/dragon/lightning_dragon_female");
    public static final class_2960 MALE_LOOT = new class_2960("iceandfire", "entities/dragon/lightning_dragon_male");
    public static final class_2960 SKELETON_LOOT = new class_2960("iceandfire", "entities/dragon/lightning_dragon_skeleton");
    private static final class_2940<Boolean> HAS_LIGHTNING_TARGET = class_2945.method_12791(EntityLightningDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> LIGHTNING_TARGET_X = class_2945.method_12791(EntityLightningDragon.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> LIGHTNING_TARGET_Y = class_2945.method_12791(EntityLightningDragon.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> LIGHTNING_TARGET_Z = class_2945.method_12791(EntityLightningDragon.class, (class_2941)class_2943.field_13320);

    public EntityLightningDragon(class_1937 worldIn) {
        this(IafEntities.LIGHTNING_DRAGON, worldIn);
    }

    public EntityLightningDragon(class_1299<?> t, class_1937 worldIn) {
        super(t, worldIn, DragonType.LIGHTNING, 1.0, 1 + (Integer)IafCommonConfig.INSTANCE.dragon.attackDamage.getValue(), (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue() * 0.04, (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue(), 0.15f, 0.4f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_14, 8.0f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)30);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HAS_LIGHTNING_TARGET, (Object)false);
        this.field_6011.method_12784(LIGHTNING_TARGET_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LIGHTNING_TARGET_Y, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LIGHTNING_TARGET_Z, (Object)Float.valueOf(0.0f));
    }

    @Override
    public int getStartMetaForType() {
        return 8;
    }

    @Override
    protected boolean shouldTarget(class_1297 entity) {
        if (entity instanceof EntityDragonBase && !this.method_6181()) {
            return entity.method_5864() != this.method_5864() && this.method_17681() >= entity.method_17681() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof class_1657 || DragonUtils.isDragonTargetable(entity, IafEntityTags.LIGHTNING_DRAGON_TARGETS) || !this.method_6181() && DragonUtils.isVillager(entity);
    }

    @Override
    public boolean isTimeToWake() {
        return !this.method_37908().method_8530() || this.getCommand() == 2;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
    }

    @Override
    public String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "amethyst_";
            case 2 -> "copper_";
            case 3 -> "black_";
            default -> "electric_";
        };
    }

    public boolean method_5679(class_1282 i) {
        if (i.method_5525().equals(this.method_37908().method_48963().method_48809().method_5525())) {
            this.method_6025(15.0f);
            this.method_6092(new class_1293(class_1294.field_5918, 20, 1));
            return true;
        }
        return super.method_5679(i);
    }

    public void setHasLightningTarget(boolean lightning_target) {
        this.field_6011.method_12778(HAS_LIGHTNING_TARGET, (Object)lightning_target);
    }

    public boolean hasLightningTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_LIGHTNING_TARGET);
    }

    public void setLightningTargetVec(float x, float y, float z) {
        this.field_6011.method_12778(LIGHTNING_TARGET_X, (Object)Float.valueOf(x));
        this.field_6011.method_12778(LIGHTNING_TARGET_Y, (Object)Float.valueOf(y));
        this.field_6011.method_12778(LIGHTNING_TARGET_Z, (Object)Float.valueOf(z));
    }

    public float getLightningTargetX() {
        return ((Float)this.field_6011.method_12789(LIGHTNING_TARGET_X)).floatValue();
    }

    public float getLightningTargetY() {
        return ((Float)this.field_6011.method_12789(LIGHTNING_TARGET_Y)).floatValue();
    }

    public float getLightningTargetZ() {
        return ((Float)this.field_6011.method_12789(LIGHTNING_TARGET_Z)).floatValue();
    }

    @Override
    public boolean method_6121(class_1297 entityIn) {
        this.method_5988().method_6226(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((class_1297)this, this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0), entityIn.method_19538().method_1031(0.0, (double)(entityIn.method_17682() / 2.0f), 0.0)) && entityIn.method_17681() < this.method_17681() * 0.5f && this.method_5642() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.method_5804((class_1297)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        class_1309 attackTarget = this.method_5968();
        if (!this.method_37908().field_9236 && attackTarget != null) {
            if (this.method_5829().method_1009((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).method_994(attackTarget.method_5829())) {
                this.method_6121((class_1297)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.method_24828())) {
                this.shootFireAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.method_5858((class_1297)attackTarget) < 100.0) {
                double difX = attackTarget.method_23317() - this.method_23317();
                double difY = attackTarget.method_23318() + (double)attackTarget.method_17682() - this.method_23318();
                double difZ = attackTarget.method_23321() - this.method_23321();
                this.method_18799(this.method_18798().method_1031(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.method_5829().method_1009((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).method_994(attackTarget.method_5829())) {
                    this.method_6121((class_1297)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
        if (!this.isBreathingFire()) {
            this.setHasLightningTarget(false);
        }
    }

    @Override
    protected void breathFireAtPos(class_2338 burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.method_36456(this.field_6283);
                if (this.fireBreathTicks % 7 == 0) {
                    this.method_5783(IafSounds.LIGHTNINGDRAGON_BREATH, 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.method_10263() + 0.5f, (float)burningTarget.method_10264() + 0.5f, (float)burningTarget.method_10260() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public void riderShootFire(class_1297 controller) {
        if (this.method_6051().method_43048(5) == 0 && !this.method_6109()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.method_36456(this.field_6283);
                class_243 headVec = this.getHeadPosition();
                this.method_5783(IafSounds.LIGHTNINGDRAGON_BREATH_CRACKLE, 4.0f, 1.0f);
                double d2 = controller.method_5720().field_1352;
                double d3 = controller.method_5720().field_1351;
                double d4 = controller.method_5720().field_1350;
                float inaccuracy = 1.0f;
                EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge(IafEntities.LIGHTNING_DRAGON_CHARGE, this.method_37908(), this, d2 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d3 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d4 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.method_5814(headVec.field_1352, headVec.field_1351, headVec.field_1350);
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_8649((class_1297)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                class_239 mop;
                this.method_36456(this.field_6283);
                if (this.fireBreathTicks % 7 == 0) {
                    this.method_5783(IafSounds.LIGHTNINGDRAGON_BREATH, 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.method_17784().field_1352, mop.method_17784().field_1351, mop.method_17784().field_1350, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public class_1792 getBloodItem() {
        return IafItems.LIGHTNING_DRAGON_BLOOD;
    }

    @Override
    public class_1792 getFleshItem() {
        return IafItems.LIGHTNING_DRAGON_FLESH;
    }

    @Override
    public class_1935 getHeartItem() {
        return IafItems.LIGHTNING_DRAGON_HEART;
    }

    @Override
    public class_2960 getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(class_1309 entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.method_6051().method_43048(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 20) {
                    this.method_36456(this.field_6283);
                    class_243 headVec = this.getHeadPosition();
                    double d2 = entity.method_23317() - headVec.field_1352;
                    double d3 = entity.method_23318() - headVec.field_1351;
                    double d4 = entity.method_23321() - headVec.field_1350;
                    float inaccuracy = 1.0f;
                    this.method_5783(IafSounds.LIGHTNINGDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge(IafEntities.LIGHTNING_DRAGON_CHARGE, this.method_37908(), this, d2 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d3 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d4 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.method_5814(headVec.field_1352, headVec.field_1351, headVec.field_1350);
                    if (!this.method_37908().field_9236) {
                        this.method_37908().method_8649((class_1297)entitylargefireball);
                    }
                    if (!entity.method_5805()) {
                        this.setBreathingFire(false);
                    }
                    this.randomizeAttacks();
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.method_36456(this.field_6283);
                    if (this.field_6012 % 5 == 0) {
                        this.method_5783(IafSounds.LIGHTNINGDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.method_23317(), entity.method_23318(), entity.method_23321(), 1);
                    if (!entity.method_5805()) {
                        this.setBreathingFire(false);
                        this.randomizeAttacks();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.method_5951((class_1297)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (((IafEvents.DragonFire)IafEvents.ON_DRAGON_FIRE_BLOCK.invoker()).onFireBlock(this, burnX, burnY, burnZ)) {
            return;
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.method_36456(this.field_6283);
                class_243 headVec = this.getHeadPosition();
                double d2 = burnX - headVec.field_1352;
                double d3 = burnY - headVec.field_1351;
                double d4 = burnZ - headVec.field_1350;
                float inaccuracy = 1.0f;
                this.method_5783(IafSounds.LIGHTNINGDRAGON_BREATH_CRACKLE, 4.0f, 1.0f);
                EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge(IafEntities.LIGHTNING_DRAGON_CHARGE, this.method_37908(), this, d2 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d3 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d4 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.method_5814(headVec.field_1352, headVec.field_1351, headVec.field_1350);
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_8649((class_1297)entitylargefireball);
                }
            }
            return;
        }
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        class_243 headPos = this.getHeadPosition();
        double d2 = burnX - headPos.field_1352;
        double d3 = burnY - headPos.field_1351;
        double d4 = burnZ - headPos.field_1350;
        double distance = Math.max(2.5 * Math.sqrt(this.method_5649(burnX, burnY, burnZ)), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.field_1352 + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.field_1351 + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.field_1350 + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                this.setHasLightningTarget(true);
                this.setLightningTargetVec((float)burnX, (float)burnY, (float)burnZ);
            } else if (!this.method_37908().field_9236) {
                class_3965 result = this.method_37908().method_17742(new class_3959(new class_243(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321()), new class_243(progressX, progressY, progressZ), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
                class_243 vec3 = result.method_17784();
                class_2338 pos = class_2338.method_49638((class_2374)vec3);
                IafDragonDestructionManager.destroyAreaBreath(this.method_37908(), pos, this);
                this.setHasLightningTarget(true);
                this.setLightningTargetVec((float)result.method_17784().field_1352, (float)result.method_17784().field_1351, (float)result.method_17784().field_1350);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.field_5974.method_43057() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.field_5974.method_43057() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.field_5974.method_43057() * 3.0 - 1.5;
            this.setHasLightningTarget(true);
            this.setLightningTargetVec((float)spawnX, (float)spawnY, (float)spawnZ);
            if (!this.method_37908().field_9236) {
                IafDragonDestructionManager.destroyAreaBreath(this.method_37908(), class_2338.method_49637((double)spawnX, (double)spawnY, (double)spawnZ), this);
            }
        }
    }

    protected class_3414 method_5994() {
        return this.isTeen() ? IafSounds.LIGHTNINGDRAGON_TEEN_IDLE : (this.method_27071() ? IafSounds.LIGHTNINGDRAGON_ADULT_IDLE : IafSounds.LIGHTNINGDRAGON_CHILD_IDLE);
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return this.isTeen() ? IafSounds.LIGHTNINGDRAGON_TEEN_HURT : (this.method_27071() ? IafSounds.LIGHTNINGDRAGON_ADULT_HURT : IafSounds.LIGHTNINGDRAGON_CHILD_HURT);
    }

    protected class_3414 method_6002() {
        return this.isTeen() ? IafSounds.LIGHTNINGDRAGON_TEEN_DEATH : (this.method_27071() ? IafSounds.LIGHTNINGDRAGON_ADULT_DEATH : IafSounds.LIGHTNINGDRAGON_CHILD_DEATH);
    }

    @Override
    public class_3414 getRoarSound() {
        return this.isTeen() ? IafSounds.LIGHTNINGDRAGON_TEEN_ROAR : (this.method_27071() ? IafSounds.LIGHTNINGDRAGON_ADULT_ROAR : IafSounds.LIGHTNINGDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT, ANIMATION_SPEAK, ANIMATION_BITE, ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR, ANIMATION_EPIC_ROAR};
    }

    public boolean method_6481(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() != null && stack.method_7909() == IafItems.LIGHTNING_STEW;
    }

    @Override
    protected void spawnDeathParticles() {
        for (int k = 0; k < 3; ++k) {
            double d2 = this.field_5974.method_43059() * 0.02;
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            if (!this.method_37908().field_9236) continue;
            this.method_37908().method_8406((class_2394)class_2398.field_11242, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d2, d0, d1);
        }
    }

    @Override
    public void spawnBabyParticles() {
        for (int i = 0; i < 5; ++i) {
            float radiusAdd = (float)i * 0.15f;
            float headPosX = (float)(this.method_23317() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * class_3532.method_15362((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
            float headPosZ = (float)(this.method_23318() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * class_3532.method_15374((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
            float headPosY = (float)(this.method_23321() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
            this.method_37908().method_8406((class_2394)class_2398.field_11237, (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public class_1799 getSkull() {
        return new class_1799((class_1935)IafItems.DRAGON_SKULL_LIGHTNING);
    }
}

