/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.StaticVariables;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8111;

public abstract class EntityMultipartPart
extends class_1297 {
    private static final class_2940<Optional<UUID>> PARENT_UUID = class_2945.method_12791(EntityMultipartPart.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Float> SCALE_WIDTH = class_2945.method_12791(EntityMultipartPart.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SCALE_HEIGHT = class_2945.method_12791(EntityMultipartPart.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> PART_YAW = class_2945.method_12791(EntityMultipartPart.class, (class_2941)class_2943.field_13320);
    public class_4048 multipartSize;
    protected float radius;
    protected float angleYaw;
    protected float offsetY;
    protected float damageMultiplier;

    protected EntityMultipartPart(class_1299<?> t, class_1937 world) {
        super(t, world);
        this.multipartSize = t.method_18386();
    }

    protected EntityMultipartPart(class_1299<?> t, class_1297 parent, float radius, float angleYaw, float offsetY, float sizeX, float sizeY, float damageMultiplier) {
        super(t, parent.method_37908());
        this.setParent(parent);
        this.setScaleX(sizeX);
        this.setScaleY(sizeY);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
        this.damageMultiplier = damageMultiplier;
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, 0.1);
    }

    public static boolean sharesRider(class_1297 parent, class_1297 entityIn) {
        for (class_1297 entity : parent.method_5685()) {
            if (entity.equals((Object)entityIn)) {
                return true;
            }
            if (!EntityMultipartPart.sharesRider(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    protected void method_5749(class_2487 compound) {
    }

    protected void method_5652(class_2487 compound) {
    }

    protected void method_5746() {
    }

    public class_4048 method_18377(class_4050 poseIn) {
        return new class_4048(this.getScaleX(), this.getScaleY(), false);
    }

    protected void method_5693() {
        this.field_6011.method_12784(PARENT_UUID, Optional.empty());
        this.field_6011.method_12784(SCALE_WIDTH, (Object)Float.valueOf(0.5f));
        this.field_6011.method_12784(SCALE_HEIGHT, (Object)Float.valueOf(0.5f));
        this.field_6011.method_12784(PART_YAW, (Object)Float.valueOf(0.0f));
    }

    public UUID getParentId() {
        return ((Optional)this.field_6011.method_12789(PARENT_UUID)).orElse(null);
    }

    public void setParentId(UUID uniqueId) {
        this.field_6011.method_12778(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    private float getScaleX() {
        return ((Float)this.field_6011.method_12789(SCALE_WIDTH)).floatValue();
    }

    protected void setScaleX(float scale) {
        this.field_6011.method_12778(SCALE_WIDTH, (Object)Float.valueOf(scale));
    }

    private float getScaleY() {
        return ((Float)this.field_6011.method_12789(SCALE_HEIGHT)).floatValue();
    }

    protected void setScaleY(float scale) {
        this.field_6011.method_12778(SCALE_HEIGHT, (Object)Float.valueOf(scale));
    }

    public float getPartYaw() {
        return ((Float)this.field_6011.method_12789(PART_YAW)).floatValue();
    }

    private void setPartYaw(float yaw) {
        this.field_6011.method_12778(PART_YAW, (Object)Float.valueOf(yaw % 360.0f));
    }

    public void method_5773() {
        this.field_5957 = false;
        if (this.field_6012 > 10) {
            class_1297 parent = this.getParent();
            this.method_18382();
            if (parent != null && !this.method_37908().field_9236) {
                float renderYawOffset = parent.method_36454();
                if (parent instanceof class_1309) {
                    class_1309 living = (class_1309)parent;
                    renderYawOffset = living.field_6283;
                }
                if (this.isSlowFollow()) {
                    this.method_5814(parent.field_6014 + (double)(this.radius * class_3532.method_15362((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))), parent.field_6036 + (double)this.offsetY, parent.field_5969 + (double)(this.radius * class_3532.method_15374((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))));
                    double d0 = parent.method_23317() - this.method_23317();
                    double d1 = parent.method_23318() - this.method_23318();
                    double d2 = parent.method_23321() - this.method_23321();
                    float f2 = -((float)(class_3532.method_15349((double)d1, (double)class_3532.method_15355((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                    this.method_36457(this.limitAngle(this.method_36455(), f2));
                    this.method_5785();
                    this.method_36456(renderYawOffset);
                    this.setPartYaw(this.method_36454());
                    if (!this.method_37908().field_9236) {
                        this.collideWithNearbyEntities();
                    }
                } else {
                    this.method_5814(parent.method_23317() + (double)(this.radius * class_3532.method_15362((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))), parent.method_23318() + (double)this.offsetY, parent.method_23321() + (double)(this.radius * class_3532.method_15374((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))));
                    this.method_5785();
                }
                if (!this.method_37908().field_9236) {
                    this.collideWithNearbyEntities();
                }
                if (parent.method_31481() && !this.method_37908().field_9236) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            } else if (this.field_6012 > 20 && !this.method_37908().field_9236) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
        super.method_5773();
    }

    protected boolean isSlowFollow() {
        return false;
    }

    protected float limitAngle(float sourceAngle, float targetAngle) {
        float f1;
        float f = class_3532.method_15393((float)(targetAngle - sourceAngle));
        if (f > 5.0f) {
            f = 5.0f;
        }
        if (f < -5.0f) {
            f = -5.0f;
        }
        if ((f1 = sourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(class_1297.class_5529.field_26999);
    }

    public class_1297 getParent() {
        class_1937 class_19372;
        UUID id = this.getParentId();
        if (id != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return serverLevel.method_14190(id);
        }
        return null;
    }

    public void setParent(class_1297 entity) {
        this.setParentId(entity.method_5667());
    }

    public boolean method_5779(class_1297 entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean method_5863() {
        return true;
    }

    public void collideWithNearbyEntities() {
        List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1012((double)0.2f, 0.0, (double)0.2f));
        class_1297 parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> entity != parent && !EntityMultipartPart.sharesRider(parent, entity) && !(entity instanceof EntityMultipartPart) && entity.method_5810()).forEach(entity -> entity.method_5697(parent));
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1297 parent = this.getParent();
        if (this.method_37908().field_9236 && this.getParentId() != null) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10797(this.getParentId()).writeFloat(0.0f);
            ClientPlayNetworking.send((class_2960)StaticVariables.MULTIPART_INTERACT, (class_2540)buf);
        }
        return parent != null ? parent.method_5688(player, hand) : class_1269.field_5811;
    }

    public boolean method_5643(class_1282 source, float damage) {
        class_1297 parent = this.getParent();
        if (this.method_37908().field_9236 && this.getParentId() != null && source.method_5529() instanceof class_1657) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10797(this.getParentId()).writeFloat(damage * this.damageMultiplier);
            ClientPlayNetworking.send((class_2960)StaticVariables.MULTIPART_INTERACT, (class_2540)buf);
        }
        return parent != null && parent.method_5643(source, damage * this.damageMultiplier);
    }

    public boolean method_5679(class_1282 source) {
        return source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42342) || source.method_49708(class_8111.field_42340) || source.method_49708(class_8111.field_42356) || source.method_49708(class_8111.field_42338) || source.method_48789(class_8103.field_42246) || super.method_5679(source);
    }

    public boolean shouldContinuePersisting() {
        return this.method_37908() != null || this.method_31481();
    }

    public void method_5719(class_1297 entity) {
        super.method_5719(entity);
        this.method_18799(entity.method_18798());
    }
}

