/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexEgg;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIWanderHiveCenter;
import com.iafenvoy.iceandfire.entity.ai.MyrmexQueenAIWander;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.entity.util.MyrmexTrades;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.gen.WorldGenMyrmexHive;
import com.iafenvoy.uranus.animation.Animation;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3853;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5281;

public class EntityMyrmexQueen
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final Animation ANIMATION_EGG = Animation.create((int)20);
    public static final Animation ANIMATION_DIGNEST = Animation.create((int)45);
    public static final class_2960 DESERT_LOOT = new class_2960("iceandfire", "entities/myrmex_queen_desert");
    public static final class_2960 JUNGLE_LOOT = new class_2960("iceandfire", "entities/myrmex_queen_jungle");
    private static final class_2960 TEXTURE_DESERT = new class_2960("iceandfire", "textures/models/myrmex/myrmex_desert_queen.png");
    private static final class_2960 TEXTURE_JUNGLE = new class_2960("iceandfire", "textures/models/myrmex/myrmex_jungle_queen.png");
    private static final class_2940<Boolean> HASMADEHOME = class_2945.method_12791(EntityMyrmexQueen.class, (class_2941)class_2943.field_13323);
    private int eggTicks = 0;

    public EntityMyrmexQueen(class_1299<EntityMyrmexQueen> t, class_1937 worldIn) {
        super(t, worldIn);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23721, (Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 3.5).method_26868(class_5134.field_23717, 128.0).method_26868(class_5134.field_23724, 15.0);
    }

    protected class_2960 method_5991() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    public int method_6110() {
        return 20;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HASMADEHOME, (Object)Boolean.TRUE);
    }

    @Override
    protected class_3853.class_1652[] getLevel1Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_QUEEN.get(1) : (class_3853.class_1652[])MyrmexTrades.DESERT_QUEEN.get(1);
    }

    @Override
    protected class_3853.class_1652[] getLevel2Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_QUEEN.get(2) : (class_3853.class_1652[])MyrmexTrades.DESERT_QUEEN.get(2);
    }

    public void method_5665(class_2561 name) {
        if (this.getHive() != null && !this.getHive().colonyName.equals(name.getString())) {
            this.getHive().colonyName = name.getString();
        }
        super.method_5665(name);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("EggTicks", this.eggTicks);
        tag.method_10556("MadeHome", this.hasMadeHome());
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.eggTicks = tag.method_10550("EggTicks");
        this.setMadeHome(tag.method_10577("MadeHome"));
    }

    public boolean hasMadeHome() {
        return (Boolean)this.field_6011.method_12789(HASMADEHOME);
    }

    public void setMadeHome(boolean madeHome) {
        this.field_6011.method_12778(HASMADEHOME, (Object)madeHome);
    }

    public void method_6007() {
        super.method_6007();
        if (this.getAnimation() == ANIMATION_DIGNEST) {
            this.spawnGroundEffects(3.0f);
        }
        if (this.getHive() != null) {
            this.getHive().tick(0, this.method_37908());
        }
        if (this.hasMadeHome() && this.getGrowthStage() >= 2 && !this.canSeeSky()) {
            ++this.eggTicks;
        } else if (this.canSeeSky()) {
            this.setAnimation(ANIMATION_DIGNEST);
            if (this.getAnimationTick() == 42) {
                int down = Math.max(15, this.method_24515().method_10264() - 20 + this.method_6051().method_43048(10));
                class_2338 genPos = new class_2338(this.method_31477(), down, this.method_31479());
                if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((class_1309)this, genPos.method_10263(), genPos.method_10264(), genPos.method_10260())) {
                    WorldGenMyrmexHive hiveGen = new WorldGenMyrmexHive(true, this.isJungle(), (Codec<class_3111>)class_3111.field_24893);
                    if (!this.method_37908().field_9236 && this.method_37908() instanceof class_3218) {
                        hiveGen.placeSmallGen((class_5281)((class_3218)this.method_37908()), this.method_6051(), genPos);
                    }
                    this.setMadeHome(true);
                    this.method_5808(genPos.method_10263(), down, genPos.method_10260(), 0.0f, 0.0f);
                    this.method_6092(new class_1293(class_1294.field_5905, 30));
                    this.setHive(hiveGen.hive);
                    for (int i = 0; i < 3; ++i) {
                        EntityMyrmexWorker worker = new EntityMyrmexWorker(IafEntities.MYRMEX_WORKER, this.method_37908());
                        worker.method_5719((class_1297)this);
                        worker.setHive(this.getHive());
                        worker.setJungleVariant(this.isJungle());
                        if (this.method_37908().field_9236) continue;
                        this.method_37908().method_8649((class_1297)worker);
                    }
                    return;
                }
            }
        }
        if (!this.method_37908().field_9236 && this.eggTicks > (Integer)IafCommonConfig.INSTANCE.myrmex.pregnantTicks.getValue() && this.getHive() == null || !this.method_37908().field_9236 && this.getHive() != null && this.getHive().repopulate() && this.eggTicks > (Integer)IafCommonConfig.INSTANCE.myrmex.pregnantTicks.getValue()) {
            float radius = -5.25f;
            float angle = (float)Math.PI / 180 * this.field_6283;
            double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * class_3532.method_15362((float)angle);
            class_2338 eggPos = class_2338.method_49637((double)(this.method_23317() + extraX), (double)(this.method_23318() + 0.75), (double)(this.method_23321() + extraZ));
            if (this.method_37908().method_22347(eggPos)) {
                this.setAnimation(ANIMATION_EGG);
                if (this.getAnimationTick() == 10) {
                    EntityMyrmexEgg egg = new EntityMyrmexEgg(IafEntities.MYRMEX_EGG, this.method_37908());
                    egg.setJungle(this.isJungle());
                    int caste = EntityMyrmexQueen.getRandomCaste(this.method_37908(), this.method_6051(), this.getHive() == null || this.getHive().reproduces);
                    egg.setMyrmexCaste(caste);
                    egg.method_5808(this.method_23317() + extraX, this.method_23318() + 0.75, this.method_23321() + extraZ, 0.0f, 0.0f);
                    if (this.getHive() != null) {
                        egg.hiveUUID = this.getHive().hiveUUID;
                    }
                    if (!this.method_37908().field_9236) {
                        this.method_37908().method_8649((class_1297)egg);
                    }
                    this.eggTicks = 0;
                }
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.method_5968() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            if (this.getAttackBounds().method_994(this.method_5968().method_5829())) {
                this.method_5968().method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.getAnimationTick() == 0) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && this.method_5968() != null && this.getAnimationTick() == 6 && this.getAttackBounds().method_994(this.method_5968().method_5829())) {
            class_1309 attackTarget = this.method_5968();
            attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194() * 2));
            attackTarget.method_6092(new class_1293(class_1294.field_5899, 200, 2));
            attackTarget.field_6007 = true;
            float f = class_3532.method_15355((float)0.5f);
            attackTarget.method_18799(attackTarget.method_18798().method_18805(0.5, 1.0, 0.5));
            attackTarget.method_18799(attackTarget.method_18798().method_1031(-0.5 / (double)f * 4.0, 1.0, -0.5 / (double)f * 4.0));
            if (attackTarget.method_24828()) {
                attackTarget.method_18799(attackTarget.method_18798().method_1031(0.0, 0.4, 0.0));
            }
        }
    }

    public boolean method_5679(class_1282 source) {
        return super.method_5679(source) || this.getAnimation() == ANIMATION_DIGNEST;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAITradePlayer(this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAILookAtTradePlayer(this));
        this.field_6201.method_6277(1, (class_1352)new MyrmexAIAttackMelee(this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new MyrmexAIReEnterHive(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new MyrmexAIWanderHiveCenter(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new MyrmexQueenAIWander(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new MyrmexAIDefendHive(this));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new MyrmexAIAttackPlayers(this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, true, (Predicate)((com.google.common.base.Predicate)entity -> entity != null && !EntityMyrmexBase.haveSameHive(this, (class_1297)entity) && DragonUtils.isAlive(entity) && !(entity instanceof class_1569))));
    }

    @Override
    public boolean isInHive() {
        if (this.getHive() != null) {
            for (class_2338 pos : this.getHive().getAllRooms()) {
                if (!this.isCloseEnoughToTarget(MyrmexHive.getGroundedPos((class_1936)this.method_37908(), pos), 300.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return false;
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23721).method_6192((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 3.5);
    }

    @Override
    public class_2960 getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 1.75f;
    }

    @Override
    public int getCasteImportance() {
        return 3;
    }

    @Override
    public boolean shouldLeaveHive() {
        return false;
    }

    @Override
    public boolean shouldEnterHive() {
        return true;
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.method_6051().method_43056() ? ANIMATION_STING : ANIMATION_BITE);
            if (!this.method_37908().field_9236 && this.method_6051().method_43048(3) == 0 && this.method_5998(class_1268.field_5808) != class_1799.field_8037) {
                this.method_5699(this.method_5998(class_1268.field_5808), 0.0f);
                this.method_6122(class_1268.field_5808, class_1799.field_8037);
            }
            if (!this.method_5685().isEmpty()) {
                for (class_1297 entity : this.method_5685()) {
                    entity.method_5848();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.hasMadeHome();
    }

    public void spawnGroundEffects(float size) {
        int i = 0;
        while ((float)i < size * 3.0f) {
            for (int i1 = 0; i1 < 10; ++i1) {
                double motionX = this.method_6051().method_43059() * 0.07;
                double motionY = this.method_6051().method_43059() * 0.07;
                double motionZ = this.method_6051().method_43059() * 0.07;
                float radius = size * this.field_5974.method_43057();
                float angle = (float)Math.PI / 180 * this.field_6283 * 3.14f * this.field_5974.method_43057();
                double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * class_3532.method_15362((float)angle);
                class_2680 BlockState = this.method_37908().method_8320(class_2338.method_49637((double)((double)this.method_31477() + extraX), (double)((double)this.method_31478() + extraY - 1.0), (double)((double)this.method_31479() + extraZ)));
                if (!BlockState.method_26215() || !this.method_37908().field_9236) continue;
                this.method_37908().method_8466((class_2394)new class_2388(class_2398.field_11217, BlockState), true, this.method_23317() + extraX, this.method_23318() + extraY, this.method_23321() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING, ANIMATION_EGG, ANIMATION_DIGNEST};
    }

    public int method_19269() {
        return 0;
    }

    public boolean method_19270() {
        return false;
    }

    public boolean method_38069() {
        return false;
    }
}

