/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.EntityStoneStatue;
import com.iafenvoy.iceandfire.entity.ai.TrollAIFleeSun;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IHumanoid;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.ArrayList;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class EntityTroll
extends class_1588
implements IAnimatedEntity,
IVillagerFear,
IHumanoid,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_STRIKE_HORIZONTAL = Animation.create((int)20);
    public static final Animation ANIMATION_STRIKE_VERTICAL = Animation.create((int)20);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_ROAR = Animation.create((int)25);
    private static final class_2940<String> VARIANT = class_2945.method_12791(EntityTroll.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> WEAPON = class_2945.method_12791(EntityTroll.class, (class_2941)class_2943.field_13326);
    public float stoneProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean avoidSun = true;

    public EntityTroll(class_1299<EntityTroll> t, class_1937 worldIn) {
        super(t, worldIn);
    }

    public static boolean canTrollSpawnOn(class_1299<? extends class_1308> typeIn, class_5425 worldIn, class_3730 reason, class_2338 pos, class_5819 randomIn) {
        return worldIn.method_8407() != class_1267.field_5801 && EntityTroll.method_20679((class_5425)worldIn, (class_2338)pos, (class_5819)randomIn) && EntityTroll.method_20636(IafEntities.TROLL, (class_1936)worldIn, (class_3730)reason, (class_2338)pos, (class_5819)randomIn);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)IafCommonConfig.INSTANCE.troll.maxHealth.getValue()).doubleValue()).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23721, ((Double)IafCommonConfig.INSTANCE.troll.attackDamage.getValue()).doubleValue()).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 9.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(((Double)IafCommonConfig.INSTANCE.troll.maxHealth.getValue()).doubleValue());
        this.method_5996(class_5134.field_23721).method_6192(((Double)IafCommonConfig.INSTANCE.troll.attackDamage.getValue()).doubleValue());
    }

    private void setAvoidSun(boolean day) {
        if (day && !this.avoidSun) {
            ((class_1409)this.method_5942()).method_6361(true);
            this.avoidSun = true;
        }
        if (!day && this.avoidSun) {
            ((class_1409)this.method_5942()).method_6361(false);
            this.avoidSun = false;
        }
    }

    public boolean method_5957(class_4538 worldIn) {
        return worldIn.method_8606((class_1297)this);
    }

    public boolean method_5979(class_1936 worldIn, class_3730 spawnReasonIn) {
        class_2338 pos = this.method_24515();
        class_2338 heightAt = worldIn.method_8598(class_2902.class_2903.field_13203, pos);
        boolean rngCheck = true;
        return pos.method_10264() < heightAt.method_10264() - 10 && super.method_5979(worldIn, spawnReasonIn);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new TrollAIFleeSun(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f, 1.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3988.class, false));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
        this.setAvoidSun(true);
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.method_6051().method_43056()) {
            this.setAnimation(ANIMATION_STRIKE_VERTICAL);
        } else {
            this.setAnimation(ANIMATION_STRIKE_HORIZONTAL);
        }
        return true;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)TrollType.FOREST.getName());
        this.field_6011.method_12784(WEAPON, (Object)TrollType.BuiltinWeapon.AXE.getName());
    }

    private String getVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    private void setVariant(String variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public TrollType getTrollType() {
        return TrollType.getByName(this.getVariant());
    }

    public void setTrollType(TrollType variant) {
        this.setVariant(variant.getName());
    }

    private String getWeapon() {
        return (String)this.field_6011.method_12789(WEAPON);
    }

    private void setWeapon(String variant) {
        this.field_6011.method_12778(WEAPON, (Object)variant);
    }

    public TrollType.ITrollWeapon getWeaponType() {
        return TrollType.ITrollWeapon.getByName(this.getWeapon());
    }

    public void setWeaponType(TrollType.ITrollWeapon variant) {
        this.setWeapon(variant.getName());
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Variant", this.getVariant());
        compound.method_10582("Weapon", this.getWeapon());
        compound.method_10548("StoneProgress", this.stoneProgress);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("Variant") && compound.method_10580("Variant").method_10711() == 8) {
            this.setVariant(compound.method_10558("Variant"));
        } else {
            this.setVariant(TrollType.values().get(compound.method_10550("Variant")).getName());
        }
        if (compound.method_10545("Weapon") && compound.method_10580("Weapon").method_10711() == 8) {
            this.setWeapon(compound.method_10558("Weapon"));
        } else {
            this.setWeapon(TrollType.values().get(compound.method_10550("Weapon")).getName());
        }
        this.stoneProgress = compound.method_10583("StoneProgress");
        this.setConfigurableAttributes();
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setTrollType(TrollType.getBiomeType((class_6880<class_1959>)this.method_37908().method_23753(this.method_24515())));
        this.setWeaponType(TrollType.getWeaponForType(this.getTrollType()));
        return spawnDataIn;
    }

    public boolean method_5643(class_1282 source, float damage) {
        if (source.method_5525().contains("arrow")) {
            return false;
        }
        return super.method_5643(source, damage);
    }

    protected class_2960 method_5991() {
        return this.getTrollType().getLootTable();
    }

    public int method_6110() {
        return 15;
    }

    protected void method_6108() {
        super.method_6108();
        if (this.field_6213 == 20 && !this.method_37908().field_9236 && ((Boolean)IafCommonConfig.INSTANCE.troll.dropWeapon.getValue()).booleanValue()) {
            if (this.method_6051().method_43048(3) == 0) {
                class_1799 weaponStack = new class_1799((class_1935)this.getWeaponType().getItem(), 1);
                weaponStack.method_7970(this.method_6051().method_43048(250), this.method_6051(), null);
                this.dropItemAt(weaponStack, this.method_23317(), this.method_23318(), this.method_23321());
            } else {
                class_1799 brokenDrop = new class_1799((class_1935)class_2246.field_10056, this.method_6051().method_43048(2) + 1);
                class_1799 brokenDrop2 = new class_1799((class_1935)class_2246.field_10056, this.method_6051().method_43048(2) + 1);
                if (this.getWeaponType() == TrollType.BuiltinWeapon.AXE) {
                    brokenDrop = new class_1799((class_1935)class_1802.field_8600, this.method_6051().method_43048(2) + 1);
                    brokenDrop2 = new class_1799((class_1935)class_2246.field_10445, this.method_6051().method_43048(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.COLUMN) {
                    brokenDrop = new class_1799((class_1935)class_2246.field_10056, this.method_6051().method_43048(2) + 1);
                    brokenDrop2 = new class_1799((class_1935)class_2246.field_10056, this.method_6051().method_43048(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.COLUMN_FOREST) {
                    brokenDrop = new class_1799((class_1935)class_2246.field_10056, this.method_6051().method_43048(2) + 1);
                    brokenDrop2 = new class_1799((class_1935)class_2246.field_10056, this.method_6051().method_43048(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.COLUMN_FROST) {
                    brokenDrop = new class_1799((class_1935)class_2246.field_10056, this.method_6051().method_43048(2) + 1);
                    brokenDrop2 = new class_1799((class_1935)class_1802.field_8543, this.method_6051().method_43048(4) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.HAMMER) {
                    brokenDrop = new class_1799((class_1935)class_1802.field_8606, this.method_6051().method_43048(2) + 1);
                    brokenDrop2 = new class_1799((class_1935)class_2246.field_10445, this.method_6051().method_43048(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.TRUNK) {
                    brokenDrop = new class_1799((class_1935)class_2246.field_10431, this.method_6051().method_43048(2) + 1);
                    brokenDrop2 = new class_1799((class_1935)class_2246.field_10431, this.method_6051().method_43048(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.TRUNK_FROST) {
                    brokenDrop = new class_1799((class_1935)class_2246.field_10037, this.method_6051().method_43048(4) + 1);
                    brokenDrop2 = new class_1799((class_1935)class_1802.field_8543, this.method_6051().method_43048(4) + 1);
                }
                this.dropItemAt(brokenDrop, this.method_23317(), this.method_23318(), this.method_23321());
                this.dropItemAt(brokenDrop2, this.method_23317(), this.method_23318(), this.method_23321());
            }
        }
    }

    private void dropItemAt(class_1799 stack, double x, double y, double z) {
        if (stack.method_7947() > 0) {
            class_1542 entityitem = new class_1542(this.method_37908(), x, y, z, stack);
            entityitem.method_6988();
            this.method_37908().method_8649((class_1297)entityitem);
        }
    }

    public void method_6007() {
        boolean stone;
        super.method_6007();
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_5980(null);
        }
        if ((stone = EntityGorgon.isStoneMob((class_1309)this)) && this.stoneProgress < 20.0f) {
            this.stoneProgress += 2.0f;
        } else if (!stone && this.stoneProgress > 0.0f) {
            this.stoneProgress -= 2.0f;
        }
        if (!stone && this.getAnimation() == NO_ANIMATION && this.method_5968() != null && this.method_6051().method_43048(100) == 0) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.method_5783(IafSounds.TROLL_ROAR, 1.0f, 1.0f);
        }
        if (!stone && this.method_6032() < this.method_6063() && this.field_6012 % 30 == 0) {
            this.method_6092(new class_1293(class_1294.field_5924, 30, 1, false, false));
        }
        this.setAvoidSun(this.method_37908().method_8530());
        if (this.method_37908().method_8530() && !this.method_37908().field_9236) {
            class_2338 blockpos;
            float f = this.method_37908().method_8314(class_1944.field_9284, this.method_24515());
            class_2338 class_23382 = blockpos = this.method_5854() instanceof class_1690 ? new class_2338(this.method_31477(), this.method_31478(), this.method_31479()).method_10084() : new class_2338(this.method_31477(), this.method_31478(), this.method_31479());
            if (f > 0.5f && this.method_37908().method_8311(blockpos)) {
                this.method_18800(0.0, 0.0, 0.0);
                this.setAnimation(NO_ANIMATION);
                this.method_5783(IafSounds.TURN_STONE, 1.0f, 1.0f);
                this.stoneProgress = 20.0f;
                EntityStoneStatue statue = EntityStoneStatue.buildStatueEntity((class_1309)this);
                statue.getTrappedTag().method_10548("StoneProgress", 20.0f);
                statue.method_5641(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_8649((class_1297)statue);
                }
                statue.field_5982 = this.method_36454();
                statue.method_36456(this.method_36454());
                statue.field_6241 = this.method_36454();
                statue.field_6283 = this.method_36454();
                statue.field_6220 = this.method_36454();
                this.method_5650(class_1297.class_5529.field_26998);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            float weaponX = (float)(this.method_23317() + (double)(1.9f * class_3532.method_15362((float)((float)((double)(this.field_6283 + 90.0f) * Math.PI / 180.0)))));
            float weaponZ = (float)(this.method_23321() + (double)(1.9f * class_3532.method_15374((float)((float)((double)(this.field_6283 + 90.0f) * Math.PI / 180.0)))));
            float weaponY = (float)(this.method_23318() + (double)0.2f);
            class_2680 state = this.method_37908().method_8320(class_2338.method_49637((double)weaponX, (double)(weaponY - 1.0f), (double)weaponZ));
            for (int i = 0; i < 20; ++i) {
                double motionX = this.method_6051().method_43059() * 0.07;
                double motionY = this.method_6051().method_43059() * 0.07;
                double motionZ = this.method_6051().method_43059() * 0.07;
                if (!state.method_51367() || !this.method_37908().field_9236) continue;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, state), (double)(weaponX + (this.method_6051().method_43057() - 0.5f)), (double)(weaponY + (this.method_6051().method_43057() - 0.5f)), (double)(weaponZ + (this.method_6051().method_43057() - 0.5f)), motionX, motionY, motionZ);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.method_5968() != null && this.method_5858((class_1297)this.method_5968()) < 4.0 && this.getAnimationTick() == 10 && this.field_6213 <= 0) {
            this.method_5968().method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194());
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.method_5968() != null && this.method_5858((class_1297)this.method_5968()) < 4.0 && this.getAnimationTick() == 10 && this.field_6213 <= 0) {
            class_1309 target = this.method_5968();
            target.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194());
            float f5 = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
            float f6 = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
            target.method_18800((double)f5, (double)f6, (double)0.4f);
        }
        if (this.method_5942().method_6357() && this.method_5968() != null && this.method_5858((class_1297)this.method_5968()) > 3.0 && this.method_5858((class_1297)this.method_5968()) < 30.0 && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            this.method_5951((class_1297)this.method_5968(), 30.0f, 30.0f);
            if (this.getAnimation() == NO_ANIMATION && this.field_5974.method_43048(15) == 0) {
                this.setAnimation(ANIMATION_STRIKE_VERTICAL);
            }
            if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
                float weaponX = (float)(this.method_23317() + (double)(1.9f * class_3532.method_15362((float)((float)((double)(this.field_6283 + 90.0f) * Math.PI / 180.0)))));
                float weaponZ = (float)(this.method_23321() + (double)(1.9f * class_3532.method_15374((float)((float)((double)(this.field_6283 + 90.0f) * Math.PI / 180.0)))));
                float weaponY = (float)(this.method_23318() + (double)(this.method_5751() / 2.0f));
                class_1927 explosion = new class_1927(this.method_37908(), (class_1297)this, (double)weaponX, (double)weaponY, (double)weaponZ, 1.0f + this.method_6051().method_43057(), new ArrayList());
                if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((class_1309)this, weaponX, weaponY, weaponZ)) {
                    explosion.method_8348();
                    explosion.method_8350(true);
                }
                this.method_5783(class_3417.field_15152, 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            this.method_5783(class_3417.field_14706, 2.5f, 0.5f);
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.getAnimationTick() == 10) {
            this.method_5783(class_3417.field_14706, 2.5f, 0.5f);
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
    }

    public void method_5966() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_5966();
    }

    protected void method_6013(class_1282 source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_6013(source);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    protected class_3414 method_5994() {
        return IafSounds.TROLL_IDLE;
    }

    protected class_3414 method_6011(class_1282 source) {
        return IafSounds.TROLL_HURT;
    }

    protected class_3414 method_6002() {
        return IafSounds.TROLL_DIE;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_STRIKE_HORIZONTAL, ANIMATION_STRIKE_VERTICAL, ANIMATION_SPEAK, ANIMATION_ROAR};
    }
}

