/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5532;

public class MyrmexAIForage
extends class_1352 {
    private static final int RADIUS = 16;
    private final EntityMyrmexWorker myrmex;
    private final BlockSorter targetSorter;
    private final int chance;
    private class_2338 targetBlock = null;
    private int wanderRadius;
    private PathResult path;
    private int failedToFindPath = 0;

    public MyrmexAIForage(EntityMyrmexWorker myrmex, int chanceIn) {
        this.myrmex = myrmex;
        this.targetSorter = new BlockSorter();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.chance = chanceIn;
    }

    public boolean method_6264() {
        if (!this.myrmex.canMove() || this.myrmex.holdingSomething() || !this.myrmex.method_5942().method_6357() || this.myrmex.isInHive() || this.myrmex.shouldEnterHive()) {
            return false;
        }
        if (!(this.myrmex.method_5942() instanceof AdvancedPathNavigate) || this.myrmex.method_5765()) {
            return false;
        }
        if (this.myrmex.getWaitTicks() > 0) {
            return false;
        }
        List<class_2338> edibleBlocks = this.getEdibleBlocks();
        if (edibleBlocks.isEmpty()) {
            return this.myrmex.method_6051().method_43048(this.chance) == 0 && this.increaseRadiusAndWander();
        }
        edibleBlocks.sort(this.targetSorter);
        this.targetBlock = edibleBlocks.get(0);
        this.path = ((AdvancedPathNavigate)this.myrmex.method_5942()).moveToXYZ((double)this.targetBlock.method_10263(), (double)this.targetBlock.method_10264(), (double)this.targetBlock.method_10260(), 1.0);
        return this.myrmex.method_6051().method_43048(this.chance) == 0;
    }

    public boolean method_6266() {
        if (this.targetBlock == null) {
            return false;
        }
        if (this.myrmex.getWaitTicks() > 0) {
            return false;
        }
        if (this.myrmex.shouldEnterHive()) {
            this.myrmex.keepSearching = false;
            return false;
        }
        return !this.myrmex.holdingSomething();
    }

    public void method_6268() {
        if (this.targetBlock != null && this.myrmex.keepSearching) {
            if (this.myrmex.isCloseEnoughToTarget(this.targetBlock, 12.0) || !this.myrmex.pathReachesTarget(this.path, this.targetBlock, 12.0)) {
                this.failedToFindPath = 0;
                List<class_2338> edibleBlocks = this.getEdibleBlocks();
                if (!edibleBlocks.isEmpty()) {
                    this.myrmex.keepSearching = false;
                    edibleBlocks.sort(this.targetSorter);
                    this.targetBlock = edibleBlocks.get(0);
                    this.path = ((AdvancedPathNavigate)this.myrmex.method_5942()).moveToXYZ((double)this.targetBlock.method_10263(), (double)this.targetBlock.method_10264(), (double)this.targetBlock.method_10260(), 1.0);
                } else {
                    this.increaseRadiusAndWander();
                }
            }
        } else if (!this.myrmex.keepSearching) {
            this.failedToFindPath = 0;
            class_2680 block = this.myrmex.method_37908().method_8320(this.targetBlock);
            if (block.method_26164(IafBlockTags.MYRMEX_HARVESTABLES)) {
                double distance = this.getDistanceSq(this.targetBlock);
                if (distance < 6.0) {
                    block.method_26204();
                    List drops = class_2248.method_9562((class_2680)block, (class_3218)((class_3218)this.myrmex.method_37908()), (class_2338)this.targetBlock, (class_2586)this.myrmex.method_37908().method_8321(this.targetBlock));
                    if (!drops.isEmpty()) {
                        this.myrmex.method_37908().method_22352(this.targetBlock, false);
                        class_1799 heldStack = ((class_1799)drops.get(0)).method_7972();
                        heldStack.method_7939(1);
                        ((class_1799)drops.get(0)).method_7934(1);
                        this.myrmex.method_6122(class_1268.field_5808, heldStack);
                        for (class_1799 stack : drops) {
                            class_1542 itemEntity = new class_1542(this.myrmex.method_37908(), (double)this.targetBlock.method_10263() + this.myrmex.method_6051().method_43058(), (double)this.targetBlock.method_10264() + this.myrmex.method_6051().method_43058(), (double)this.targetBlock.method_10260() + this.myrmex.method_6051().method_43058(), stack);
                            itemEntity.method_6988();
                            if (this.myrmex.method_37908().field_9236) continue;
                            this.myrmex.method_37908().method_8649((class_1297)itemEntity);
                        }
                        this.targetBlock = null;
                        this.method_6270();
                        this.myrmex.keepSearching = false;
                        this.wanderRadius = 16;
                    }
                } else if (!this.myrmex.pathReachesTarget(this.path, this.targetBlock, 12.0)) {
                    List<class_2338> edibleBlocks = this.getEdibleBlocks();
                    if (!edibleBlocks.isEmpty()) {
                        this.myrmex.keepSearching = false;
                        this.targetBlock = edibleBlocks.get(this.myrmex.method_6051().method_43048(edibleBlocks.size()));
                        this.path = ((AdvancedPathNavigate)this.myrmex.method_5942()).moveToXYZ((double)this.targetBlock.method_10263(), (double)this.targetBlock.method_10264(), (double)this.targetBlock.method_10260(), 1.0);
                    } else {
                        this.myrmex.keepSearching = true;
                    }
                }
            }
        }
    }

    public void method_6270() {
        this.targetBlock = null;
        this.myrmex.keepSearching = true;
    }

    private double getDistanceSq(class_2338 pos) {
        double deltaX = this.myrmex.method_23317() - ((double)pos.method_10263() + 0.5);
        double deltaY = this.myrmex.method_23318() + (double)this.myrmex.method_5751() - ((double)pos.method_10264() + 0.5);
        double deltaZ = this.myrmex.method_23321() - ((double)pos.method_10260() + 0.5);
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    private List<class_2338> getEdibleBlocks() {
        ArrayList<class_2338> allBlocks = new ArrayList<class_2338>();
        class_2338.method_20437((class_2338)this.myrmex.method_24515().method_10069(-16, -8, -16), (class_2338)this.myrmex.method_24515().method_10069(16, 8, 16)).map(class_2338::method_10062).forEach(pos -> {
            class_2680 blockState;
            if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((class_1309)this.myrmex, pos.method_10263(), pos.method_10264(), pos.method_10260()) && (blockState = this.myrmex.method_37908().method_8320(pos)).method_26164(IafBlockTags.MYRMEX_HARVESTABLES)) {
                allBlocks.add((class_2338)pos);
                this.myrmex.keepSearching = false;
            }
        });
        return allBlocks;
    }

    private boolean increaseRadiusAndWander() {
        class_243 vec;
        this.myrmex.keepSearching = true;
        if (this.myrmex.getHive() != null) {
            this.wanderRadius = this.myrmex.getHive().getWanderRadius();
            this.myrmex.getHive().setWanderRadius(this.wanderRadius * 2);
        }
        this.wanderRadius *= 2;
        if (this.wanderRadius >= (Integer)IafCommonConfig.INSTANCE.myrmex.maximumWanderRadius.getValue()) {
            this.wanderRadius = (Integer)IafCommonConfig.INSTANCE.myrmex.maximumWanderRadius.getValue();
            this.myrmex.setWaitTicks(80 + ThreadLocalRandom.current().nextInt(40));
            ++this.failedToFindPath;
            if (this.failedToFindPath >= 10) {
                this.myrmex.setWaitTicks(800 + ThreadLocalRandom.current().nextInt(40));
            }
        }
        if ((vec = class_5532.method_31510((class_1314)this.myrmex, (int)this.wanderRadius, (int)7)) != null) {
            this.targetBlock = class_2338.method_49638((class_2374)vec);
        }
        if (this.targetBlock != null) {
            this.path = ((AdvancedPathNavigate)this.myrmex.method_5942()).moveToXYZ((double)this.targetBlock.method_10263(), (double)this.targetBlock.method_10264(), (double)this.targetBlock.method_10260(), 1.0);
            return true;
        }
        return false;
    }

    public class BlockSorter
    implements Comparator<class_2338> {
        @Override
        public int compare(class_2338 pos1, class_2338 pos2) {
            double distance1 = MyrmexAIForage.this.getDistanceSq(pos1);
            double distance2 = MyrmexAIForage.this.getDistanceSq(pos2);
            return Double.compare(distance1, distance2);
        }
    }
}

