/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.entity.block.BlockEntityMyrmexCocoon;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexCocoon;
import com.iafenvoy.iceandfire.world.gen.WorldGenMyrmexHive;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathFindingStatus;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class MyrmexAIStoreItems
extends class_1352 {
    private final EntityMyrmexBase myrmex;
    private final double movementSpeed;
    private class_2338 nextRoom = null;
    private class_2338 nextCocoon = null;
    private class_2338 mainRoom = null;
    private boolean first = true;
    private PathResult path;

    public MyrmexAIStoreItems(EntityMyrmexBase entityIn, double movementSpeedIn) {
        this.myrmex = entityIn;
        this.movementSpeed = movementSpeedIn;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (!this.myrmex.canMove() || this.myrmex instanceof EntityMyrmexWorker && ((EntityMyrmexWorker)this.myrmex).holdingBaby() || !this.myrmex.shouldEnterHive() && !this.myrmex.method_5942().method_6357() || this.myrmex.method_5998(class_1268.field_5808).method_7960()) {
            return false;
        }
        if (!(this.myrmex.method_5942() instanceof AdvancedPathNavigate) || this.myrmex.method_5765()) {
            return false;
        }
        if (this.myrmex.getWaitTicks() > 0) {
            return false;
        }
        MyrmexHive village = this.myrmex.getHive();
        if (village == null) {
            return false;
        }
        if (!this.myrmex.isInHive()) {
            return false;
        }
        this.first = true;
        this.mainRoom = MyrmexHive.getGroundedPos((class_1936)this.myrmex.method_37908(), village.getCenter());
        this.nextRoom = MyrmexHive.getGroundedPos((class_1936)this.myrmex.method_37908(), village.getRandomRoom(WorldGenMyrmexHive.RoomType.FOOD, this.myrmex.method_6051(), this.myrmex.method_24515()));
        this.nextCocoon = this.getNearbyCocoon(this.nextRoom);
        if (this.nextCocoon == null) {
            this.myrmex.setWaitTicks(20 + ThreadLocalRandom.current().nextInt(40));
        }
        this.path = ((AdvancedPathNavigate)this.myrmex.method_5942()).moveToXYZ((double)this.mainRoom.method_10263() + 0.5, (double)this.mainRoom.method_10264() + 0.5, (double)this.mainRoom.method_10260() + 0.5, this.movementSpeed);
        return this.nextCocoon != null;
    }

    public boolean method_6266() {
        return !this.myrmex.method_5998(class_1268.field_5808).method_7960() && this.nextCocoon != null && this.isUseableCocoon(this.nextCocoon) && !this.myrmex.isCloseEnoughToTarget(this.nextCocoon, 3.0) && this.myrmex.shouldEnterHive();
    }

    public void method_6268() {
        if (this.first && this.mainRoom != null) {
            if (this.myrmex.isCloseEnoughToTarget(this.mainRoom, 10.0)) {
                this.path = ((AdvancedPathNavigate)this.myrmex.method_5942()).moveToXYZ((double)this.nextCocoon.method_10263() + 0.5, (double)this.nextCocoon.method_10264() + 0.5, (double)this.nextCocoon.method_10260() + 0.5, this.movementSpeed);
                this.first = false;
            } else if (!this.myrmex.pathReachesTarget(this.path, this.mainRoom, 9.0)) {
                this.nextCocoon = null;
            }
        }
        if (!this.first && this.nextCocoon != null) {
            double dist = 9.0;
            if (this.myrmex.isCloseEnoughToTarget(this.nextCocoon, 9.0) && !this.myrmex.method_5998(class_1268.field_5808).method_7960() && this.isUseableCocoon(this.nextCocoon)) {
                BlockEntityMyrmexCocoon cocoon = (BlockEntityMyrmexCocoon)this.myrmex.method_37908().method_8321(this.nextCocoon);
                class_1799 itemstack = this.myrmex.method_5998(class_1268.field_5808);
                assert (cocoon != null);
                if (!itemstack.method_7960()) {
                    for (int i = 0; i < cocoon.method_5439(); ++i) {
                        if (itemstack.method_7960()) continue;
                        class_1799 cocoonStack = cocoon.method_5438(i);
                        if (cocoonStack.method_7960()) {
                            cocoon.method_5447(i, itemstack.method_7972());
                            cocoon.method_5431();
                            this.myrmex.method_6122(class_1268.field_5808, class_1799.field_8037);
                            this.myrmex.isEnteringHive = false;
                            return;
                        }
                        if (cocoonStack.method_7909() != itemstack.method_7909()) continue;
                        int j = Math.min(cocoon.method_5444(), cocoonStack.method_7914());
                        int k = Math.min(itemstack.method_7947(), j - cocoonStack.method_7947());
                        if (k <= 0) continue;
                        cocoonStack.method_7933(k);
                        itemstack.method_7934(k);
                        if (itemstack.method_7960()) {
                            cocoon.method_5431();
                        }
                        this.myrmex.method_6122(class_1268.field_5808, class_1799.field_8037);
                        this.myrmex.isEnteringHive = false;
                        return;
                    }
                }
            } else if (!this.myrmex.method_5998(class_1268.field_5808).method_7960() && this.path.getStatus() == PathFindingStatus.COMPLETE && !this.myrmex.pathReachesTarget(this.path, this.nextCocoon, 9.0)) {
                this.nextCocoon = this.getNearbyCocoon(this.nextRoom);
                if (this.nextCocoon != null) {
                    this.path = ((AdvancedPathNavigate)this.myrmex.method_5942()).moveToXYZ((double)this.nextCocoon.method_10263() + 0.5, (double)this.nextCocoon.method_10264() + 0.5, (double)this.nextCocoon.method_10260() + 0.5, this.movementSpeed);
                }
            } else if (this.myrmex.pathReachesTarget(this.path, this.nextCocoon, 9.0) && this.path.isCancelled()) {
                this.method_6270();
            }
        }
    }

    public void method_6270() {
        this.nextRoom = null;
        this.nextCocoon = null;
        this.mainRoom = null;
        this.first = true;
    }

    public class_2338 getNearbyCocoon(class_2338 roomCenter) {
        int RADIUS_XZ = 15;
        int RADIUS_Y = 7;
        ArrayList closeCocoons = new ArrayList();
        class_2338.method_20437((class_2338)roomCenter.method_10069(-RADIUS_XZ, -RADIUS_Y, -RADIUS_XZ), (class_2338)roomCenter.method_10069(RADIUS_XZ, RADIUS_Y, RADIUS_XZ)).forEach(blockpos -> {
            BlockEntityMyrmexCocoon myrmexCocoon;
            class_2586 te = this.myrmex.method_37908().method_8321(blockpos);
            if (te instanceof BlockEntityMyrmexCocoon && !(myrmexCocoon = (BlockEntityMyrmexCocoon)te).isFull(this.myrmex.method_5998(class_1268.field_5808))) {
                closeCocoons.add(te.method_11016());
            }
        });
        if (closeCocoons.isEmpty()) {
            return null;
        }
        return (class_2338)closeCocoons.get(this.myrmex.method_6051().method_43048(Math.max(closeCocoons.size() - 1, 1)));
    }

    public boolean isUseableCocoon(class_2338 blockpos) {
        class_2586 class_25862;
        if (this.myrmex.method_37908().method_8320(blockpos).method_26204() instanceof BlockMyrmexCocoon && this.myrmex.method_37908().method_8321(blockpos) != null && (class_25862 = this.myrmex.method_37908().method_8321(blockpos)) instanceof BlockEntityMyrmexCocoon) {
            BlockEntityMyrmexCocoon myrmexCocoon = (BlockEntityMyrmexCocoon)class_25862;
            return !myrmexCocoon.isFull(this.myrmex.method_5998(class_1268.field_5808));
        }
        return false;
    }
}

