/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.util.IafMath;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_238;

public class PixieAIPickupItem<T extends class_1542>
extends class_1405 {
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super class_1542> targetEntitySelector;
    protected class_1542 targetEntity;
    private List<class_1542> list = IafMath.emptyItemEntityList;

    public PixieAIPickupItem(EntityPixie creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public PixieAIPickupItem(EntityPixie creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public PixieAIPickupItem(EntityPixie creature, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super T> targetSelector) {
        super((class_1308)creature, checkSight, onlyNearby);
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((class_1297)creature);
        this.targetEntitySelector = item -> item != null && !item.method_6983().method_7960() && (item.method_6983().method_7909() == class_1802.field_17534 && !creature.method_6181() || item.method_6983().method_7909() == class_1802.field_8479 && creature.method_6181() && creature.method_6032() < creature.method_6063());
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public boolean method_6264() {
        EntityPixie pixie = (EntityPixie)this.field_6660;
        if (pixie.isPixieSitting()) {
            return false;
        }
        if (this.field_6660.method_37908().method_8510() % 4L == 0L) {
            this.list = this.field_6660.method_37908().method_8390(class_1542.class, this.getTargetableArea(this.method_6326()), this.targetEntitySelector);
        }
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.get(0);
        return true;
    }

    protected class_238 getTargetableArea(double targetDistance) {
        return this.field_6660.method_5829().method_1009(targetDistance, 4.0, targetDistance);
    }

    public void method_6269() {
        this.field_6660.method_5962().method_6239(this.targetEntity.method_23317(), this.targetEntity.method_23318(), this.targetEntity.method_23321(), 0.25);
        class_1309 attackTarget = this.field_6660.method_5968();
        if (attackTarget == null) {
            this.field_6660.method_5988().method_6230(this.targetEntity.method_23317(), this.targetEntity.method_23318(), this.targetEntity.method_23321(), 180.0f, 20.0f);
        }
        super.method_6269();
    }

    public void method_6268() {
        super.method_6268();
        if (this.targetEntity == null || !this.targetEntity.method_5805()) {
            this.method_6270();
        } else if (this.field_6660.method_5858((class_1297)this.targetEntity) < 1.0) {
            EntityPixie pixie = (EntityPixie)this.field_6660;
            if (this.targetEntity.method_6983() != null && this.targetEntity.method_6983().method_7909() != null) {
                class_1297 class_12972;
                if (this.targetEntity.method_6983().method_31573(IafItemTags.HEAL_PIXIE)) {
                    pixie.method_6025(5.0f);
                } else if (this.targetEntity.method_6983().method_31573(IafItemTags.TAME_PIXIE) && !pixie.method_6181() && (class_12972 = this.targetEntity.method_24921()) instanceof class_1657) {
                    class_1657 player = (class_1657)class_12972;
                    pixie.method_6170(player);
                    pixie.setPixieSitting(true);
                    pixie.method_24830(true);
                }
            }
            pixie.method_6122(class_1268.field_5808, this.targetEntity.method_6983());
            this.targetEntity.method_6983().method_7934(1);
            pixie.method_5783(IafSounds.PIXIE_TAUNT, 1.0f, 1.0f);
            this.method_6270();
        }
    }

    public boolean method_6266() {
        return true;
    }

    public static class Sorter
    implements Comparator<class_1297> {
        private final class_1297 theEntity;

        public Sorter(class_1297 theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(class_1297 p_compare_1_, class_1297 p_compare_2_) {
            double d0 = this.theEntity.method_5858(p_compare_1_);
            double d1 = this.theEntity.method_5858(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

