/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.delegate.DragonForgePropertyDelegate;
import com.iafenvoy.iceandfire.item.block.BlockDragonForgeBricks;
import com.iafenvoy.iceandfire.item.block.BlockDragonForgeCore;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.iafenvoy.iceandfire.screen.handler.DragonForgeScreenHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class BlockEntityDragonForge
extends class_2624
implements class_1278 {
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{2};
    private static final int[] SLOTS_SIDES = new int[]{0, 1};
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    private final DragonForgePropertyDelegate propertyDelegate = new DragonForgePropertyDelegate();
    public int lastDragonFlameTimer = 0;
    private class_2371<class_1799> forgeItemStacks = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private boolean prevAssembled;
    private boolean canAddFlameAgain = true;

    public BlockEntityDragonForge(class_2338 pos, class_2680 state) {
        super(IafBlockEntities.DRAGONFORGE_CORE, pos, state);
    }

    public BlockEntityDragonForge(class_2338 pos, class_2680 state, int fireType) {
        super(IafBlockEntities.DRAGONFORGE_CORE, pos, state);
        this.getPropertyDelegate().fireType = fireType;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BlockEntityDragonForge entityDragonforge) {
        boolean flag = entityDragonforge.isBurning();
        boolean flag1 = false;
        entityDragonforge.getPropertyDelegate().fireType = entityDragonforge.getFireType(entityDragonforge.method_11010().method_26204());
        if (entityDragonforge.lastDragonFlameTimer > 0) {
            --entityDragonforge.lastDragonFlameTimer;
        }
        entityDragonforge.updateGrills(entityDragonforge.assembled());
        if (!level.field_9236) {
            if (entityDragonforge.prevAssembled != entityDragonforge.assembled()) {
                BlockDragonForgeCore.setState(entityDragonforge.getPropertyDelegate().fireType, entityDragonforge.prevAssembled, level, pos);
            }
            entityDragonforge.prevAssembled = entityDragonforge.assembled();
            if (!entityDragonforge.assembled()) {
                return;
            }
        }
        if (entityDragonforge.getPropertyDelegate().cookTime > 0 && entityDragonforge.canSmelt() && entityDragonforge.lastDragonFlameTimer == 0) {
            --entityDragonforge.getPropertyDelegate().cookTime;
        }
        if (entityDragonforge.method_5438(0).method_7960() && !level.field_9236) {
            entityDragonforge.getPropertyDelegate().cookTime = 0;
        }
        assert (entityDragonforge.field_11863 != null);
        if (!entityDragonforge.field_11863.field_9236) {
            if (entityDragonforge.isBurning()) {
                if (entityDragonforge.canSmelt()) {
                    ++entityDragonforge.getPropertyDelegate().cookTime;
                    if (entityDragonforge.getPropertyDelegate().cookTime >= entityDragonforge.getMaxCookTime()) {
                        entityDragonforge.getPropertyDelegate().cookTime = 0;
                        entityDragonforge.smeltItem();
                        flag1 = true;
                    }
                } else if (entityDragonforge.getPropertyDelegate().cookTime > 0) {
                    entityDragonforge.lastDragonFlameTimer = 40;
                    entityDragonforge.getPropertyDelegate().cookTime = 0;
                }
            } else if (!entityDragonforge.isBurning() && entityDragonforge.getPropertyDelegate().cookTime > 0) {
                entityDragonforge.getPropertyDelegate().cookTime = class_3532.method_15340((int)(entityDragonforge.getPropertyDelegate().cookTime - 2), (int)0, (int)entityDragonforge.getMaxCookTime());
            }
            if (flag != entityDragonforge.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            entityDragonforge.method_5431();
        }
        if (!entityDragonforge.canAddFlameAgain) {
            entityDragonforge.canAddFlameAgain = true;
        }
    }

    public int method_5439() {
        return this.forgeItemStacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.forgeItemStacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private void updateGrills(boolean grill) {
        for (class_2350 facing : HORIZONTALS) {
            class_2338 grillPos = this.method_11016().method_10093(facing);
            assert (this.field_11863 != null);
            if (!this.grillMatches(this.field_11863.method_8320(grillPos).method_26204())) continue;
            class_2680 grillState = (class_2680)this.getGrillBlock().method_9564().method_11657((class_2769)BlockDragonForgeBricks.GRILL, (Comparable)Boolean.valueOf(grill));
            if (this.field_11863.method_8320(grillPos) == grillState) continue;
            this.field_11863.method_8501(grillPos, grillState);
        }
    }

    public class_2248 getGrillBlock() {
        return switch (this.getPropertyDelegate().fireType) {
            case 1 -> IafBlocks.DRAGONFORGE_ICE_BRICK;
            case 2 -> IafBlocks.DRAGONFORGE_LIGHTNING_BRICK;
            default -> IafBlocks.DRAGONFORGE_FIRE_BRICK;
        };
    }

    public boolean grillMatches(class_2248 block) {
        return switch (this.getPropertyDelegate().fireType) {
            case 0 -> {
                if (block == IafBlocks.DRAGONFORGE_FIRE_BRICK) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (block == IafBlocks.DRAGONFORGE_ICE_BRICK) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (block == IafBlocks.DRAGONFORGE_LIGHTNING_BRICK) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.forgeItemStacks.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.forgeItemStacks, (int)index, (int)count);
    }

    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.forgeItemStacks, (int)index);
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 itemstack = (class_1799)this.forgeItemStacks.get(index);
        boolean flag = !stack.method_7960() && class_1799.method_7984((class_1799)stack, (class_1799)itemstack) && class_1799.method_7973((class_1799)stack, (class_1799)itemstack);
        this.forgeItemStacks.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (index == 0 && !flag || this.getPropertyDelegate().cookTime > this.getMaxCookTime()) {
            this.getPropertyDelegate().cookTime = 0;
            this.method_5431();
        }
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.forgeItemStacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compound, this.forgeItemStacks);
        this.getPropertyDelegate().cookTime = compound.method_10550("CookTime");
    }

    public void method_11007(class_2487 compound) {
        compound.method_10569("CookTime", (int)((short)this.getPropertyDelegate().cookTime));
        class_1262.method_5426((class_2487)compound, this.forgeItemStacks);
    }

    public int method_5444() {
        return 64;
    }

    public boolean isBurning() {
        return this.getPropertyDelegate().cookTime > 0;
    }

    public int getFireType(class_2248 block) {
        if (block == IafBlocks.DRAGONFORGE_FIRE_CORE || block == IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED) {
            return 0;
        }
        if (block == IafBlocks.DRAGONFORGE_ICE_CORE || block == IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED) {
            return 1;
        }
        if (block == IafBlocks.DRAGONFORGE_LIGHTNING_CORE || block == IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED) {
            return 2;
        }
        return 0;
    }

    public String getTypeID() {
        return switch (this.getFireType(this.method_11010().method_26204())) {
            case 0 -> "fire";
            case 1 -> "ice";
            case 2 -> "lightning";
            default -> "";
        };
    }

    public int getMaxCookTime() {
        return this.getCurrentRecipe().map(DragonForgeRecipe::getCookTime).orElse(100);
    }

    private class_2248 getDefaultOutput() {
        return this.getPropertyDelegate().fireType == 1 ? IafBlocks.DRAGON_ICE : IafBlocks.ASH;
    }

    private class_1799 getCurrentResult() {
        Optional<DragonForgeRecipe> recipe = this.getCurrentRecipe();
        return recipe.map(DragonForgeRecipe::getResultItem).orElseGet(() -> new class_1799((class_1935)this.getDefaultOutput()));
    }

    public Optional<DragonForgeRecipe> getCurrentRecipe() {
        assert (this.field_11863 != null);
        return this.field_11863.method_8433().method_8132(IafRecipes.DRAGON_FORGE_TYPE, (class_1263)this, this.field_11863);
    }

    public List<DragonForgeRecipe> getRecipes() {
        assert (this.field_11863 != null);
        return this.field_11863.method_8433().method_30027(IafRecipes.DRAGON_FORGE_TYPE);
    }

    public boolean canSmelt() {
        class_1799 cookStack = (class_1799)this.forgeItemStacks.get(0);
        if (cookStack.method_7960()) {
            return false;
        }
        class_1799 forgeRecipeOutput = this.getCurrentResult();
        if (forgeRecipeOutput.method_7960()) {
            return false;
        }
        class_1799 outputStack = (class_1799)this.forgeItemStacks.get(2);
        if (!outputStack.method_7960() && !class_1799.method_7984((class_1799)outputStack, (class_1799)forgeRecipeOutput)) {
            return false;
        }
        int calculatedOutputCount = outputStack.method_7947() + forgeRecipeOutput.method_7947();
        return calculatedOutputCount <= this.method_5444() && calculatedOutputCount <= outputStack.method_7914();
    }

    public boolean method_5443(class_1657 player) {
        if (player.method_37908().method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        class_1799 cookStack = (class_1799)this.forgeItemStacks.get(0);
        class_1799 bloodStack = (class_1799)this.forgeItemStacks.get(1);
        class_1799 outputStack = (class_1799)this.forgeItemStacks.get(2);
        class_1799 output = this.getCurrentResult();
        if (outputStack.method_7960()) {
            this.forgeItemStacks.set(2, (Object)output.method_7972());
        } else {
            outputStack.method_7933(output.method_7947());
        }
        cookStack.method_7934(1);
        bloodStack.method_7934(1);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return switch (index) {
            case 1 -> this.getRecipes().stream().anyMatch(item -> item.isValidBlood(stack));
            case 0 -> true;
            default -> false;
        };
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return SLOTS_BOTTOM;
        }
        return side == class_2350.field_11036 ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean method_5492(int index, class_1799 itemStackIn, class_2350 direction) {
        return this.method_5437(index, itemStackIn);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (direction == class_2350.field_11033 && index == 1) {
            class_1792 item = stack.method_7909();
            return item == class_1802.field_8705 || item == class_1802.field_8550;
        }
        return true;
    }

    public void method_5448() {
        this.forgeItemStacks.clear();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)("container.dragonforge_fire" + DragonType.getNameFromInt(this.getPropertyDelegate().fireType)));
    }

    public void transferPower(int i) {
        assert (this.field_11863 != null);
        if (!this.field_11863.field_9236) {
            if (this.canSmelt()) {
                if (this.canAddFlameAgain) {
                    this.getPropertyDelegate().cookTime = Math.min(this.getMaxCookTime() + 1, this.getPropertyDelegate().cookTime + i);
                    this.canAddFlameAgain = false;
                }
            } else {
                this.getPropertyDelegate().cookTime = 0;
            }
        }
        this.lastDragonFlameTimer = 40;
    }

    private boolean checkBoneCorners(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10095().method_10078(), IafBlocks.DRAGON_BONE_BLOCK) && this.doesBlockEqual(pos.method_10095().method_10067(), IafBlocks.DRAGON_BONE_BLOCK) && this.doesBlockEqual(pos.method_10072().method_10078(), IafBlocks.DRAGON_BONE_BLOCK) && this.doesBlockEqual(pos.method_10072().method_10067(), IafBlocks.DRAGON_BONE_BLOCK);
    }

    private boolean checkBrickCorners(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10095().method_10078(), this.getBrick()) && this.doesBlockEqual(pos.method_10095().method_10067(), this.getBrick()) && this.doesBlockEqual(pos.method_10072().method_10078(), this.getBrick()) && this.doesBlockEqual(pos.method_10072().method_10067(), this.getBrick());
    }

    private boolean checkBrickSlots(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10095(), this.getBrick()) && this.doesBlockEqual(pos.method_10078(), this.getBrick()) && this.doesBlockEqual(pos.method_10067(), this.getBrick()) && this.doesBlockEqual(pos.method_10072(), this.getBrick());
    }

    private boolean checkY(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10084(), this.getBrick()) && this.doesBlockEqual(pos.method_10074(), this.getBrick());
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    public boolean assembled() {
        return this.checkBoneCorners(this.field_11867.method_10074()) && this.checkBrickSlots(this.field_11867.method_10074()) && this.checkBrickCorners(this.field_11867) && this.atleastThreeAreBricks(this.field_11867) && this.checkY(this.field_11867) && this.checkBoneCorners(this.field_11867.method_10084()) && this.checkBrickSlots(this.field_11867.method_10084());
    }

    private class_2248 getBrick() {
        return switch (this.getPropertyDelegate().fireType) {
            case 0 -> IafBlocks.DRAGONFORGE_FIRE_BRICK;
            case 1 -> IafBlocks.DRAGONFORGE_ICE_BRICK;
            default -> IafBlocks.DRAGONFORGE_LIGHTNING_BRICK;
        };
    }

    private boolean doesBlockEqual(class_2338 pos, class_2248 block) {
        assert (this.field_11863 != null);
        return this.field_11863.method_8320(pos).method_26204() == block;
    }

    private boolean atleastThreeAreBricks(class_2338 pos) {
        int count = 0;
        for (class_2350 facing : HORIZONTALS) {
            assert (this.field_11863 != null);
            if (this.field_11863.method_8320(pos.method_10093(facing)).method_26204() != this.getBrick()) continue;
            ++count;
        }
        return count > 2;
    }

    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new DragonForgeScreenHandler(id, (class_1263)this, playerInventory, this.getPropertyDelegate());
    }

    protected class_1703 method_5465(int id, class_1661 player) {
        return new DragonForgeScreenHandler(id, (class_1263)this, player, this.getPropertyDelegate());
    }

    public DragonForgePropertyDelegate getPropertyDelegate() {
        return this.propertyDelegate;
    }
}

