/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexQueen;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.gen.WorldGenMyrmexHive;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_5819;

public class MyrmexHive {
    private final List<class_2338> foodRooms = Lists.newArrayList();
    private final List<class_2338> babyRooms = Lists.newArrayList();
    private final List<class_2338> miscRooms = Lists.newArrayList();
    private final List<class_2338> allRooms = Lists.newArrayList();
    private final Map<class_2338, class_2350> entrances = Maps.newHashMap();
    private final Map<class_2338, class_2350> entranceBottoms = Maps.newHashMap();
    private final Map<UUID, Integer> playerReputation = Maps.newHashMap();
    private final List<HiveAggressor> villageAgressors = Lists.newArrayList();
    private final List<UUID> myrmexList = Lists.newArrayList();
    public UUID hiveUUID;
    public String colonyName = "";
    public boolean reproduces = true;
    public boolean hasOwner = false;
    public UUID ownerUUID = null;
    private class_1937 world;
    private class_2338 centerHelper = class_2338.field_10980;
    private class_2338 center = class_2338.field_10980;
    private int villageRadius;
    private int lastAddDoorTimestamp;
    private int tickCounter;
    private int numMyrmex;
    private int noBreedTicks;
    private int wanderRadius = 16;

    public MyrmexHive() {
        this.hiveUUID = UUID.randomUUID();
    }

    public MyrmexHive(class_1937 worldIn) {
        this.world = worldIn;
        this.hiveUUID = UUID.randomUUID();
    }

    public MyrmexHive(class_1937 worldIn, class_2338 center, int radius) {
        this.world = worldIn;
        this.center = center;
        this.villageRadius = radius;
        this.hiveUUID = UUID.randomUUID();
    }

    public static class_2338 getGroundedPos(class_1936 world, class_2338 pos) {
        class_2338 current = pos;
        while (world.method_22347(current.method_10074()) && current.method_10264() > 0) {
            current = current.method_10074();
        }
        return current;
    }

    public static MyrmexHive fromNBT(class_2487 hive) {
        MyrmexHive hive1 = new MyrmexHive();
        hive1.readVillageDataFromNBT(hive);
        return hive1;
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        this.writeVillageDataToNBT(tag);
        return tag;
    }

    public void setWorld(class_1937 worldIn) {
        this.world = worldIn;
    }

    public void tick(int tickCounterIn, class_1937 world) {
        ++this.tickCounter;
        this.removeDeadAndOldAgressors();
        if (this.tickCounter % 20 == 0) {
            this.updateNumMyrmex(world);
        }
    }

    private void updateNumMyrmex(class_1937 world) {
        this.numMyrmex = this.myrmexList.size();
        if (this.numMyrmex == 0) {
            this.playerReputation.clear();
        }
    }

    public EntityMyrmexQueen getQueen() {
        ArrayList<EntityMyrmexQueen> ourQueens = new ArrayList<EntityMyrmexQueen>();
        if (!this.world.field_9236) {
            assert (this.world.method_8503() != null);
            class_3218 serverWorld = this.world.method_8503().method_3847(this.world.method_27983());
            assert (serverWorld != null);
            List allQueens = serverWorld.method_18198(IafEntities.MYRMEX_QUEEN, class_1301.field_6155);
            for (EntityMyrmexQueen queen : allQueens) {
                if (!(queen instanceof EntityMyrmexQueen) || !queen.getHive().equals(this)) continue;
                ourQueens.add(queen);
            }
        }
        return ourQueens.isEmpty() ? null : (EntityMyrmexQueen)ourQueens.get(0);
    }

    public class_2338 getCenter() {
        return this.center;
    }

    public class_2338 getCenterGround() {
        return MyrmexHive.getGroundedPos((class_1936)this.world, this.center);
    }

    public int getVillageRadius() {
        return this.villageRadius;
    }

    public int getNumMyrmex() {
        return this.numMyrmex;
    }

    public int getWanderRadius() {
        return this.wanderRadius;
    }

    public void setWanderRadius(int wanderRadius) {
        this.wanderRadius = Math.min(wanderRadius, (Integer)IafCommonConfig.INSTANCE.myrmex.maximumWanderRadius.getValue());
    }

    public boolean isBlockPosWithinSqVillageRadius(class_2338 pos) {
        return this.center.method_10262((class_2382)pos) < (double)(this.villageRadius * this.villageRadius);
    }

    public boolean isAnnihilated() {
        return false;
    }

    public void addOrRenewAgressor(class_1309 LivingEntityIn, int agressiveLevel) {
        for (HiveAggressor hiveAggressor : this.villageAgressors) {
            if (hiveAggressor.agressor != LivingEntityIn) continue;
            hiveAggressor.agressionTime = this.tickCounter;
            return;
        }
        this.villageAgressors.add(new HiveAggressor(LivingEntityIn, this.tickCounter, agressiveLevel));
    }

    public class_1309 findNearestVillageAggressor(class_1309 LivingEntityIn) {
        double d0 = Double.MAX_VALUE;
        int previousAgressionLevel = 0;
        HiveAggressor hiveAggressor = null;
        for (HiveAggressor hive$villageaggressor1 : this.villageAgressors) {
            double d1 = hive$villageaggressor1.agressor.method_5858((class_1297)LivingEntityIn);
            int agressionLevel = hive$villageaggressor1.agressionLevel;
            if (d1 <= d0 || agressionLevel > previousAgressionLevel) {
                hiveAggressor = hive$villageaggressor1;
                d0 = d1;
            }
            previousAgressionLevel = agressionLevel;
        }
        return hiveAggressor == null ? null : hiveAggressor.agressor;
    }

    public class_1657 getNearestTargetPlayer(class_1309 villageDefender, class_1937 world) {
        double d0 = Double.MAX_VALUE;
        class_1657 PlayerEntity = null;
        for (UUID s : this.playerReputation.keySet()) {
            double d1;
            class_1657 PlayerEntity1;
            if (!this.isPlayerReputationLowEnoughToFight(s) || (PlayerEntity1 = world.method_18470(s)) == null || !((d1 = PlayerEntity1.method_5858((class_1297)villageDefender)) <= d0)) continue;
            PlayerEntity = PlayerEntity1;
            d0 = d1;
        }
        return PlayerEntity;
    }

    private void removeDeadAndOldAgressors() {
        this.villageAgressors.removeIf(hive$villageaggressor -> !hive$villageaggressor.agressor.method_5805() || Math.abs(this.tickCounter - hive$villageaggressor.agressionTime) > 300);
    }

    public int getPlayerReputation(UUID playerName) {
        Integer integer = this.playerReputation.get(playerName);
        return integer == null ? 0 : integer;
    }

    private UUID findUUID(String name) {
        if (this.world == null || this.world.method_8503() == null) {
            return class_4844.method_43344((String)name);
        }
        Optional profile = this.world.method_8503().method_3793().method_14515(name);
        return profile.isPresent() ? class_4844.method_43343((GameProfile)((GameProfile)profile.get())) : class_4844.method_43344((String)name);
    }

    public void modifyPlayerReputation(UUID playerName, int reputation) {
        int i = this.getPlayerReputation(playerName);
        int j = class_3532.method_15340((int)(i + reputation), (int)0, (int)100);
        if (this.hasOwner && playerName.equals(this.ownerUUID)) {
            j = 100;
        }
        class_1657 player = null;
        try {
            player = this.world.method_18470(playerName);
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Myrmex Hive could not find player with associated UUID");
        }
        if (player != null) {
            if (j - i != 0) {
                player.method_7353((class_2561)class_2561.method_43469((String)(j - i >= 0 ? "myrmex.message.raised_reputation" : "myrmex.message.lowered_reputation"), (Object[])new Object[]{Math.abs(j - i), j}), true);
            }
            if (i < 25 && j >= 25) {
                player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.peaceful"), false);
            }
            if (i >= 25 && j < 25) {
                player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.hostile"), false);
            }
            if (i < 50 && j >= 50) {
                player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.trade"), false);
            }
            if (i >= 50 && j < 50) {
                player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.no_trade"), false);
            }
            if (i < 75 && j >= 75) {
                player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.can_use_staff"), false);
            }
            if (i >= 75 && j < 75) {
                player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.cant_use_staff"), false);
            }
        }
        this.playerReputation.put(playerName, j);
    }

    public boolean isPlayerReputationTooLowToTrade(UUID uuid) {
        return this.getPlayerReputation(uuid) < 50;
    }

    public boolean canPlayerCommandHive(UUID uuid) {
        return this.getPlayerReputation(uuid) >= 75;
    }

    public boolean isPlayerReputationLowEnoughToFight(UUID uuid) {
        return this.getPlayerReputation(uuid) < 25;
    }

    public void readVillageDataFromNBT(class_2487 compound) {
        this.numMyrmex = compound.method_10550("PopSize");
        this.reproduces = compound.method_10577("Reproduces");
        this.hasOwner = compound.method_10577("HasOwner");
        if (compound.method_25928("OwnerUUID")) {
            this.ownerUUID = compound.method_25926("OwnerUUID");
        }
        this.colonyName = compound.method_10558("ColonyName");
        this.villageRadius = compound.method_10550("Radius");
        if (compound.method_25928("WanderRadius")) {
            this.wanderRadius = compound.method_10550("WanderRadius");
        }
        this.lastAddDoorTimestamp = compound.method_10550("Stable");
        this.tickCounter = compound.method_10550("Tick");
        this.noBreedTicks = compound.method_10550("MTick");
        this.center = new class_2338(compound.method_10550("CX"), compound.method_10550("CY"), compound.method_10550("CZ"));
        this.centerHelper = new class_2338(compound.method_10550("ACX"), compound.method_10550("ACY"), compound.method_10550("ACZ"));
        class_2499 hiveMembers = compound.method_10554("HiveMembers", 10);
        this.myrmexList.clear();
        for (int i = 0; i < hiveMembers.size(); ++i) {
            class_2487 CompoundNBT = hiveMembers.method_10602(i);
            this.myrmexList.add(CompoundNBT.method_25926("MyrmexUUID"));
        }
        class_2499 foodRoomList = compound.method_10554("FoodRooms", 10);
        this.foodRooms.clear();
        for (int i = 0; i < foodRoomList.size(); ++i) {
            class_2487 CompoundNBT = foodRoomList.method_10602(i);
            this.foodRooms.add(new class_2338(CompoundNBT.method_10550("X"), CompoundNBT.method_10550("Y"), CompoundNBT.method_10550("Z")));
        }
        class_2499 babyRoomList = compound.method_10554("BabyRooms", 10);
        this.babyRooms.clear();
        for (int i = 0; i < babyRoomList.size(); ++i) {
            class_2487 CompoundNBT = babyRoomList.method_10602(i);
            this.babyRooms.add(new class_2338(CompoundNBT.method_10550("X"), CompoundNBT.method_10550("Y"), CompoundNBT.method_10550("Z")));
        }
        class_2499 miscRoomList = compound.method_10554("MiscRooms", 10);
        this.miscRooms.clear();
        for (int i = 0; i < miscRoomList.size(); ++i) {
            class_2487 CompoundNBT = miscRoomList.method_10602(i);
            this.miscRooms.add(new class_2338(CompoundNBT.method_10550("X"), CompoundNBT.method_10550("Y"), CompoundNBT.method_10550("Z")));
        }
        class_2499 entrancesList = compound.method_10554("Entrances", 10);
        this.entrances.clear();
        for (int i = 0; i < entrancesList.size(); ++i) {
            class_2487 CompoundNBT = entrancesList.method_10602(i);
            this.entrances.put(new class_2338(CompoundNBT.method_10550("X"), CompoundNBT.method_10550("Y"), CompoundNBT.method_10550("Z")), class_2350.method_10139((int)CompoundNBT.method_10550("Facing")));
        }
        class_2499 entranceBottomsList = compound.method_10554("EntranceBottoms", 10);
        this.entranceBottoms.clear();
        for (int i = 0; i < entranceBottomsList.size(); ++i) {
            class_2487 CompoundNBT = entranceBottomsList.method_10602(i);
            this.entranceBottoms.put(new class_2338(CompoundNBT.method_10550("X"), CompoundNBT.method_10550("Y"), CompoundNBT.method_10550("Z")), class_2350.method_10139((int)CompoundNBT.method_10550("Facing")));
        }
        this.hiveUUID = compound.method_25926("HiveUUID");
        class_2499 nbttaglist1 = compound.method_10554("Players", 10);
        this.playerReputation.clear();
        for (int j = 0; j < nbttaglist1.size(); ++j) {
            class_2487 CompoundNBT1 = nbttaglist1.method_10602(j);
            if (CompoundNBT1.method_25928("UUID")) {
                this.playerReputation.put(CompoundNBT1.method_25926("UUID"), CompoundNBT1.method_10550("S"));
                continue;
            }
            this.playerReputation.put(this.findUUID(CompoundNBT1.method_10558("Name")), CompoundNBT1.method_10550("S"));
        }
    }

    public void writeVillageDataToNBT(class_2487 compound) {
        compound.method_10569("PopSize", this.numMyrmex);
        compound.method_10556("Reproduces", this.reproduces);
        compound.method_10556("HasOwner", this.hasOwner);
        if (this.ownerUUID != null) {
            compound.method_25927("OwnerUUID", this.ownerUUID);
        }
        compound.method_10582("ColonyName", this.colonyName);
        compound.method_10569("Radius", this.villageRadius);
        compound.method_10569("WanderRadius", this.wanderRadius);
        compound.method_10569("Stable", this.lastAddDoorTimestamp);
        compound.method_10569("Tick", this.tickCounter);
        compound.method_10569("MTick", this.noBreedTicks);
        compound.method_10569("CX", this.center.method_10263());
        compound.method_10569("CY", this.center.method_10264());
        compound.method_10569("CZ", this.center.method_10260());
        compound.method_10569("ACX", this.centerHelper.method_10263());
        compound.method_10569("ACY", this.centerHelper.method_10264());
        compound.method_10569("ACZ", this.centerHelper.method_10260());
        class_2499 hiveMembers = new class_2499();
        for (UUID uUID : this.myrmexList) {
            class_2487 class_24872 = new class_2487();
            class_24872.method_25927("MyrmexUUID", uUID);
            hiveMembers.add((Object)class_24872);
        }
        compound.method_10566("HiveMembers", (class_2520)hiveMembers);
        class_2499 foodRoomList = new class_2499();
        for (class_2338 class_23382 : this.foodRooms) {
            class_2487 class_24873 = new class_2487();
            class_24873.method_10569("X", class_23382.method_10263());
            class_24873.method_10569("Y", class_23382.method_10264());
            class_24873.method_10569("Z", class_23382.method_10260());
            foodRoomList.add((Object)class_24873);
        }
        compound.method_10566("FoodRooms", (class_2520)foodRoomList);
        class_2499 class_24992 = new class_2499();
        for (class_2338 class_23383 : this.babyRooms) {
            class_2487 class_24874 = new class_2487();
            class_24874.method_10569("X", class_23383.method_10263());
            class_24874.method_10569("Y", class_23383.method_10264());
            class_24874.method_10569("Z", class_23383.method_10260());
            class_24992.add((Object)class_24874);
        }
        compound.method_10566("BabyRooms", (class_2520)class_24992);
        class_2499 class_24993 = new class_2499();
        for (class_2338 class_23384 : this.miscRooms) {
            class_2487 class_24875 = new class_2487();
            class_24875.method_10569("X", class_23384.method_10263());
            class_24875.method_10569("Y", class_23384.method_10264());
            class_24875.method_10569("Z", class_23384.method_10260());
            class_24993.add((Object)class_24875);
        }
        compound.method_10566("MiscRooms", (class_2520)class_24993);
        class_2499 class_24994 = new class_2499();
        for (Map.Entry<class_2338, class_2350> entry : this.entrances.entrySet()) {
            class_2487 class_24876 = new class_2487();
            class_24876.method_10569("X", entry.getKey().method_10263());
            class_24876.method_10569("Y", entry.getKey().method_10264());
            class_24876.method_10569("Z", entry.getKey().method_10260());
            class_24876.method_10569("Facing", entry.getValue().method_10161());
            class_24994.add((Object)class_24876);
        }
        compound.method_10566("Entrances", (class_2520)class_24994);
        class_2499 class_24995 = new class_2499();
        for (Map.Entry<class_2338, class_2350> entry : this.entranceBottoms.entrySet()) {
            class_2487 CompoundNBT = new class_2487();
            CompoundNBT.method_10569("X", entry.getKey().method_10263());
            CompoundNBT.method_10569("Y", entry.getKey().method_10264());
            CompoundNBT.method_10569("Z", entry.getKey().method_10260());
            CompoundNBT.method_10569("Facing", entry.getValue().method_10161());
            class_24995.add((Object)CompoundNBT);
        }
        compound.method_10566("EntranceBottoms", (class_2520)class_24995);
        compound.method_25927("HiveUUID", this.hiveUUID);
        class_2499 class_24996 = new class_2499();
        for (UUID s : this.playerReputation.keySet()) {
            class_2487 CompoundNBT1 = new class_2487();
            try {
                CompoundNBT1.method_25927("UUID", s);
                CompoundNBT1.method_10569("S", this.playerReputation.get(s).intValue());
                class_24996.add((Object)CompoundNBT1);
            }
            catch (RuntimeException runtimeException) {}
        }
        compound.method_10566("Players", (class_2520)class_24996);
    }

    public void addRoom(class_2338 center, WorldGenMyrmexHive.RoomType roomType) {
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD && !this.foodRooms.contains(center)) {
            this.foodRooms.add(center);
        } else if (roomType == WorldGenMyrmexHive.RoomType.NURSERY && !this.babyRooms.contains(center)) {
            this.babyRooms.add(center);
        } else if (!this.miscRooms.contains(center) && !this.miscRooms.contains(center)) {
            this.miscRooms.add(center);
        }
        this.allRooms.add(center);
    }

    public void addRoomWithMessage(class_1657 player, class_2338 center, WorldGenMyrmexHive.RoomType roomType) {
        ArrayList<class_2338> allCurrentRooms = new ArrayList<class_2338>(this.getAllRooms());
        allCurrentRooms.addAll(this.getEntrances().keySet());
        allCurrentRooms.addAll(this.getEntranceBottoms().keySet());
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD) {
            if (!this.foodRooms.contains(center) && !allCurrentRooms.contains(center)) {
                this.foodRooms.add(center);
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.added_food_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.dupe_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
            }
        } else if (roomType == WorldGenMyrmexHive.RoomType.NURSERY) {
            if (!this.babyRooms.contains(center) && !allCurrentRooms.contains(center)) {
                this.babyRooms.add(center);
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.added_nursery_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.dupe_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
            }
        } else if (!this.miscRooms.contains(center) && !allCurrentRooms.contains(center)) {
            this.miscRooms.add(center);
            player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.added_misc_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.dupe_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
        }
    }

    public void addEnteranceWithMessage(class_1657 player, boolean bottom, class_2338 center, class_2350 facing) {
        ArrayList<class_2338> allCurrentRooms = new ArrayList<class_2338>(this.getAllRooms());
        allCurrentRooms.addAll(this.getEntrances().keySet());
        allCurrentRooms.addAll(this.getEntranceBottoms().keySet());
        if (bottom) {
            if (allCurrentRooms.contains(center)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.dupe_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
            } else {
                this.getEntranceBottoms().put(center, facing);
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.added_enterance_bottom", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
            }
        } else if (allCurrentRooms.contains(center)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.dupe_room", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
        } else {
            this.getEntrances().put(center, facing);
            player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.added_enterance_surface", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), false);
        }
    }

    public List<class_2338> getRooms(WorldGenMyrmexHive.RoomType roomType) {
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD) {
            return this.foodRooms;
        }
        if (roomType == WorldGenMyrmexHive.RoomType.NURSERY) {
            return this.babyRooms;
        }
        return this.miscRooms;
    }

    public List<class_2338> getAllRooms() {
        this.allRooms.clear();
        this.allRooms.add(this.center);
        this.allRooms.addAll(this.foodRooms);
        this.allRooms.addAll(this.babyRooms);
        this.allRooms.addAll(this.miscRooms);
        return this.allRooms;
    }

    public class_2338 getRandomRoom(class_5819 random, class_2338 returnPos) {
        List<class_2338> rooms = this.getAllRooms();
        return rooms.isEmpty() ? returnPos : rooms.get(random.method_43048(Math.max(rooms.size() - 1, 1)));
    }

    public class_2338 getRandomRoom(WorldGenMyrmexHive.RoomType roomType, class_5819 random, class_2338 returnPos) {
        List<class_2338> rooms = this.getRooms(roomType);
        return rooms.isEmpty() ? returnPos : rooms.get(random.method_43048(Math.max(rooms.size() - 1, 1)));
    }

    public class_2338 getClosestEntranceToEntity(class_1297 entity, class_5819 random, boolean randomize) {
        Map.Entry<class_2338, class_2350> closest = this.getClosestEntrance(entity);
        if (closest != null) {
            if (randomize) {
                class_2338 pos = closest.getKey().method_10079(closest.getValue(), random.method_43048(7) + 7).method_10086(4);
                return pos.method_10069(10 - random.method_43048(20), 0, 10 - random.method_43048(20));
            }
            return closest.getKey().method_10079(closest.getValue(), 3);
        }
        return entity.method_24515();
    }

    public class_2338 getClosestEntranceBottomToEntity(class_1297 entity, class_5819 random) {
        Map.Entry<class_2338, class_2350> closest = null;
        for (Map.Entry<class_2338, class_2350> entry : this.entranceBottoms.entrySet()) {
            class_2382 vec = new class_2382(entity.method_31477(), entity.method_31478(), entity.method_31479());
            if (closest != null && !(((class_2338)closest.getKey()).method_10262(vec) > entry.getKey().method_10262(vec))) continue;
            closest = entry;
        }
        return closest != null ? (class_2338)closest.getKey() : entity.method_24515();
    }

    public class_1657 getOwner(class_1937 world) {
        if (this.hasOwner) {
            return world.method_18470(this.ownerUUID);
        }
        return null;
    }

    public Map<class_2338, class_2350> getEntrances() {
        return this.entrances;
    }

    public Map<class_2338, class_2350> getEntranceBottoms() {
        return this.entranceBottoms;
    }

    private Map.Entry<class_2338, class_2350> getClosestEntrance(class_1297 entity) {
        Map.Entry<class_2338, class_2350> closest = null;
        for (Map.Entry<class_2338, class_2350> entry : this.entrances.entrySet()) {
            class_2382 vec = new class_2382(entity.method_31477(), entity.method_31478(), entity.method_31479());
            if (closest != null && !(((class_2338)closest.getKey()).method_10262(vec) > entry.getKey().method_10262(vec))) continue;
            closest = entry;
        }
        return closest;
    }

    public void setDefaultPlayerReputation(int defaultReputation) {
        for (UUID s : this.playerReputation.keySet()) {
            this.modifyPlayerReputation(s, defaultReputation);
        }
    }

    public boolean repopulate() {
        int roomCount = this.getAllRooms().size();
        return this.numMyrmex < Math.min((Integer)IafCommonConfig.INSTANCE.myrmex.colonySize.getValue(), roomCount * 9) && this.reproduces;
    }

    public void addMyrmex(EntityMyrmexBase myrmex) {
        if (!this.myrmexList.contains(myrmex.method_5667())) {
            this.myrmexList.add(myrmex.method_5667());
        }
    }

    public void removeRoom(class_2338 pos) {
        this.foodRooms.remove(pos);
        this.miscRooms.remove(pos);
        this.babyRooms.remove(pos);
        this.allRooms.remove(pos);
        this.getEntrances().remove(pos);
        this.getEntranceBottoms().remove(pos);
    }

    public String toString() {
        return "MyrmexHive(x=" + this.center.method_10263() + ",y=" + this.center.method_10264() + ",z=" + this.center.method_10260() + "), population=" + this.getNumMyrmex() + "\nUUID: " + this.hiveUUID;
    }

    public boolean equals(MyrmexHive hive) {
        return this.hiveUUID.equals(hive.hiveUUID);
    }

    static class HiveAggressor {
        public final class_1309 agressor;
        public final int agressionLevel;
        public int agressionTime;

        HiveAggressor(class_1309 agressorIn, int agressionTimeIn, int agressionLevel) {
            this.agressor = agressorIn;
            this.agressionTime = agressionTimeIn;
            this.agressionLevel = agressionLevel;
        }
    }
}

