/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityGhost;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.EntityHippogryph;
import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpent;
import com.iafenvoy.iceandfire.entity.EntityStymphalianBird;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1427;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_5532;
import net.minecraft.class_6862;

public class DragonUtils {
    public static class_2338 getBlockInViewEscort(EntityDragonBase dragon) {
        class_2338 escortPos = dragon.getEscortPosition();
        class_2338 ground = dragon.method_37908().method_8598(class_2902.class_2903.field_13203, escortPos);
        int distFromGround = escortPos.method_10264() - ground.method_10264();
        for (int i = 0; i < 10; ++i) {
            class_2338 pos = new class_2338(escortPos.method_10263() + dragon.method_6051().method_43048(((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue()) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() / 2, distFromGround > 16 ? escortPos.method_10264() : escortPos.method_10264() + 8 + dragon.method_6051().method_43048(16), escortPos.method_10260() + dragon.method_6051().method_43048(((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue()) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() / 2);
            if (!(dragon.getDistanceSquared(class_243.method_24953((class_2382)pos)) > 6.0f) || dragon.isTargetBlocked(class_243.method_24953((class_2382)pos))) continue;
            return pos;
        }
        return null;
    }

    public static class_2338 getWaterBlockInViewEscort(EntityDragonBase dragon) {
        class_2338 inWaterEscortPos = dragon.getEscortPosition();
        if (Math.abs(dragon.method_23317() - (double)inWaterEscortPos.method_10263()) < dragon.method_5829().method_17939() && Math.abs(dragon.method_23321() - (double)inWaterEscortPos.method_10260()) < dragon.method_5829().method_17941()) {
            return dragon.method_24515();
        }
        if ((double)inWaterEscortPos.method_10264() - dragon.method_23318() > (double)(8 + dragon.getYNavSize()) && !dragon.method_37908().method_8316(inWaterEscortPos.method_10074()).method_15767(class_3486.field_15517)) {
            dragon.setHovering(true);
        }
        return inWaterEscortPos;
    }

    public static class_2338 getBlockInView(EntityDragonBase dragon) {
        class_2338 pos;
        float radius = 12.0f * (0.7f * dragon.getRenderSize() / 3.0f);
        float neg = dragon.method_6051().method_43056() ? 1.0f : -1.0f;
        float renderYawOffset = dragon.field_6283;
        if (dragon.hasHomePosition && dragon.homePos != null) {
            class_2338 dragonPos = dragon.method_24515();
            class_2338 ground = dragon.method_37908().method_8598(class_2902.class_2903.field_13203, dragonPos);
            int distFromGround = (int)dragon.method_23318() - ground.method_10264();
            for (int i = 0; i < 10; ++i) {
                class_2338 homePos = dragon.homePos.getPosition();
                class_2338 pos2 = new class_2338(homePos.method_10263() + dragon.method_6051().method_43048((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() * 2) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue(), distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), dragon.method_23318() + (double)dragon.method_6051().method_43048(16) - 8.0) : (int)dragon.method_23318() + dragon.method_6051().method_43048(16) + 1, homePos.method_10260() + dragon.method_6051().method_43048((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() * 2) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue());
                if (!(dragon.getDistanceSquared(class_243.method_24953((class_2382)pos2)) > 6.0f) || dragon.isTargetBlocked(class_243.method_24953((class_2382)pos2))) continue;
                return pos2;
            }
        }
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + dragon.method_6051().method_43057() * neg;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = class_2338.method_49637((double)(dragon.method_23317() + extraX), (double)0.0, (double)(dragon.method_23321() + extraZ));
        class_2338 ground = dragon.method_37908().method_8598(class_2902.class_2903.field_13203, radialPos);
        int distFromGround = (int)dragon.method_23318() - ground.method_10264();
        class_2338 newPos = radialPos.method_10086(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), dragon.method_23318() + (double)dragon.method_6051().method_43048(16) - 8.0) : (int)dragon.method_23318() + dragon.method_6051().method_43048(16) + 1);
        class_2338 class_23382 = pos = dragon.doesWantToLand() ? ground : newPos;
        if (dragon.getDistanceSquared(class_243.method_24953((class_2382)newPos)) > 6.0f && !dragon.isTargetBlocked(class_243.method_24953((class_2382)newPos))) {
            return pos;
        }
        return null;
    }

    public static class_2338 getWaterBlockInView(EntityDragonBase dragon) {
        class_2338 surface;
        float radius = 0.75f * (0.7f * dragon.getRenderSize() / 3.0f) * -7.0f - (float)dragon.method_6051().method_43048(dragon.getDragonStage() * 6);
        float neg = dragon.method_6051().method_43056() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * dragon.field_6283 + 3.15f + dragon.method_6051().method_43057() * neg;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = class_2338.method_49637((double)(dragon.method_23317() + extraX), (double)0.0, (double)(dragon.method_23321() + extraZ));
        class_2338 ground = dragon.method_37908().method_8598(class_2902.class_2903.field_13203, radialPos);
        int distFromGround = (int)dragon.method_23318() - ground.method_10264();
        class_2338 newPos = radialPos.method_10086(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), dragon.method_23318() + (double)dragon.method_6051().method_43048(16) - 8.0) : (int)dragon.method_23318() + dragon.method_6051().method_43048(16) + 1);
        class_2338 pos = dragon.doesWantToLand() ? ground : newPos;
        class_2338 class_23382 = surface = dragon.method_37908().method_8316(newPos.method_10087(2)).method_15767(class_3486.field_15517) ? newPos.method_10087(dragon.method_6051().method_43048(10) + 1) : newPos;
        if (dragon.getDistanceSquared(class_243.method_24953((class_2382)surface)) > 6.0f && dragon.method_37908().method_8316(surface).method_15767(class_3486.field_15517)) {
            return surface;
        }
        return null;
    }

    public static class_1309 riderLookingAtEntity(class_1309 dragon, class_1309 rider, double dist) {
        class_243 Vector3d = rider.method_5836(1.0f);
        class_243 Vector3d1 = rider.method_5828(1.0f);
        class_243 Vector3d2 = Vector3d.method_1031(Vector3d1.field_1352 * dist, Vector3d1.field_1351 * dist, Vector3d1.field_1350 * dist);
        class_1297 pointedEntity = null;
        List list = rider.method_37908().method_8333((class_1297)rider, rider.method_5829().method_1012(Vector3d1.field_1352 * dist, Vector3d1.field_1351 * dist, Vector3d1.field_1350 * dist).method_1009(1.0, 1.0, 1.0), (Predicate)((com.google.common.base.Predicate)entity -> {
            if (DragonUtils.onSameTeam((class_1297)dragon, entity)) {
                return false;
            }
            return entity != null && entity.method_5863() && entity instanceof class_1309 && !entity.method_5779((class_1297)dragon) && !entity.method_5722((class_1297)dragon) && (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead());
        }));
        double d2 = dist;
        for (class_1297 entity1 : list) {
            class_238 axisalignedbb = entity1.method_5829().method_1014((double)entity1.method_5871() + 2.0);
            class_243 raytraceresult = axisalignedbb.method_992(Vector3d, Vector3d2).orElse(class_243.field_1353);
            if (axisalignedbb.method_1006(Vector3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                d2 = 0.0;
                continue;
            }
            double d3 = Vector3d.method_1022(raytraceresult);
            if (!(d3 < d2) && d2 != 0.0) continue;
            if (entity1.method_5668() == rider.method_5668()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        return (class_1309)pointedEntity;
    }

    public static class_2338 getBlockInViewHippogryph(EntityHippogryph hippo, float yawAddition) {
        int distFromGround;
        class_2338 ground;
        float radius = -12.599999f - (float)hippo.method_6051().method_43048(48);
        float neg = hippo.method_6051().method_43056() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * (hippo.field_6283 + yawAddition) + 3.15f + hippo.method_6051().method_43057() * neg;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        if (hippo.hasHomePosition && hippo.homePos != null) {
            class_2338 dragonPos = hippo.method_24515();
            ground = hippo.method_37908().method_8598(class_2902.class_2903.field_13203, dragonPos);
            distFromGround = (int)hippo.method_23318() - ground.method_10264();
            for (int i = 0; i < 10; ++i) {
                class_2338 pos = class_2338.method_49637((double)(hippo.homePos.method_10263() + hippo.method_6051().method_43048(((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue()) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()), (double)(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), hippo.method_23318() + (double)hippo.method_6051().method_43048(16) - 8.0) : (int)hippo.method_23318() + hippo.method_6051().method_43048(16) + 1), (double)(hippo.homePos.method_10260() + hippo.method_6051().method_43048((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() * 2) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()));
                if (!(hippo.getDistanceSquared(class_243.method_24953((class_2382)pos)) > 6.0f) || hippo.isTargetBlocked(class_243.method_24953((class_2382)pos))) continue;
                return pos;
            }
        }
        class_2338 radialPos = class_2338.method_49637((double)(hippo.method_23317() + extraX), (double)0.0, (double)(hippo.method_23321() + extraZ));
        ground = hippo.method_37908().method_8598(class_2902.class_2903.field_13203, radialPos);
        distFromGround = (int)hippo.method_23318() - ground.method_10264();
        class_2338 newPos = radialPos.method_10086(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), hippo.method_23318() + (double)hippo.method_6051().method_43048(16) - 8.0) : (int)hippo.method_23318() + hippo.method_6051().method_43048(16) + 1);
        if (!hippo.isTargetBlocked(class_243.method_24953((class_2382)newPos)) && hippo.getDistanceSquared(class_243.method_24953((class_2382)newPos)) > 6.0f) {
            return newPos;
        }
        return null;
    }

    public static class_2338 getBlockInViewStymphalian(EntityStymphalianBird bird) {
        float radius = -9.45f - (float)bird.method_6051().method_43048(24);
        float neg = bird.method_6051().method_43056() ? 1.0f : -1.0f;
        float renderYawOffset = bird.flock != null && !bird.flock.isLeader(bird) ? DragonUtils.getStymphalianFlockDirection(bird) : bird.field_6283;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + bird.method_6051().method_43057() * neg;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = DragonUtils.getStymphalianFearPos(bird, class_2338.method_49637((double)(bird.method_23317() + extraX), (double)0.0, (double)(bird.method_23321() + extraZ)));
        class_2338 ground = bird.method_37908().method_8598(class_2902.class_2903.field_13203, radialPos);
        int distFromGround = (int)bird.method_23318() - ground.method_10264();
        int flightHeight = Math.min((Integer)IafCommonConfig.INSTANCE.stymphalianBird.flightHeight.getValue(), ground.method_10264() + bird.method_6051().method_43048(16));
        class_2338 newPos = radialPos.method_10086(distFromGround > 16 ? flightHeight : (int)bird.method_23318() + bird.method_6051().method_43048(16) + 1);
        if (bird.getDistanceSquared(class_243.method_24953((class_2382)newPos)) > 6.0f && !bird.isTargetBlocked(class_243.method_24953((class_2382)newPos))) {
            return newPos;
        }
        return null;
    }

    private static class_2338 getStymphalianFearPos(EntityStymphalianBird bird, class_2338 fallback) {
        class_243 Vector3d;
        if (bird.getVictor() != null && bird.getVictor() instanceof class_1314 && (Vector3d = class_5532.method_31511((class_1314)((class_1314)bird.getVictor()), (int)16, (int)((Integer)IafCommonConfig.INSTANCE.stymphalianBird.flightHeight.getValue()), (class_243)new class_243(bird.getVictor().method_23317(), bird.getVictor().method_23318(), bird.getVictor().method_23321()))) != null) {
            class_2338 pos = class_2338.method_49638((class_2374)Vector3d);
            return new class_2338(pos.method_10263(), 0, pos.method_10260());
        }
        return fallback;
    }

    private static float getStymphalianFlockDirection(EntityStymphalianBird bird) {
        EntityStymphalianBird leader = bird.flock.getLeader();
        if (bird.method_5858((class_1297)leader) > 2.0) {
            double d0 = leader.method_23317() - bird.method_23317();
            double d2 = leader.method_23321() - bird.method_23321();
            float f = (float)(class_3532.method_15349((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float degrees = class_3532.method_15393((float)(f - bird.method_36454()));
            return bird.method_36454() + degrees;
        }
        return leader.field_6283;
    }

    public static class_2338 getBlockInTargetsViewCockatrice(EntityCockatrice cockatrice, class_1309 target) {
        float radius = 10 + cockatrice.method_6051().method_43048(10);
        float angle = (float)Math.PI / 180 * target.field_6241;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = class_2338.method_49637((double)(target.method_23317() + extraX), (double)0.0, (double)(target.method_23321() + extraZ));
        class_2338 ground = target.method_37908().method_8598(class_2902.class_2903.field_13203, radialPos);
        if (cockatrice.method_5707(class_243.method_24953((class_2382)ground)) > 30.0 && !cockatrice.isTargetBlocked(class_243.method_24953((class_2382)ground))) {
            return ground;
        }
        return target.method_24515();
    }

    public static class_2338 getBlockInTargetsViewGhost(EntityGhost ghost, class_1309 target) {
        float radius = 4 + ghost.method_6051().method_43048(5);
        float angle = (float)Math.PI / 180 * (target.field_6241 + 90.0f + (float)ghost.method_6051().method_43048(180));
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        if (ghost.method_5707(class_243.method_24953((class_2382)class_2338.method_49637((double)(target.method_23317() + extraX), (double)target.method_23318(), (double)(target.method_23321() + extraZ)))) > 30.0) {
            return class_2338.method_49637((double)(target.method_23317() + extraX), (double)target.method_23318(), (double)(target.method_23321() + extraZ));
        }
        return ghost.method_24515();
    }

    public static class_2338 getBlockInTargetsViewGorgon(EntityGorgon cockatrice, class_1309 target) {
        float radius = 6.0f;
        float angle = (float)Math.PI / 180 * target.field_6241;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = class_2338.method_49637((double)(target.method_23317() + extraX), (double)target.method_23318(), (double)(target.method_23321() + extraZ));
        if (cockatrice.method_5707(class_243.method_24953((class_2382)radialPos)) < 300.0 && !cockatrice.isTargetBlocked(class_243.method_24953((class_2382)radialPos).method_1031(0.0, 0.75, 0.0))) {
            return radialPos;
        }
        return target.method_24515();
    }

    public static class_2338 getBlockInTargetsViewSeaSerpent(EntitySeaSerpent serpent, class_1309 target) {
        float radius = 10.0f * serpent.getSeaSerpentScale() + (float)serpent.method_6051().method_43048(10);
        float angle = (float)Math.PI / 180 * target.field_6241;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = class_2338.method_49637((double)(target.method_23317() + extraX), (double)0.0, (double)(target.method_23321() + extraZ));
        class_2338 ground = target.method_37908().method_8598(class_2902.class_2903.field_13203, radialPos);
        if (serpent.method_5707(class_243.method_24953((class_2382)ground)) > 30.0) {
            return ground;
        }
        return target.method_24515();
    }

    public static boolean canTameDragonAttack(class_1321 dragon, class_1297 entity) {
        if (DragonUtils.isVillager(entity)) {
            return false;
        }
        if (entity instanceof class_3988 || entity instanceof class_1427 || entity instanceof class_1657) {
            return false;
        }
        if (entity instanceof class_1321) {
            class_1321 tameable = (class_1321)entity;
            return !tameable.method_6181();
        }
        return true;
    }

    public static boolean isVillager(class_1297 entity) {
        return false;
    }

    public static boolean isAnimaniaMob(class_1297 entity) {
        return false;
    }

    public static boolean isDragonTargetable(class_1297 entity, class_6862<class_1299<?>> tag) {
        return entity.method_5864().method_20210(tag);
    }

    public static String getDimensionName(class_1937 world) {
        return world.method_27983().method_29177().toString();
    }

    public static boolean isInHomeDimension(EntityDragonBase dragonBase) {
        return dragonBase.getHomeDimensionName() == null || DragonUtils.getDimensionName(dragonBase.method_37908()).equals(dragonBase.getHomeDimensionName());
    }

    public static boolean canDragonBreak(class_2680 state, class_1297 entity) {
        if (!entity.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            return false;
        }
        class_2248 block = state.method_26204();
        return block.method_9520() < 1200.0f && !state.method_26164(IafBlockTags.DRAGON_BLOCK_BREAK_BLACKLIST);
    }

    public static boolean hasSameOwner(class_1321 cockatrice, class_1297 entity) {
        if (entity instanceof class_1321) {
            class_1321 tameable = (class_1321)entity;
            return tameable.method_6139() != null && cockatrice.method_6139() != null && tameable.method_6139().equals(cockatrice.method_6139());
        }
        return false;
    }

    public static boolean isAlive(class_1309 entity) {
        IDeadMob deadMob;
        EntityDragonBase dragon;
        if (entity instanceof EntityDragonBase && (dragon = (EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return (!(entity instanceof IDeadMob) || !(deadMob = (IDeadMob)entity).isMobDead()) && !EntityGorgon.isStoneMob(entity);
    }

    public static boolean canGrief(EntityDragonBase dragon) {
        if (dragon.method_6181() && !((Boolean)IafCommonConfig.INSTANCE.dragon.tamedGriefing.getValue()).booleanValue()) {
            return false;
        }
        return (Boolean)IafCommonConfig.INSTANCE.dragon.griefing.getValue();
    }

    public static boolean canHostilesTarget(class_1297 entity) {
        class_1309 livingEntity;
        EntityDragonBase dragonBase;
        if (entity instanceof class_1657 && (entity.method_37908().method_8407() == class_1267.field_5801 || ((class_1657)entity).method_7337())) {
            return false;
        }
        if (entity instanceof EntityDragonBase && (dragonBase = (EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return entity instanceof class_1309 && DragonUtils.isAlive(livingEntity = (class_1309)entity);
    }

    public static boolean onSameTeam(class_1297 entity1, class_1297 entity2) {
        class_1321 tameable;
        EntityMultipartPart mutlipartPart;
        class_1297 multipart;
        class_1321 tameable2;
        class_1309 owner1 = null;
        class_1309 owner2 = null;
        boolean def = entity1.method_5722(entity2);
        if (entity1 instanceof class_1321) {
            tameable2 = (class_1321)entity1;
            owner1 = tameable2.method_35057();
        }
        if (entity2 instanceof class_1321) {
            tameable2 = (class_1321)entity2;
            owner2 = tameable2.method_35057();
        }
        if (entity1 instanceof EntityMultipartPart && (multipart = (mutlipartPart = (EntityMultipartPart)entity1).getParent()) instanceof class_1321) {
            tameable = (class_1321)multipart;
            owner1 = tameable.method_35057();
        }
        if (entity2 instanceof EntityMultipartPart && (multipart = (mutlipartPart = (EntityMultipartPart)entity2).getParent()) instanceof class_1321) {
            tameable = (class_1321)multipart;
            owner2 = tameable.method_35057();
        }
        if (owner1 != null && owner2 != null) {
            return owner1.method_5779((class_1297)owner2);
        }
        return def;
    }

    public static boolean isDreadBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == IafBlocks.DREAD_STONE || block == IafBlocks.DREAD_STONE_BRICKS || block == IafBlocks.DREAD_STONE_BRICKS_CHISELED || block == IafBlocks.DREAD_STONE_BRICKS_CRACKED || block == IafBlocks.DREAD_STONE_BRICKS_MOSSY || block == IafBlocks.DREAD_STONE_TILE || block == IafBlocks.DREAD_STONE_FACE || block == IafBlocks.DREAD_TORCH || block == IafBlocks.DREAD_STONE_BRICKS_STAIRS || block == IafBlocks.DREAD_STONE_BRICKS_SLAB || block == IafBlocks.DREADWOOD_LOG || block == IafBlocks.DREADWOOD_PLANKS || block == IafBlocks.DREADWOOD_PLANKS_LOCK || block == IafBlocks.DREAD_PORTAL || block == IafBlocks.DREAD_SPAWNER;
    }
}

