/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafPlacedFeatures;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import com.iafenvoy.iceandfire.world.IafWorldData;
import com.iafenvoy.iceandfire.world.feature.SpawnDeathWorm;
import com.iafenvoy.iceandfire.world.feature.SpawnDragonSkeleton;
import com.iafenvoy.iceandfire.world.feature.SpawnHippocampus;
import com.iafenvoy.iceandfire.world.feature.SpawnSeaSerpent;
import com.iafenvoy.iceandfire.world.feature.SpawnStymphalianBird;
import com.iafenvoy.iceandfire.world.feature.SpawnWanderingCyclops;
import com.iafenvoy.iceandfire.world.gen.WorldGenCyclopsCave;
import com.iafenvoy.iceandfire.world.gen.WorldGenFireDragonCave;
import com.iafenvoy.iceandfire.world.gen.WorldGenFireDragonRoosts;
import com.iafenvoy.iceandfire.world.gen.WorldGenHydraCave;
import com.iafenvoy.iceandfire.world.gen.WorldGenIceDragonCave;
import com.iafenvoy.iceandfire.world.gen.WorldGenIceDragonRoosts;
import com.iafenvoy.iceandfire.world.gen.WorldGenLightningDragonCave;
import com.iafenvoy.iceandfire.world.gen.WorldGenLightningDragonRoosts;
import com.iafenvoy.iceandfire.world.gen.WorldGenMyrmexHive;
import com.iafenvoy.iceandfire.world.gen.WorldGenPixieVillage;
import com.iafenvoy.iceandfire.world.gen.WorldGenSirenIsland;
import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public final class IafFeatures {
    public static final class_3031<class_3111> FIRE_DRAGON_ROOST = IafFeatures.register("fire_dragon_roost", new WorldGenFireDragonRoosts((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> ICE_DRAGON_ROOST = IafFeatures.register("ice_dragon_roost", new WorldGenIceDragonRoosts((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> LIGHTNING_DRAGON_ROOST = IafFeatures.register("lightning_dragon_roost", new WorldGenLightningDragonRoosts((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> FIRE_DRAGON_CAVE = IafFeatures.register("fire_dragon_cave", new WorldGenFireDragonCave((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> ICE_DRAGON_CAVE = IafFeatures.register("ice_dragon_cave", new WorldGenIceDragonCave((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> LIGHTNING_DRAGON_CAVE = IafFeatures.register("lightning_dragon_cave", new WorldGenLightningDragonCave((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> CYCLOPS_CAVE = IafFeatures.register("cyclops_cave", new WorldGenCyclopsCave((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> PIXIE_VILLAGE = IafFeatures.register("pixie_village", new WorldGenPixieVillage((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SIREN_ISLAND = IafFeatures.register("siren_island", new WorldGenSirenIsland((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> HYDRA_CAVE = IafFeatures.register("hydra_cave", new WorldGenHydraCave((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> MYRMEX_HIVE_DESERT = IafFeatures.register("myrmex_hive_desert", new WorldGenMyrmexHive(false, false, (Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> MYRMEX_HIVE_JUNGLE = IafFeatures.register("myrmex_hive_jungle", new WorldGenMyrmexHive(false, true, (Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_DEATH_WORM = IafFeatures.register("spawn_death_worm", new SpawnDeathWorm((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_DRAGON_SKELETON_L = IafFeatures.register("spawn_dragon_skeleton_lightning", new SpawnDragonSkeleton(IafEntities.LIGHTNING_DRAGON, (Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_DRAGON_SKELETON_F = IafFeatures.register("spawn_dragon_skeleton_fire", new SpawnDragonSkeleton(IafEntities.FIRE_DRAGON, (Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_DRAGON_SKELETON_I = IafFeatures.register("spawn_dragon_skeleton_ice", new SpawnDragonSkeleton(IafEntities.ICE_DRAGON, (Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_HIPPOCAMPUS = IafFeatures.register("spawn_hippocampus", new SpawnHippocampus((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_SEA_SERPENT = IafFeatures.register("spawn_sea_serpent", new SpawnSeaSerpent((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_STYMPHALIAN_BIRD = IafFeatures.register("spawn_stymphalian_bird", new SpawnStymphalianBird((Codec<class_3111>)class_3111.field_24893));
    public static final class_3031<class_3111> SPAWN_WANDERING_CYCLOPS = IafFeatures.register("spawn_wandering_cyclops", new SpawnWanderingCyclops((Codec<class_3111>)class_3111.field_24893));

    private static <F extends class_3031<? extends class_3037>> F register(String name, F feature) {
        return (F)((class_3031)class_2378.method_10230((class_2378)class_7923.field_41144, (class_2960)new class_2960("iceandfire", name), feature));
    }

    public static void init() {
        IafFeatures.addFeatures();
    }

    public static boolean isFarEnoughFromSpawn(class_1936 level, class_2338 position) {
        class_5217 spawnPoint = level.method_8401();
        class_2338 spawnRelative = new class_2338(spawnPoint.method_215(), position.method_10264(), spawnPoint.method_144());
        return !spawnRelative.method_19771((class_2382)position, (double)((Double)IafCommonConfig.INSTANCE.worldGen.dangerousDistanceLimit.getValue()).floatValue());
    }

    public static boolean isFarEnoughFromDangerousGen(class_5425 level, class_2338 position, String id) {
        return IafFeatures.isFarEnoughFromDangerousGen(level, position, id, IafWorldData.FeatureType.SURFACE);
    }

    public static boolean isFarEnoughFromDangerousGen(class_5425 level, class_2338 position, String id, IafWorldData.FeatureType type) {
        IafWorldData data = IafWorldData.get((class_1937)level.method_8410());
        return data.check(type, position, id);
    }

    public static void addFeatures() {
        IafFeatures.addFeatureToBiome(IafBiomeTags.FIRE, IafPlacedFeatures.PLACED_FIRE_LILY, class_2893.class_2895.field_13178);
        IafFeatures.addFeatureToBiome(IafBiomeTags.ICE, IafPlacedFeatures.PLACED_FROST_LILY, class_2893.class_2895.field_13178);
        IafFeatures.addFeatureToBiome(IafBiomeTags.LIGHTENING, IafPlacedFeatures.PLACED_LIGHTNING_LILY, class_2893.class_2895.field_13178);
        IafFeatures.addFeatureToBiome(IafBiomeTags.FIRE, IafPlacedFeatures.PLACED_FIRE_DRAGON_ROOST, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.ICE, IafPlacedFeatures.PLACED_ICE_DRAGON_ROOST, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.LIGHTENING, IafPlacedFeatures.PLACED_LIGHTNING_DRAGON_ROOST, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.FIRE, IafPlacedFeatures.PLACED_FIRE_DRAGON_CAVE, class_2893.class_2895.field_13172);
        IafFeatures.addFeatureToBiome(IafBiomeTags.ICE, IafPlacedFeatures.PLACED_ICE_DRAGON_CAVE, class_2893.class_2895.field_13172);
        IafFeatures.addFeatureToBiome(IafBiomeTags.LIGHTENING, IafPlacedFeatures.PLACED_LIGHTNING_DRAGON_CAVE, class_2893.class_2895.field_13172);
        IafFeatures.addFeatureToBiome(IafBiomeTags.FIRE, IafPlacedFeatures.PLACED_SPAWN_DRAGON_SKELETON_F, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.ICE, IafPlacedFeatures.PLACED_SPAWN_DRAGON_SKELETON_I, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.LIGHTENING, IafPlacedFeatures.PLACED_SPAWN_DRAGON_SKELETON_L, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.SILVER_ORE, IafPlacedFeatures.PLACED_SILVER_ORE, class_2893.class_2895.field_13176);
        IafFeatures.addFeatureToBiome(IafBiomeTags.SAPPHIRE_ORE, IafPlacedFeatures.PLACED_SAPPHIRE_ORE, class_2893.class_2895.field_13176);
        IafFeatures.addFeatureToBiome(IafBiomeTags.CYCLOPS_CAVE, IafPlacedFeatures.PLACED_CYCLOPS_CAVE, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.PIXIE_VILLAGE, IafPlacedFeatures.PLACED_PIXIE_VILLAGE, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.HYDRA_CAVE, IafPlacedFeatures.PLACED_HYDRA_CAVE, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.MYRMEX_HIVE_DESERT, IafPlacedFeatures.PLACED_MYRMEX_HIVE_DESERT, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.MYRMEX_HIVE_JUNGLE, IafPlacedFeatures.PLACED_MYRMEX_HIVE_JUNGLE, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.SIREN_ISLAND, IafPlacedFeatures.PLACED_SIREN_ISLAND, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.DEATHWORM, IafPlacedFeatures.PLACED_SPAWN_DEATH_WORM, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.WANDERING_CYCLOPS, IafPlacedFeatures.PLACED_SPAWN_WANDERING_CYCLOPS, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.HIPPOCAMPUS, IafPlacedFeatures.PLACED_SPAWN_HIPPOCAMPUS, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.SEA_SERPENT, IafPlacedFeatures.PLACED_SPAWN_SEA_SERPENT, class_2893.class_2895.field_13173);
        IafFeatures.addFeatureToBiome(IafBiomeTags.STYMPHALIAN_BIRD, IafPlacedFeatures.PLACED_SPAWN_STYMPHALIAN_BIRD, class_2893.class_2895.field_13173);
    }

    private static void addFeatureToBiome(class_6862<class_1959> biomeTag, class_5321<class_6796> featureResource, class_2893.class_2895 step) {
        BiomeModifications.addFeature(context -> context.hasTag(biomeTag), (class_2893.class_2895)step, featureResource);
    }
}

