/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonSkull;
import com.iafenvoy.iceandfire.registry.IafRenderers;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class RenderDragonSkull
extends class_897<EntityDragonSkull> {
    public static final Map<DragonType, TabulaModel> MODELS = new HashMap<DragonType, TabulaModel>();
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public final float[][] growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};

    public RenderDragonSkull(class_5617.class_5618 context) {
        super(context);
    }

    private static void setRotationAngles(BasicModelPart cube, float rotX) {
        cube.rotateAngleX = rotX;
        cube.rotateAngleY = 0.0f;
        cube.rotateAngleZ = 0.0f;
    }

    public void render(EntityDragonSkull entity, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        TabulaModel model = MODELS.get(DragonType.getTypeById(entity.getDragonType()));
        class_4588 ivertexbuilder = bufferIn.getBuffer(class_1921.method_23580((class_2960)this.getTexture(entity)));
        matrixStackIn.method_22903();
        matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        matrixStackIn.method_22907(class_7833.field_40715.rotationDegrees(-180.0f - entity.method_36454()));
        matrixStackIn.method_22905(1.0f, 1.0f, 1.0f);
        float size = this.getRenderSize(entity) / 3.0f;
        matrixStackIn.method_22905(size, size, size);
        matrixStackIn.method_46416(0.0f, entity.isOnWall() ? -0.24f : -0.12f, entity.isOnWall() ? 0.4f : 0.5f);
        model.resetToDefaultPose();
        RenderDragonSkull.setRotationAngles((BasicModelPart)model.getCube("Head"), entity.isOnWall() ? (float)Math.toRadians(50.0) : 0.0f);
        model.getCube("Head").render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.method_22909();
    }

    public class_2960 getTexture(EntityDragonSkull entity) {
        return DragonType.getTypeById(entity.getDragonType()).getSkeletonTexture(entity.getDragonStage());
    }

    public float getRenderSize(EntityDragonSkull skull) {
        float step = (this.growth_stages[skull.getDragonStage() - 1][1] - this.growth_stages[skull.getDragonStage() - 1][0]) / 25.0f;
        if (skull.getDragonAge() > 125) {
            return this.growth_stages[skull.getDragonStage() - 1][0] + step * 25.0f;
        }
        return this.growth_stages[skull.getDragonStage() - 1][0] + step * (float)this.getAgeFactor(skull);
    }

    private int getAgeFactor(EntityDragonSkull skull) {
        return skull.getDragonStage() > 1 ? skull.getDragonAge() - 25 * (skull.getDragonStage() - 1) : skull.getDragonAge();
    }

    static {
        MODELS.put(DragonType.FIRE, IafRenderers.FIRE_DRAGON_BASE_MODEL);
        MODELS.put(DragonType.ICE, IafRenderers.ICE_DRAGON_BASE_MODEL);
        MODELS.put(DragonType.LIGHTNING, IafRenderers.LIGHTNING_DRAGON_BASE_MODEL);
    }
}

