/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.google.common.collect.Maps;
import com.iafenvoy.iceandfire.data.IafSkullType;
import com.iafenvoy.iceandfire.entity.EntityMobSkull;
import com.iafenvoy.iceandfire.render.model.ModelAmphithere;
import com.iafenvoy.iceandfire.render.model.ModelCockatrice;
import com.iafenvoy.iceandfire.render.model.ModelCyclops;
import com.iafenvoy.iceandfire.render.model.ModelHippogryph;
import com.iafenvoy.iceandfire.render.model.ModelHydraHead;
import com.iafenvoy.iceandfire.render.model.ModelStymphalianBird;
import com.iafenvoy.iceandfire.render.model.ModelTroll;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class RenderMobSkull
extends class_897<EntityMobSkull> {
    private static final Map<String, class_2960> SKULL_TEXTURE_CACHE = Maps.newHashMap();
    private final ModelHippogryph hippogryphModel = new ModelHippogryph();
    private final ModelCyclops cyclopsModel = new ModelCyclops();
    private final ModelCockatrice cockatriceModel = new ModelCockatrice();
    private final ModelStymphalianBird stymphalianBirdModel = new ModelStymphalianBird();
    private final ModelTroll trollModel = new ModelTroll();
    private final ModelAmphithere amphithereModel = new ModelAmphithere();
    private final ModelHydraHead hydraModel;
    private final TabulaModel seaSerpentModel;

    public RenderMobSkull(class_5617.class_5618 context, AdvancedEntityModel seaSerpentModel) {
        super(context);
        this.seaSerpentModel = (TabulaModel)seaSerpentModel;
        this.hydraModel = new ModelHydraHead(0);
    }

    private static void setRotationAngles(BasicModelPart cube, float rotX) {
        cube.rotateAngleX = rotX;
        cube.rotateAngleY = 0.0f;
        cube.rotateAngleZ = 0.0f;
    }

    public void render(EntityMobSkull entity, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        super.method_3936((class_1297)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.method_22903();
        matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        matrixStackIn.method_22907(class_7833.field_40715.rotationDegrees(180.0f - entity.method_36454()));
        float f = 0.0625f;
        float size = 1.0f;
        matrixStackIn.method_22905(size, size, size);
        matrixStackIn.method_46416(0.0f, entity.isOnWall() ? -0.24f : -0.12f, 0.5f);
        this.renderForEnum(entity.getSkullType(), entity.isOnWall(), matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.method_22909();
    }

    private void renderForEnum(IafSkullType skull, boolean onWall, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        class_4588 ivertexbuilder = bufferIn.getBuffer(class_1921.method_23580((class_2960)this.getSkullTexture(skull)));
        switch (skull) {
            case HIPPOGRYPH: {
                matrixStackIn.method_46416(0.0f, -0.0f, -0.2f);
                matrixStackIn.method_22905(1.2f, 1.2f, 1.2f);
                this.hippogryphModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.hippogryphModel.Head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-5.0));
                this.hippogryphModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case CYCLOPS: {
                matrixStackIn.method_46416(0.0f, 1.8f, -0.5f);
                matrixStackIn.method_22905(2.25f, 2.25f, 2.25f);
                this.cyclopsModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.cyclopsModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.cyclopsModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case COCKATRICE: {
                if (onWall) {
                    matrixStackIn.method_46416(0.0f, 0.0f, 0.35f);
                }
                this.cockatriceModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.cockatriceModel.head, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.cockatriceModel.head.render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case STYMPHALIAN: {
                if (!onWall) {
                    matrixStackIn.method_46416(0.0f, 0.0f, -0.35f);
                }
                this.stymphalianBirdModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.stymphalianBirdModel.HeadBase, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.stymphalianBirdModel.HeadBase.render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case TROLL: {
                matrixStackIn.method_46416(0.0f, 1.0f, -0.35f);
                if (onWall) {
                    matrixStackIn.method_46416(0.0f, 0.0f, 0.35f);
                }
                this.trollModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.trollModel.head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-20.0));
                this.trollModel.head.render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case AMPHITHERE: {
                matrixStackIn.method_46416(0.0f, -0.2f, 0.7f);
                matrixStackIn.method_22905(2.0f, 2.0f, 2.0f);
                this.amphithereModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.amphithereModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.amphithereModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SEASERPENT: {
                matrixStackIn.method_46416(0.0f, -0.35f, 0.8f);
                matrixStackIn.method_22905(2.5f, 2.5f, 2.5f);
                this.seaSerpentModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.seaSerpentModel.getCube("Head"), onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.seaSerpentModel.getCube("Head").render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case HYDRA: {
                matrixStackIn.method_46416(0.0f, -0.2f, -0.1f);
                matrixStackIn.method_22905(2.0f, 2.0f, 2.0f);
                this.hydraModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.hydraModel.Head1, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.hydraModel.Head1.render(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public class_2960 getTexture(EntityMobSkull entity) {
        return this.getSkullTexture(entity.getSkullType());
    }

    public class_2960 getSkullTexture(IafSkullType skull) {
        String s = "iceandfire:textures/models/skulls/skull_" + skull.name().toLowerCase(Locale.ROOT) + ".png";
        class_2960 resourcelocation = SKULL_TEXTURE_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new class_2960(s);
            SKULL_TEXTURE_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

