/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.entity.EntityLightningDragon;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import com.iafenvoy.uranus.client.render.TabulaModelAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_927;

public class LayerDragonEyes
extends class_3887<EntityDragonBase, AdvancedEntityModel<EntityDragonBase>> {
    private TabulaModel fireHead;
    private TabulaModel iceHead;
    private TabulaModel lightningHead;

    public LayerDragonEyes(class_927<EntityDragonBase, AdvancedEntityModel<EntityDragonBase>> renderIn) {
        super(renderIn);
        try {
            this.fireHead = this.onlyKeepCubes(new TabulaModelAccessor(TabulaModelHandlerHelper.loadTabulaModel((String)"assets/iceandfire/models/tabula/firedragon/firedragon_ground"), null), Collections.singletonList("HeadFront"));
            this.iceHead = this.onlyKeepCubes(new TabulaModelAccessor(TabulaModelHandlerHelper.loadTabulaModel((String)"assets/iceandfire/models/tabula/icedragon/icedragon_ground"), null), Collections.singletonList("HeadFront"));
            this.lightningHead = this.onlyKeepCubes(new TabulaModelAccessor(TabulaModelHandlerHelper.loadTabulaModel((String)"assets/iceandfire/models/tabula/lightningdragon/lightningdragon_ground"), null), Collections.singletonList("HeadFront"));
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error((Object)e);
        }
    }

    public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (dragon.shouldRenderEyes()) {
            class_1921 eyes = class_1921.method_23026((class_2960)DragonColor.getById(dragon.getVariant()).getEyesTexture(dragon.getDragonStage()));
            class_4588 ivertexbuilder = bufferIn.getBuffer(eyes);
            if (dragon instanceof EntityLightningDragon && this.lightningHead != null) {
                this.copyPositions(this.lightningHead, (TabulaModel)this.method_17165());
                this.lightningHead.method_2828(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (dragon instanceof EntityIceDragon && this.iceHead != null) {
                this.copyPositions(this.iceHead, (TabulaModel)this.method_17165());
                this.iceHead.method_2828(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (this.fireHead != null) {
                this.copyPositions(this.fireHead, (TabulaModel)this.method_17165());
                this.fireHead.method_2828(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                ((AdvancedEntityModel)this.method_17165()).method_2828(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    protected class_2960 getTexture(EntityDragonBase entityIn) {
        return null;
    }

    private TabulaModel onlyKeepCubes(TabulaModelAccessor model, List<String> strings) {
        ArrayList<AdvancedModelBox> keepCubes = new ArrayList<AdvancedModelBox>();
        for (String str : strings) {
            AdvancedModelBox cube = model.getCube(str);
            keepCubes.add(cube);
            while (cube.getParent() != null) {
                keepCubes.add(cube.getParent());
                cube = cube.getParent();
            }
        }
        this.removeChildren(model, keepCubes);
        model.getCubes().values().removeIf(advancedModelBox -> !keepCubes.contains(advancedModelBox));
        return model;
    }

    private void removeChildren(TabulaModelAccessor model, List<AdvancedModelBox> keepCubes) {
        model.getRootBox().forEach(modelRenderer -> {
            modelRenderer.childModels.removeIf(child -> !keepCubes.contains(child));
            modelRenderer.childModels.forEach(childModel -> this.removeChildren((AdvancedModelBox)childModel, keepCubes));
        });
    }

    private void removeChildren(AdvancedModelBox modelBox, List<AdvancedModelBox> keepCubes) {
        modelBox.childModels.removeIf(modelRenderer -> !keepCubes.contains(modelRenderer));
        modelBox.childModels.forEach(modelRenderer -> this.removeChildren((AdvancedModelBox)modelRenderer, keepCubes));
    }

    public boolean isAngleEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose != null && pose.rotateAngleX == original.rotateAngleX && pose.rotateAngleY == original.rotateAngleY && pose.rotateAngleZ == original.rotateAngleZ;
    }

    public boolean isPositionEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose.rotationPointX == original.rotationPointX && pose.rotationPointY == original.rotationPointY && pose.rotationPointZ == original.rotationPointZ;
    }

    public void copyPositions(TabulaModel model, TabulaModel modelTo) {
        for (AdvancedModelBox cube : model.getCubes().values()) {
            AdvancedModelBox modelToCube;
            if (!this.isAngleEqual(cube, modelToCube = modelTo.getCube(cube.boxName))) {
                cube.rotateAngleX = modelToCube.rotateAngleX;
                cube.rotateAngleY = modelToCube.rotateAngleY;
                cube.rotateAngleZ = modelToCube.rotateAngleZ;
            }
            if (this.isPositionEqual(cube, modelToCube)) continue;
            cube.rotationPointX = modelToCube.rotationPointX;
            cube.rotationPointY = modelToCube.rotationPointY;
            cube.rotationPointZ = modelToCube.rotationPointZ;
        }
    }
}

