/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model.util;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.render.model.util.IEnumDragonModelTypes;
import com.iafenvoy.iceandfire.render.model.util.IEnumDragonPoses;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import java.io.IOException;
import java.util.HashMap;

public class DragonAnimationsLibrary {
    private static final HashMap<String, TabulaModel> models = new HashMap();

    private static String toKey(IEnumDragonPoses p, IEnumDragonModelTypes m) {
        return p.getPose() + m.getModelType();
    }

    public static TabulaModel getModel(IEnumDragonPoses pose, IEnumDragonModelTypes modelType) {
        TabulaModel result = models.get(DragonAnimationsLibrary.toKey(pose, modelType));
        if (result == null) {
            IceAndFire.LOGGER.error("No model defined for {}{} have you registered your animations?", (Object)pose.getPose(), (Object)modelType.getModelType());
        }
        return result;
    }

    public static void registerSingle(IEnumDragonPoses pose, IEnumDragonModelTypes modelType) {
        DragonAnimationsLibrary.registerSingle(pose, modelType, "iceandfire");
    }

    public static void register(IEnumDragonPoses[] poses, IEnumDragonModelTypes[] modelTypes) {
        for (IEnumDragonPoses p : poses) {
            for (IEnumDragonModelTypes m : modelTypes) {
                DragonAnimationsLibrary.registerSingle(p, m, "iceandfire");
            }
        }
    }

    public static void register(IEnumDragonPoses[] poses, IEnumDragonModelTypes[] modelTypes, String modID) {
        for (IEnumDragonPoses p : poses) {
            for (IEnumDragonModelTypes m : modelTypes) {
                DragonAnimationsLibrary.registerSingle(p, m, modID);
            }
        }
    }

    public static void registerSingle(IEnumDragonPoses pose, IEnumDragonModelTypes modelType, String modID) {
        TabulaModel result;
        String location = "assets/iceandfire/models/tabula/" + modelType.getModelType() + "dragon/" + modelType.getModelType() + "dragon_" + pose.getPose() + ".tbl";
        try {
            result = new TabulaModel(TabulaModelHandlerHelper.loadTabulaModel((String)location));
        }
        catch (IOException | NullPointerException e) {
            IceAndFire.LOGGER.warn("Could not load {}: {}", (Object)location, (Object)e.getMessage());
            return;
        }
        models.put(DragonAnimationsLibrary.toKey(pose, modelType), result);
    }

    public static void registerReferences(IEnumDragonPoses[] poses, IEnumDragonModelTypes modelSource, IEnumDragonModelTypes[] modelDestinations) {
        for (int i = 0; i < poses.length; ++i) {
            DragonAnimationsLibrary.registerReference(poses[i], modelSource, modelDestinations[i]);
        }
    }

    public static void registerReference(IEnumDragonPoses pose, IEnumDragonModelTypes modelSource, IEnumDragonModelTypes modelDestination) {
        TabulaModel source = DragonAnimationsLibrary.getModel(pose, modelSource);
        String destKey = DragonAnimationsLibrary.toKey(pose, modelDestination);
        if (source == null) {
            return;
        }
        if (models.containsKey(destKey)) {
            IceAndFire.LOGGER.info("Overriding existing model '{}' with reference to '{}", (Object)destKey, (Object)DragonAnimationsLibrary.toKey(pose, modelSource));
        }
        models.put(destKey, source);
    }
}

