/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.uranus.util.RandomHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8519;

public class TitleScreenRenderManager {
    public static final class_2960 splash = new class_2960("iceandfire", "splashes.txt");
    public static final class_2960[] pageFlipTextures;
    public static final class_2960[] drawingTextures;
    private static final class_2960 BESTIARY_TEXTURE;
    private static final class_2960 TABLE_TEXTURE;
    private static final class_327 textRenderer;
    private static int layerTick;
    private static List<String> splashText;
    private static boolean isFlippingPage;
    private static int pageFlip;
    private static Picture[] drawnPictures;
    private static float globalAlpha;

    public static class_8519 getSplash() {
        if (TitleScreenRenderManager.splashText == null) {
            try {
                BufferedReader bufferedReader = class_310.method_1551().method_1478().openAsReader(splash);
                TitleScreenRenderManager.splashText = bufferedReader.lines().map(String::trim).filter(splashText -> splashText.hashCode() != 125780783).toList();
                bufferedReader.close();
            }
            catch (IOException var8) {
                TitleScreenRenderManager.splashText = new ArrayList<String>();
            }
        }
        if (TitleScreenRenderManager.splashText.isEmpty()) {
            return null;
        }
        return new class_8519(TitleScreenRenderManager.splashText.get(RandomHelper.nextInt((int)0, (int)(TitleScreenRenderManager.splashText.size() - 1))));
    }

    private static void resetDrawnImages() {
        globalAlpha = 0.0f;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        drawnPictures = new Picture[2];
        boolean left = ((Random)random).nextBoolean();
        for (int i = 0; i < drawnPictures.length; ++i) {
            left = !left;
            int x = left ? -15 - ((Random)random).nextInt(20) - 128 : 30 + ((Random)random).nextInt(20);
            int y = ((Random)random).nextInt(25);
            TitleScreenRenderManager.drawnPictures[i] = new Picture(((Random)random).nextInt(drawingTextures.length), x, y, 0.5f, ((Random)random).nextFloat() * 0.5f + 0.5f);
        }
    }

    public static void tick() {
        float flipTick = layerTick % 40;
        if (globalAlpha < 1.0f && !isFlippingPage && flipTick < 30.0f) {
            globalAlpha += 0.1f;
        }
        if (globalAlpha > 0.0f && flipTick > 30.0f) {
            globalAlpha -= 0.1f;
        }
        if (flipTick == 0.0f && !isFlippingPage) {
            isFlippingPage = true;
        }
        if (isFlippingPage) {
            if (layerTick % 2 == 0) {
                ++pageFlip;
            }
            if (pageFlip == 6) {
                pageFlip = 0;
                isFlippingPage = false;
                TitleScreenRenderManager.resetDrawnImages();
            }
        }
        ++layerTick;
    }

    public static void renderBackground(class_332 ms, int width, int height) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        ms.method_25290(TABLE_TEXTURE, 0, 0, 0.0f, 0.0f, width, height, width, height);
        ms.method_25290(BESTIARY_TEXTURE, 50, 0, 0.0f, 0.0f, width - 100, height, width - 100, height);
        if (isFlippingPage) {
            ms.method_25290(pageFlipTextures[Math.min(5, pageFlip)], 50, 0, 0.0f, 0.0f, width - 100, height, width - 100, height);
        } else {
            int middleX = width / 2;
            int middleY = height / 5;
            float widthScale = (float)width / 427.0f;
            float heightScale = (float)height / 427.0f;
            float imageScale = Math.min(widthScale, heightScale) * 192.0f;
            RenderSystem.enableBlend();
            for (Picture picture : drawnPictures) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)globalAlpha);
                int x = (int)((float)picture.x * widthScale) + middleX;
                int y = (int)((float)picture.y * heightScale + (float)middleY);
                ms.method_25290(drawingTextures[picture.image], x, y, 0.0f, 0.0f, (int)imageScale, (int)imageScale, (int)imageScale, (int)imageScale);
            }
            RenderSystem.disableBlend();
        }
    }

    public static void drawModName(class_332 ms, int width, int height, int alphaFormatted) {
        int textColor = 0xFFFFFF | alphaFormatted;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        ms.method_51433(textRenderer, "Ice and Fire Fabric-" + class_124.field_1054 + IceAndFire.VERSION, 2, height - 30, textColor, false);
        ms.method_51433(textRenderer, class_124.field_1065 + "Report if you meet any crash.", 2, height - 20, textColor, false);
    }

    static {
        drawingTextures = new class_2960[23];
        BESTIARY_TEXTURE = new class_2960("iceandfire", "textures/gui/main_menu/bestiary_menu.png");
        TABLE_TEXTURE = new class_2960("iceandfire", "textures/gui/main_menu/table.png");
        textRenderer = class_310.method_1551().field_1772;
        isFlippingPage = false;
        pageFlip = 0;
        globalAlpha = 1.0f;
        pageFlipTextures = new class_2960[]{new class_2960("iceandfire", "textures/gui/main_menu/page_1.png"), new class_2960("iceandfire", "textures/gui/main_menu/page_2.png"), new class_2960("iceandfire", "textures/gui/main_menu/page_3.png"), new class_2960("iceandfire", "textures/gui/main_menu/page_4.png"), new class_2960("iceandfire", "textures/gui/main_menu/page_5.png"), new class_2960("iceandfire", "textures/gui/main_menu/page_6.png")};
        for (int i = 0; i < drawingTextures.length; ++i) {
            TitleScreenRenderManager.drawingTextures[i] = new class_2960("iceandfire", "textures/gui/main_menu/drawing_" + i + ".png");
        }
        TitleScreenRenderManager.resetDrawnImages();
    }

    private static class Picture {
        final int image;
        final int x;
        final int y;
        final float alpha;

        public Picture(int image, int x, int y, float alpha, float scale) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }
}

