/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.iafenvoy.iceandfire.screen.handler.DragonForgeScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class DragonForgeScreen
extends class_465<DragonForgeScreenHandler> {
    private static final class_2960 TEXTURE_FIRE = new class_2960("iceandfire", "textures/gui/dragonforge_fire.png");
    private static final class_2960 TEXTURE_ICE = new class_2960("iceandfire", "textures/gui/dragonforge_ice.png");
    private static final class_2960 TEXTURE_LIGHTNING = new class_2960("iceandfire", "textures/gui/dragonforge_lightning.png");
    private final DragonForgeScreenHandler tileFurnace;

    public DragonForgeScreen(DragonForgeScreenHandler container, class_1661 inv, class_2561 name) {
        super((class_1703)container, inv, name);
        this.tileFurnace = container;
    }

    protected void method_2388(class_332 pGuiGraphics, int mouseX, int mouseY) {
        assert (this.field_22787 != null);
        class_327 textRenderer = this.field_22787.field_1772;
        if (this.tileFurnace != null) {
            String s = class_1074.method_4662((String)("block.iceandfire.dragonforge_" + DragonType.getNameFromInt(this.tileFurnace.getPropertyDelegate().fireType) + "_core"), (Object[])new Object[0]);
            pGuiGraphics.method_51433(this.field_22793, s, this.field_2792 / 2 - textRenderer.method_1727(s) / 2, 6, 0x404040, false);
        }
        pGuiGraphics.method_51439(this.field_22793, this.field_29347, 8, this.field_2779 - 96 + 2, 0x404040, false);
    }

    protected void method_2389(class_332 pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int dragonType = this.tileFurnace.getPropertyDelegate().fireType;
        class_2960 texture = switch (dragonType) {
            case 0 -> TEXTURE_FIRE;
            case 1 -> TEXTURE_ICE;
            default -> TEXTURE_LIGHTNING;
        };
        int k = (this.field_22789 - this.field_2792) / 2;
        int l = (this.field_22790 - this.field_2779) / 2;
        pGuiGraphics.method_25302(texture, k, l, 0, 0, this.field_2792, this.field_2779);
        int i1 = this.getCookTime(this.tileFurnace.getPropertyDelegate().cookTime);
        pGuiGraphics.method_25302(texture, k + 12, l + 23, 0, 166, i1, 38);
    }

    private int getCookTime(int time) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1687 != null);
        List<DragonForgeRecipe> recipes = this.field_22787.field_1687.method_8433().method_30027(IafRecipes.DRAGON_FORGE_TYPE).stream().filter(item -> item.isValidInput(this.tileFurnace.method_7611(0).method_7677()) && item.isValidBlood(this.tileFurnace.method_7611(1).method_7677())).toList();
        int maxCookTime = recipes.isEmpty() ? 100 : recipes.get(0).getCookTime();
        double scale = 125000.0 / (double)maxCookTime;
        return (int)(scale * (double)time / (double)maxCookTime);
    }

    public void method_25394(class_332 pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(pGuiGraphics);
        super.method_25394(pGuiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(pGuiGraphics, mouseX, mouseY);
    }
}

