/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui;

import com.google.common.collect.Lists;
import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.screen.gui.MyrmexDeleteButton;
import com.iafenvoy.iceandfire.screen.gui.bestiary.ChangePageButton;
import com.iafenvoy.iceandfire.screen.handler.MyrmexStaffScreenHandler;
import com.iafenvoy.iceandfire.world.MyrmexWorldData;
import com.iafenvoy.iceandfire.world.gen.WorldGenMyrmexHive;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4597;
import net.minecraft.class_465;

public class MyrmexStaffScreen
extends class_465<MyrmexStaffScreenHandler> {
    private static final class_2960 JUNGLE_TEXTURE = new class_2960("iceandfire", "textures/gui/myrmex_staff_jungle.png");
    private static final class_2960 DESERT_TEXTURE = new class_2960("iceandfire", "textures/gui/myrmex_staff_desert.png");
    private static final WorldGenMyrmexHive.RoomType[] ROOMS = new WorldGenMyrmexHive.RoomType[]{WorldGenMyrmexHive.RoomType.FOOD, WorldGenMyrmexHive.RoomType.NURSERY, WorldGenMyrmexHive.RoomType.EMPTY};
    private static final int ROOMS_PER_PAGE = 5;
    private final List<Room> allRoomPos = Lists.newArrayList();
    private final List<MyrmexDeleteButton> allRoomButtonPos = Lists.newArrayList();
    private final boolean jungle;
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    int ticksSinceDeleted = 0;
    int currentPage = 0;
    private int hiveCount;

    public MyrmexStaffScreen(MyrmexStaffScreenHandler handler, class_1661 playerInventory, class_2561 name) {
        super((class_1703)handler, playerInventory, name);
        this.jungle = handler.getStaff().method_7909() == IafItems.MYRMEX_JUNGLE_STAFF;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_33816.clear();
        this.allRoomButtonPos.clear();
        int i = (this.field_22789 - 248) / 2;
        int j = (this.field_22790 - 166) / 2;
        int x_translate = 193;
        int y_translate = 37;
        MyrmexHive hive = MyrmexWorldData.get((class_1937)class_310.method_1551().field_1687).getHiveFromUUID(((MyrmexStaffScreenHandler)this.field_2797).getTargetId());
        if (hive == null) {
            return;
        }
        this.populateRoomMap();
        this.method_25429((class_364)class_4185.method_46430((class_2561)(hive.reproduces ? class_2561.method_43471((String)"myrmex.message.disablebreeding") : class_2561.method_43471((String)"myrmex.message.enablebreeding")), p_214132_1_ -> {
            hive.reproduces = !hive.reproduces;
        }).method_46433(i + 124, j + 15).method_46437(120, 20).method_46431());
        this.previousPage = new ChangePageButton(i + 5, j + 150, false, this.jungle ? 2 : 1, p_214132_1_ -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        });
        this.method_25429((class_364)this.previousPage);
        this.nextPage = new ChangePageButton(i + 225, j + 150, true, this.jungle ? 2 : 1, p_214132_1_ -> {
            if (this.currentPage < this.allRoomButtonPos.size() / 5) {
                ++this.currentPage;
            }
        });
        this.method_25429((class_364)this.nextPage);
        int totalRooms = this.allRoomPos.size();
        for (int rooms = 0; rooms < this.allRoomPos.size(); ++rooms) {
            int yIndex = rooms % 5;
            class_2338 pos = this.allRoomPos.get((int)rooms).pos;
            MyrmexDeleteButton button = new MyrmexDeleteButton(i + x_translate, j + y_translate + yIndex * 22, pos, (class_2561)class_2561.method_43471((String)"myrmex.message.delete"), p_214132_1_ -> {
                if (this.ticksSinceDeleted <= 0) {
                    hive.removeRoom(pos);
                    this.ticksSinceDeleted = 5;
                }
            });
            button.field_22764 = rooms < 5 * (this.currentPage + 1) && rooms >= 5 * this.currentPage;
            this.method_25429((class_364)button);
            this.allRoomButtonPos.add(button);
        }
        if (totalRooms <= 5 * this.currentPage && this.currentPage > 0) {
            --this.currentPage;
        }
    }

    private void populateRoomMap() {
        this.allRoomPos.clear();
        MyrmexHive hive = MyrmexWorldData.get((class_1937)class_310.method_1551().field_1687).getHiveFromUUID(((MyrmexStaffScreenHandler)this.field_2797).getTargetId());
        for (WorldGenMyrmexHive.RoomType type : ROOMS) {
            List<class_2338> roomPos = hive.getRooms(type);
            for (class_2338 pos : roomPos) {
                String name = type == WorldGenMyrmexHive.RoomType.FOOD ? "food" : (type == WorldGenMyrmexHive.RoomType.NURSERY ? "nursery" : "misc");
                this.allRoomPos.add(new Room(pos, name));
            }
        }
        for (class_2338 pos : hive.getEntrances().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_surface"));
        }
        for (class_2338 pos : hive.getEntranceBottoms().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_bottom"));
        }
    }

    public void method_25420(class_332 ms) {
        super.method_25420(ms);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.field_22789 - 248) / 2;
        int j = (this.field_22790 - 166) / 2;
        ms.method_25302(this.jungle ? JUNGLE_TEXTURE : DESERT_TEXTURE, i, j, 0, 0, 248, 166);
    }

    public void method_25394(class_332 ms, int mouseX, int mouseY, float partialTicks) {
        int color;
        this.method_25420(ms);
        this.method_25426();
        int i = (this.field_22789 - 248) / 2 + 10;
        int j = (this.field_22790 - 166) / 2 + 8;
        super.method_25394(ms, mouseX, mouseY, partialTicks);
        int n = color = this.jungle ? 3533333 : 0xFFBF00;
        if (this.ticksSinceDeleted > 0) {
            --this.ticksSinceDeleted;
        }
        this.hiveCount = 0;
        for (int rooms = 0; rooms < this.allRoomButtonPos.size(); ++rooms) {
            if (rooms >= 5 * (this.currentPage + 1) || rooms < 5 * this.currentPage) continue;
            this.drawRoomInfo(ms, this.allRoomPos.get((int)rooms).string, this.allRoomPos.get((int)rooms).pos, i, j, color);
        }
        MyrmexHive hive = MyrmexWorldData.get((class_1937)class_310.method_1551().field_1687).getHiveFromUUID(((MyrmexStaffScreenHandler)this.field_2797).getTargetId());
        if (hive != null) {
            assert (this.field_22787 != null);
            class_327 textRenderer = this.field_22787.field_1772;
            if (!hive.colonyName.isEmpty()) {
                String title = class_1074.method_4662((String)"myrmex.message.colony_named", (Object[])new Object[]{hive.colonyName});
                textRenderer.method_27521(title, (float)(i + 40) - (float)title.length() / 2.0f, (float)(j - 3), color, false, ms.method_51448().method_23760().method_23761(), (class_4597)ms.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
            } else {
                textRenderer.method_27521(class_1074.method_4662((String)"myrmex.message.colony", (Object[])new Object[0]), (float)(i + 80), (float)(j - 3), color, false, ms.method_51448().method_23760().method_23761(), (class_4597)ms.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
            }
            assert (class_310.method_1551().field_1724 != null);
            int opinion = hive.getPlayerReputation(class_310.method_1551().field_1724.method_5667());
            textRenderer.method_27521(class_1074.method_4662((String)"myrmex.message.hive_opinion", (Object[])new Object[]{opinion}), (float)i, (float)(j + 12), color, false, ms.method_51448().method_23760().method_23761(), (class_4597)ms.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
            textRenderer.method_27521(class_1074.method_4662((String)"myrmex.message.rooms", (Object[])new Object[0]), (float)i, (float)(j + 25), color, false, ms.method_51448().method_23760().method_23761(), (class_4597)ms.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
    }

    public void method_25432() {
        MyrmexHive hive = MyrmexWorldData.get((class_1937)class_310.method_1551().field_1687).getHiveFromUUID(((MyrmexStaffScreenHandler)this.field_2797).getTargetId());
        if (hive != null) {
            class_2540 buf = PacketByteBufs.create().method_10794(hive.toNBT());
            ClientPlayNetworking.send((class_2960)StaticVariables.MYRMEX_SYNC, (class_2540)buf);
        }
    }

    private void drawRoomInfo(class_332 ms, String type, class_2338 pos, int i, int j, int color) {
        String translate = "myrmex.message.room." + type;
        assert (this.field_22787 != null);
        this.field_22787.field_1772.method_27521(class_1074.method_4662((String)translate, (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}), (float)i, (float)(j + 36 + this.hiveCount * 22), color, false, ms.method_51448().method_23760().method_23761(), (class_4597)ms.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
        ++this.hiveCount;
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    private record Room(class_2338 pos, String string) {
    }
}

