/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.util;

import com.iafenvoy.iceandfire.registry.IafFeatures;
import com.iafenvoy.iceandfire.world.IafWorldData;
import net.minecraft.class_1267;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7134;
import net.minecraft.class_7924;

public class WorldUtil {
    public static boolean isBlockLoaded(class_1936 world, class_2338 pos) {
        return WorldUtil.isChunkLoaded(world, pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    public static boolean isChunkLoaded(class_1936 world, int x, int z) {
        if (world.method_8398() instanceof class_3215) {
            class_3193 holder = ((class_3215)world.method_8398()).field_17254.method_17216(class_1923.method_8331((int)x, (int)z));
            if (holder != null) {
                return holder.method_20725().getNow(class_3193.field_16427).left().isPresent();
            }
            return false;
        }
        return world.method_8402(x, z, class_2806.field_12803, false) != null;
    }

    public static void markChunkDirty(class_1937 world, class_2338 pos) {
        if (WorldUtil.isBlockLoaded((class_1936)world, pos)) {
            world.method_8497(pos.method_10263() >> 4, pos.method_10260() >> 4).method_12008(true);
            class_2680 state = world.method_8320(pos);
            world.method_8413(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(class_1936 world, class_1923 pos) {
        return WorldUtil.isChunkLoaded(world, pos.field_9181, pos.field_9180);
    }

    public static boolean isEntityBlockLoaded(class_1936 world, class_2338 pos) {
        return WorldUtil.isEntityChunkLoaded(world, pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    public static boolean isEntityChunkLoaded(class_1936 world, int x, int z) {
        return WorldUtil.isEntityChunkLoaded(world, new class_1923(x, z));
    }

    public static boolean isEntityChunkLoaded(class_1936 world, class_1923 pos) {
        if (world instanceof class_3218) {
            return WorldUtil.isChunkLoaded(world, pos) && ((class_3218)world).method_37118(pos.method_8323());
        }
        return WorldUtil.isChunkLoaded(world, pos);
    }

    public static boolean isAABBLoaded(class_1937 world, class_238 box) {
        return WorldUtil.isChunkLoaded((class_1936)world, (int)box.field_1323 >> 4, (int)box.field_1321 >> 4) && WorldUtil.isChunkLoaded((class_1936)world, (int)box.field_1320 >> 4, (int)box.field_1324 >> 4);
    }

    public static boolean isPastTime(class_1937 world, int pastTime) {
        return world.method_8532() % 24000L <= (long)pastTime;
    }

    public static boolean isOverworldType(class_1937 world) {
        return WorldUtil.isOfWorldType(world, (class_5321<class_2874>)class_7134.field_37666);
    }

    public static boolean isNetherType(class_1937 world) {
        return WorldUtil.isOfWorldType(world, (class_5321<class_2874>)class_7134.field_37667);
    }

    public static boolean isOfWorldType(class_1937 world, class_5321<class_2874> type) {
        class_5455 dynRegistries = world.method_30349();
        class_2960 loc = ((class_2378)dynRegistries.method_33310(class_7924.field_41241).get()).method_10221((Object)world.method_8597());
        if (loc == null) {
            if (world.field_9236) {
                return world.method_8597().comp_655().equals((Object)type.method_29177());
            }
            return false;
        }
        class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)loc);
        return regKey == type;
    }

    public static boolean isPeaceful(class_1937 world) {
        return !world.method_8401().method_146().method_8355(class_1928.field_19390) || world.method_8407().equals((Object)class_1267.field_5801);
    }

    public static int getDimensionMaxHeight(class_2874 dimensionType) {
        return dimensionType.comp_653() + dimensionType.comp_651();
    }

    public static int getDimensionMinHeight(class_2874 dimensionType) {
        return dimensionType.comp_651();
    }

    public static boolean isInWorldHeight(int yBlock, class_1937 world) {
        class_2874 dimensionType = world.method_8597();
        return yBlock > WorldUtil.getDimensionMinHeight(dimensionType) && yBlock < WorldUtil.getDimensionMaxHeight(dimensionType);
    }

    public static boolean canGenerate(double configChance, class_5281 level, class_5819 random, class_2338 origin, String id, boolean checkFluid) {
        return WorldUtil.canGenerate(configChance, level, random, origin, id, IafWorldData.FeatureType.SURFACE, checkFluid);
    }

    public static boolean canGenerate(double configChance, class_5281 level, class_5819 random, class_2338 origin, String id, IafWorldData.FeatureType type, boolean checkFluid) {
        boolean canGenerate;
        boolean bl = canGenerate = random.method_43058() < configChance && IafFeatures.isFarEnoughFromSpawn((class_1936)level, origin) && IafFeatures.isFarEnoughFromDangerousGen((class_5425)level, origin, id, type);
        if (canGenerate && checkFluid && !level.method_8316(origin.method_10074()).method_15769()) {
            return false;
        }
        return canGenerate;
    }
}

