/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world;

import com.iafenvoy.iceandfire.IceAndFire;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class DragonPosWorldData
extends class_18 {
    private static final String IDENTIFIER = "iceandfire_dragonPositions";
    protected final Map<UUID, class_2338> lastDragonPositions = new HashMap<UUID, class_2338>();
    private class_1937 world;
    private int tickCounter;

    public DragonPosWorldData() {
    }

    public DragonPosWorldData(class_1937 world) {
        this.world = world;
        this.method_80();
    }

    public DragonPosWorldData(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public static DragonPosWorldData get(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 overworld = world.method_8503().method_3847(world.method_27983());
            assert (overworld != null);
            class_26 storage = overworld.method_17983();
            DragonPosWorldData data = (DragonPosWorldData)storage.method_17924(DragonPosWorldData::new, DragonPosWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.method_80();
            }
            return data;
        }
        return null;
    }

    public void addDragon(UUID uuid, class_2338 pos) {
        this.lastDragonPositions.put(uuid, pos);
        this.method_80();
    }

    public void removeDragon(UUID uuid) {
        this.lastDragonPositions.remove(uuid);
        this.method_80();
    }

    public class_2338 getDragonPos(UUID uuid) {
        return this.lastDragonPositions.get(uuid);
    }

    public void debug() {
        IceAndFire.LOGGER.warn(this.lastDragonPositions.toString());
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void load(class_2487 nbt) {
        this.tickCounter = nbt.method_10550("Tick");
        class_2499 nbttaglist = nbt.method_10554("DragonMap", 10);
        this.lastDragonPositions.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            class_2487 CompoundNBT = nbttaglist.method_10602(i);
            UUID uuid = CompoundNBT.method_25926("DragonUUID");
            class_2338 pos = new class_2338(CompoundNBT.method_10550("DragonPosX"), CompoundNBT.method_10550("DragonPosY"), CompoundNBT.method_10550("DragonPosZ"));
            this.lastDragonPositions.put(uuid, pos);
        }
    }

    public class_2487 method_75(class_2487 compound) {
        compound.method_10569("Tick", this.tickCounter);
        class_2499 nbttaglist = new class_2499();
        for (Map.Entry<UUID, class_2338> pair : this.lastDragonPositions.entrySet()) {
            class_2487 CompoundNBT = new class_2487();
            CompoundNBT.method_25927("DragonUUID", pair.getKey());
            CompoundNBT.method_10569("DragonPosX", pair.getValue().method_10263());
            CompoundNBT.method_10569("DragonPosY", pair.getValue().method_10264());
            CompoundNBT.method_10569("DragonPosZ", pair.getValue().method_10260());
            nbttaglist.add((Object)CompoundNBT);
        }
        compound.method_10566("DragonMap", (class_2520)nbttaglist);
        return compound;
    }
}

