/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.world.gen.TypedFeature;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class IafWorldData
extends class_18 {
    private static final String IDENTIFIER = "iceandfire_general";
    private static final Map<FeatureType, CopyOnWriteArrayList<Pair<String, class_2338>>> LAST_GENERATED = new HashMap<FeatureType, CopyOnWriteArrayList<Pair<String, class_2338>>>();

    public IafWorldData() {
    }

    public IafWorldData(class_2487 tag) {
        this.load(tag);
    }

    public static IafWorldData get(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 overworld = world.method_8503().method_3847(world.method_27983());
            assert (overworld != null);
            class_26 storage = overworld.method_17983();
            IafWorldData data = (IafWorldData)storage.method_17924(IafWorldData::new, IafWorldData::new, IDENTIFIER);
            data.method_80();
            return data;
        }
        return null;
    }

    public boolean check(TypedFeature feature, class_2338 position, String id) {
        return this.check(feature.getFeatureType(), position, id);
    }

    public boolean check(FeatureType type, class_2338 position, String id) {
        CopyOnWriteArrayList entries = LAST_GENERATED.computeIfAbsent(type, key -> new CopyOnWriteArrayList());
        boolean canGenerate = true;
        Pair toRemove = null;
        for (Pair entry : entries) {
            if (((String)entry.getFirst()).equals(id)) {
                toRemove = entry;
            }
            canGenerate = Math.sqrt(position.method_10262((class_2382)entry.getSecond())) > (Double)IafCommonConfig.INSTANCE.worldGen.dangerousSeparationLimit.getValue();
        }
        if (toRemove != null) {
            entries.remove(toRemove);
        }
        entries.add(Pair.of((Object)id, (Object)position));
        return canGenerate;
    }

    public void load(class_2487 tag) {
        FeatureType[] types;
        for (FeatureType type : types = FeatureType.values()) {
            class_2499 list = tag.method_10554(type.toString(), 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 entry = list.method_10602(i);
                String id = entry.method_10558("id");
                class_2338 position = class_2512.method_10691((class_2487)entry.method_10562("position"));
                LAST_GENERATED.computeIfAbsent(type, key -> new CopyOnWriteArrayList()).add(Pair.of((Object)id, (Object)position));
            }
        }
    }

    public class_2487 method_75(class_2487 tag) {
        LAST_GENERATED.forEach((key, value) -> {
            class_2499 listTag = new class_2499();
            value.forEach(entry -> {
                class_2487 subTag = new class_2487();
                subTag.method_10582("id", (String)entry.getFirst());
                subTag.method_10566("position", (class_2520)class_2512.method_10692((class_2338)((class_2338)entry.getSecond())));
                listTag.add((Object)subTag);
            });
            tag.method_10566(key.toString(), (class_2520)listTag);
        });
        return tag;
    }

    public static enum FeatureType {
        SURFACE,
        UNDERGROUND,
        OCEAN;

    }
}

