/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world;

import com.google.common.collect.Lists;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class MyrmexWorldData
extends class_18 {
    private static final String IDENTIFIER = "iceandfire_myrmex";
    private final List<class_2338> villagerPositionsList = Lists.newArrayList();
    private final List<MyrmexHive> hiveList = Lists.newArrayList();
    private class_1937 world;
    private int tickCounter;

    public MyrmexWorldData() {
    }

    public MyrmexWorldData(class_1937 world) {
        this.world = world;
        this.method_80();
    }

    public MyrmexWorldData(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public static MyrmexWorldData get(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 overworld = world.method_8503().method_3847(world.method_27983());
            assert (overworld != null);
            class_26 storage = overworld.method_17983();
            MyrmexWorldData data = (MyrmexWorldData)storage.method_17924(MyrmexWorldData::new, MyrmexWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.method_80();
            }
            return data;
        }
        return new MyrmexWorldData();
    }

    public static void addHive(class_1937 world, MyrmexHive hive) {
        MyrmexWorldData.get((class_1937)world).hiveList.add(hive);
    }

    public void setWorldsForAll(class_1937 worldIn) {
        this.world = worldIn;
        for (MyrmexHive village : this.hiveList) {
            village.setWorld(worldIn);
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (MyrmexHive hive : this.hiveList) {
            hive.tick(this.tickCounter, this.world);
        }
    }

    private void removeAnnihilatedHives() {
        Iterator<MyrmexHive> iterator = this.hiveList.iterator();
        while (iterator.hasNext()) {
            MyrmexHive village = iterator.next();
            if (!village.isAnnihilated()) continue;
            iterator.remove();
            this.method_80();
        }
    }

    public List<MyrmexHive> getHivelist() {
        return this.hiveList;
    }

    public MyrmexHive getNearestHive(class_2338 doorBlock, int radius) {
        MyrmexHive village = null;
        double d0 = 3.4028234663852886E38;
        for (MyrmexHive village1 : this.hiveList) {
            float f;
            double d1 = village1.getCenter().method_10262((class_2382)doorBlock);
            if (!(d1 < d0) || !(d1 <= (double)((f = (float)(radius + village1.getVillageRadius())) * f))) continue;
            village = village1;
            d0 = d1;
        }
        return village;
    }

    private boolean positionInList(class_2338 pos) {
        for (class_2338 blockpos : this.villagerPositionsList) {
            if (!blockpos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public void debug() {
        for (MyrmexHive hive : this.hiveList) {
            IceAndFire.LOGGER.warn(hive.toString());
        }
    }

    public void load(class_2487 nbt) {
        this.tickCounter = nbt.method_10550("Tick");
        class_2499 nbttaglist = nbt.method_10554("Hives", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            class_2487 CompoundNBT = nbttaglist.method_10602(i);
            MyrmexHive village = new MyrmexHive();
            village.readVillageDataFromNBT(CompoundNBT);
            this.hiveList.add(village);
        }
    }

    public class_2487 method_75(class_2487 compound) {
        compound.method_10569("Tick", this.tickCounter);
        class_2499 nbttaglist = new class_2499();
        for (MyrmexHive village : this.hiveList) {
            class_2487 CompoundNBT = new class_2487();
            village.writeVillageDataToNBT(CompoundNBT);
            nbttaglist.add((Object)CompoundNBT);
        }
        compound.method_10566("Hives", (class_2520)nbttaglist);
        return compound;
    }

    public MyrmexHive getHiveFromUUID(UUID id) {
        for (MyrmexHive hive : this.hiveList) {
            if (hive.hiveUUID == null || !hive.hiveUUID.equals(id)) continue;
            return hive;
        }
        return null;
    }
}

