/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.gen;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityCyclops;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.util.WorldUtil;
import com.iafenvoy.iceandfire.world.IafWorldData;
import com.iafenvoy.iceandfire.world.gen.TypedFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_4739;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class WorldGenCyclopsCave
extends class_3031<class_3111>
implements TypedFeature {
    public static final class_2960 CYCLOPS_CHEST = new class_2960("iceandfire", "chest/cyclops_cave");
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public WorldGenCyclopsCave(Codec<class_3111> configuration) {
        super(configuration);
    }

    private static void generateShell(class_5821<class_3111> context, int size) {
        int x = size + context.method_33654().method_43048(2);
        int y = 12 + context.method_33654().method_43048(2);
        int z = size + context.method_33654().method_43048(2);
        float radius = (float)(x + y + z) * 0.333f + 0.5f;
        for (class_2338 position : class_2338.method_20437((class_2338)context.method_33655().method_10069(-x, -y, -z), (class_2338)context.method_33655().method_10069(x, y, z)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            boolean isNotInDoorway;
            boolean doorwayX = position.method_10263() >= context.method_33655().method_10263() - 2 + context.method_33654().method_43048(2) && position.method_10263() <= context.method_33655().method_10263() + 2 + context.method_33654().method_43048(2);
            boolean doorwayZ = position.method_10260() >= context.method_33655().method_10260() - 2 + context.method_33654().method_43048(2) && position.method_10260() <= context.method_33655().method_10260() + 2 + context.method_33654().method_43048(2);
            boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && position.method_10264() > context.method_33655().method_10264() || position.method_10264() > context.method_33655().method_10264() + y - (3 + context.method_33654().method_43048(2));
            if (!(position.method_10262((class_2382)context.method_33655()) <= (double)(radius * radius))) continue;
            class_2680 state = context.method_33652().method_8320(position);
            if (!(state.method_26204() instanceof class_4739) && state.method_26214((class_1922)context.method_33652(), position) >= 0.0f && isNotInDoorway) {
                context.method_33652().method_8652(position, class_2246.field_10340.method_9564(), 3);
            }
            if (position.method_10264() == context.method_33655().method_10264()) {
                context.method_33652().method_8652(position, class_2246.field_9989.method_9564(), 3);
            }
            if (position.method_10264() > context.method_33655().method_10264() - 1 || state.method_26225()) continue;
            context.method_33652().method_8652(position, class_2246.field_10445.method_9564(), 3);
        }
    }

    public boolean method_13151(class_5821<class_3111> context) {
        if (!WorldUtil.canGenerate((Double)IafCommonConfig.INSTANCE.cyclops.spawnCaveChance.getValue(), context.method_33652(), context.method_33654(), context.method_33655(), this.getId(), true)) {
            return false;
        }
        int size = 16;
        int distance = 6;
        if (context.method_33652().method_22347(context.method_33655().method_10069(size - distance, -3, -size + distance)) || context.method_33652().method_22347(context.method_33655().method_10069(size - distance, -3, size - distance)) || context.method_33652().method_22347(context.method_33655().method_10069(-size + distance, -3, -size + distance)) || context.method_33652().method_22347(context.method_33655().method_10069(-size + distance, -3, size - distance))) {
            return false;
        }
        WorldGenCyclopsCave.generateShell(context, size);
        int innerSize = size - 2;
        int x = innerSize + context.method_33654().method_43048(2);
        int y = 10 + context.method_33654().method_43048(2);
        int z = innerSize + context.method_33654().method_43048(2);
        float radius = (float)(x + y + z) * 0.333f + 0.5f;
        int sheepPenCount = 0;
        for (class_2338 position : class_2338.method_20437((class_2338)context.method_33655().method_10069(-x, -y, -z), (class_2338)context.method_33655().method_10069(x, y, z)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(position.method_10262((class_2382)context.method_33655()) <= (double)(radius * radius)) || position.method_10264() <= context.method_33655().method_10264() || context.method_33652().method_8320(context.method_33655()).method_26204() instanceof class_4739) continue;
            context.method_33652().method_8652(position, class_2246.field_10124.method_9564(), 3);
        }
        for (class_2338 position : class_2338.method_20437((class_2338)context.method_33655().method_10069(-x, -y, -z), (class_2338)context.method_33655().method_10069(x, y, z)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(position.method_10262((class_2382)context.method_33655()) <= (double)(radius * radius)) || position.method_10264() != context.method_33655().method_10264()) continue;
            if (context.method_33654().method_43048(130) == 0 && this.isTouchingAir((class_1936)context.method_33652(), position.method_10084())) {
                this.generateSkeleton((class_1936)context.method_33652(), position.method_10084(), context.method_33654(), context.method_33655(), radius);
            }
            if (context.method_33654().method_43048(130) == 0 && position.method_10262((class_2382)context.method_33655()) <= (double)(radius * radius) * (double)0.8f && sheepPenCount < 2) {
                this.generateSheepPen((class_5425)context.method_33652(), position.method_10084(), context.method_33654(), context.method_33655(), radius);
                ++sheepPenCount;
            }
            if (context.method_33654().method_43048(80) == 0 && this.isTouchingAir((class_1936)context.method_33652(), position.method_10084())) {
                class_2586 blockEntity;
                context.method_33652().method_8652(position.method_10084(), (class_2680)IafBlocks.GOLD_PILE.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                context.method_33652().method_8652(position.method_10084().method_10095(), (class_2680)IafBlocks.GOLD_PILE.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                context.method_33652().method_8652(position.method_10084().method_10072(), (class_2680)IafBlocks.GOLD_PILE.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                context.method_33652().method_8652(position.method_10084().method_10067(), (class_2680)IafBlocks.GOLD_PILE.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                context.method_33652().method_8652(position.method_10084().method_10078(), (class_2680)IafBlocks.GOLD_PILE.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                context.method_33652().method_8652(position.method_10086(2), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (context.method_33652().method_8320(position.method_10086(2)).method_26204() instanceof class_4739 && (blockEntity = context.method_33652().method_8321(position.method_10086(2))) instanceof class_2595) {
                    class_2595 chestBlockEntity = (class_2595)blockEntity;
                    chestBlockEntity.method_11285(CYCLOPS_CHEST, context.method_33654().method_43055());
                }
            }
            if (context.method_33654().method_43048(50) != 0 || !this.isTouchingAir((class_1936)context.method_33652(), position.method_10084())) continue;
            int torchHeight = context.method_33654().method_43048(2) + 1;
            for (int fence = 0; fence < torchHeight; ++fence) {
                context.method_33652().method_8652(position.method_10086(1 + fence), this.getFenceState((class_1936)context.method_33652(), position.method_10086(1 + fence)), 3);
            }
            context.method_33652().method_8652(position.method_10086(1 + torchHeight), class_2246.field_10336.method_9564(), 2);
        }
        EntityCyclops cyclops = (EntityCyclops)IafEntities.CYCLOPS.method_5883((class_1937)context.method_33652().method_8410());
        assert (cyclops != null);
        cyclops.method_5641((double)context.method_33655().method_10263() + 0.5, (double)context.method_33655().method_10264() + 1.5, (double)context.method_33655().method_10260() + 0.5, context.method_33654().method_43057() * 360.0f, 0.0f);
        context.method_33652().method_8649((class_1297)cyclops);
        return true;
    }

    private void generateSheepPen(class_5425 level, class_2338 position, class_5819 random, class_2338 origin, float radius) {
        class_2338 relativePosition;
        int side;
        int sideCount;
        int width = 5 + random.method_43048(3);
        int sheepAmount = 2 + random.method_43048(3);
        class_2350 direction = class_2350.field_11043;
        class_2338 end = position;
        for (sideCount = 0; sideCount < 4; ++sideCount) {
            for (side = 0; side < width; ++side) {
                relativePosition = end.method_10079(direction, side);
                if (!(origin.method_10262((class_2382)relativePosition) <= (double)(radius * radius))) continue;
                level.method_8652(relativePosition, this.getFenceState((class_1936)level, relativePosition), 3);
                if (!level.method_22347(relativePosition.method_10093(direction.method_10170())) || sheepAmount <= 0) continue;
                class_2338 sheepPos = relativePosition.method_10093(direction.method_10170());
                class_1472 sheep = new class_1472(class_1299.field_6115, (class_1937)level.method_8410());
                sheep.method_5814((double)((float)sheepPos.method_10263() + 0.5f), (double)((float)sheepPos.method_10264() + 0.5f), (double)((float)sheepPos.method_10260() + 0.5f));
                sheep.method_6631(random.method_43048(4) == 0 ? class_1767.field_7947 : class_1767.field_7952);
                level.method_8649((class_1297)sheep);
                --sheepAmount;
            }
            end = end.method_10079(direction, width);
            direction = direction.method_10170();
        }
        for (sideCount = 0; sideCount < 4; ++sideCount) {
            for (side = 0; side < width; ++side) {
                relativePosition = end.method_10079(direction, side);
                if (!(origin.method_10262((class_2382)relativePosition) <= (double)(radius * radius))) continue;
                level.method_8652(relativePosition, this.getFenceState((class_1936)level, relativePosition), 3);
            }
            end = end.method_10079(direction, width);
            direction = direction.method_10170();
        }
    }

    private void generateSkeleton(class_1936 level, class_2338 position, class_5819 random, class_2338 origin, float radius) {
        class_2350 direction = HORIZONTALS[new Random().nextInt(3)];
        class_2350.class_2351 oppositeAxis = direction.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        int maxRibHeight = random.method_43048(2);
        for (int spine = 0; spine < 5 + random.method_43048(2) * 2; ++spine) {
            class_2338 segment = position.method_10079(direction, spine);
            if (origin.method_10262((class_2382)segment) <= (double)(radius * radius)) {
                level.method_8652(segment, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()), 2);
            }
            if (spine % 2 == 0) continue;
            class_2338 rightRib = segment.method_10093(direction.method_10160());
            class_2338 leftRib = segment.method_10093(direction.method_10170());
            if (origin.method_10262((class_2382)rightRib) <= (double)(radius * radius)) {
                level.method_8652(rightRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
            }
            if (origin.method_10262((class_2382)leftRib) <= (double)(radius * radius)) {
                level.method_8652(leftRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
            }
            for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                if (origin.method_10262((class_2382)rightRib.method_10086(ribHeight).method_10093(direction.method_10160())) <= (double)(radius * radius)) {
                    level.method_8652(rightRib.method_10086(ribHeight).method_10093(direction.method_10160()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
                }
                if (!(origin.method_10262((class_2382)leftRib.method_10086(ribHeight).method_10093(direction.method_10170())) <= (double)(radius * radius))) continue;
                level.method_8652(leftRib.method_10086(ribHeight).method_10093(direction.method_10170()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
            }
            if (origin.method_10262((class_2382)rightRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius)) {
                level.method_8652(rightRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
            }
            if (!(origin.method_10262((class_2382)leftRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
            level.method_8652(leftRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
        }
    }

    private boolean isTouchingAir(class_1936 level, class_2338 position) {
        boolean isTouchingAir = true;
        for (class_2350 direction : HORIZONTALS) {
            if (level.method_22347(position.method_10093(direction))) continue;
            isTouchingAir = false;
        }
        return isTouchingAir;
    }

    private class_2680 getFenceState(class_1936 level, class_2338 position) {
        boolean east = level.method_8320(position.method_10078()).method_26204() == class_2246.field_10620;
        boolean west = level.method_8320(position.method_10067()).method_26204() == class_2246.field_10620;
        boolean north = level.method_8320(position.method_10095()).method_26204() == class_2246.field_10620;
        boolean south = level.method_8320(position.method_10072()).method_26204() == class_2246.field_10620;
        return (class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2354.field_10907, (Comparable)Boolean.valueOf(east))).method_11657((class_2769)class_2354.field_10903, (Comparable)Boolean.valueOf(west))).method_11657((class_2769)class_2354.field_10905, (Comparable)Boolean.valueOf(north))).method_11657((class_2769)class_2354.field_10904, (Comparable)Boolean.valueOf(south));
    }

    @Override
    public IafWorldData.FeatureType getFeatureType() {
        return IafWorldData.FeatureType.SURFACE;
    }

    @Override
    public String getId() {
        return "cyclops_cave";
    }
}

