/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.gen;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.registry.IafFeatures;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.IafWorldData;
import com.iafenvoy.iceandfire.world.gen.TypedFeature;
import com.iafenvoy.iceandfire.world.gen.WorldGenCaveStalactites;
import com.iafenvoy.uranus.util.ShapeBuilder;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public abstract class WorldGenDragonCave
extends class_3031<class_3111>
implements TypedFeature {
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    public class_2960 DRAGON_CHEST;
    public class_2960 DRAGON_MALE_CHEST;
    public WorldGenCaveStalactites CEILING_DECO;
    public class_2680 PALETTE_BLOCK1;
    public class_2680 PALETTE_BLOCK2;
    public class_6862<class_2248> dragonTypeOreTag;
    public class_2680 TREASURE_PILE;
    public boolean isMale;

    protected WorldGenDragonCave(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 worldIn = context.method_33652();
        class_5819 rand = context.method_33654();
        class_2338 position = context.method_33655();
        if (rand.method_43058() >= (Double)IafCommonConfig.INSTANCE.dragon.generateDenChance.getValue() || !IafFeatures.isFarEnoughFromSpawn((class_1936)worldIn, position) || !IafFeatures.isFarEnoughFromDangerousGen((class_5425)worldIn, position, this.getId(), this.getFeatureType())) {
            return false;
        }
        this.isMale = rand.method_43056();
        class_1923 chunkPos = worldIn.method_22350(position).method_12004();
        int j = 40;
        for (int k = 0; k < 20; ++k) {
            for (int l = 0; l < 20; ++l) {
                j = Math.min(j, worldIn.method_8624(class_2902.class_2903.field_13195, position.method_10263() + k, position.method_10260() + l));
            }
        }
        j -= 20;
        if ((j -= rand.method_43048(30)) < worldIn.method_31607() + 20) {
            return false;
        }
        position = new class_2338((chunkPos.field_9181 << 4) + 8, j, (chunkPos.field_9180 << 4) + 8);
        int dragonAge = 75 + rand.method_43048(50);
        int radius = (int)((float)dragonAge * 0.2f) + rand.method_43048(4);
        this.generateCave((class_1936)worldIn, radius, 3, position, rand);
        EntityDragonBase dragon = this.createDragon(worldIn, rand, position, dragonAge);
        worldIn.method_8649((class_1297)dragon);
        return true;
    }

    public void generateCave(class_1936 worldIn, int radius, int amount, class_2338 center, class_5819 rand) {
        ArrayList<SphereInfo> sphereList = new ArrayList<SphereInfo>();
        sphereList.add(new SphereInfo(radius, center.method_10062()));
        Stream<class_2338> sphereBlocks = ShapeBuilder.start().getAllInCutOffSphereMutable(radius, radius / 2, center).toStream(false);
        Stream<class_2338> hollowBlocks = ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(radius - 2, (int)((double)(radius - 2) * 0.75), (radius - 2) / 2, rand, center).toStream(false);
        for (int i = 0; i < amount + rand.method_43048(2); ++i) {
            class_2350 direction = HORIZONTALS[rand.method_43048(HORIZONTALS.length - 1)];
            int r = 2 * (int)((float)radius / 3.0f) + rand.method_43048(8);
            class_2338 centerOffset = center.method_10079(direction, radius - 2);
            sphereBlocks = Stream.concat(sphereBlocks, ShapeBuilder.start().getAllInCutOffSphereMutable(r, r, centerOffset).toStream(false));
            hollowBlocks = Stream.concat(hollowBlocks, ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(r - 2, (int)((double)(r - 2) * 0.75), (r - 2) / 2, rand, centerOffset).toStream(false));
            sphereList.add(new SphereInfo(r, centerOffset));
        }
        Set<class_2338> shellBlocksSet = sphereBlocks.map(class_2338::method_10062).collect(Collectors.toSet());
        Set<class_2338> hollowBlocksSet = hollowBlocks.map(class_2338::method_10062).collect(Collectors.toSet());
        shellBlocksSet.removeAll(hollowBlocksSet);
        this.createShell(worldIn, rand, shellBlocksSet);
        this.hollowOut(worldIn, hollowBlocksSet);
        this.decorateCave(worldIn, rand, hollowBlocksSet, sphereList, center);
        sphereList.clear();
    }

    public void createShell(class_1936 worldIn, class_5819 rand, Set<class_2338> positions) {
        List<class_2248> rareOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_RARE_ORES);
        List<class_2248> uncommonOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_UNCOMMON_ORES);
        List<class_2248> commonOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_COMMON_ORES);
        List<class_2248> dragonTypeOres = this.getBlockList(this.dragonTypeOreTag);
        positions.forEach(blockPos -> {
            if (!(worldIn.method_8320(blockPos).method_26204() instanceof class_2237) && worldIn.method_8320(blockPos).method_26214((class_1922)worldIn, blockPos) >= 0.0f) {
                boolean doOres;
                boolean bl = doOres = rand.method_43058() < (Double)IafCommonConfig.INSTANCE.dragon.generateOreRatio.getValue();
                if (doOres) {
                    class_2248 toPlace = null;
                    if (rand.method_43056()) {
                        toPlace = !dragonTypeOres.isEmpty() ? (class_2248)dragonTypeOres.get(rand.method_43048(dragonTypeOres.size())) : null;
                    } else {
                        double chance = rand.method_43058();
                        if (!rareOres.isEmpty() && chance <= 0.15) {
                            toPlace = (class_2248)rareOres.get(rand.method_43048(rareOres.size()));
                        } else if (!uncommonOres.isEmpty() && chance <= 0.45) {
                            toPlace = (class_2248)uncommonOres.get(rand.method_43048(uncommonOres.size()));
                        } else if (!commonOres.isEmpty()) {
                            toPlace = (class_2248)commonOres.get(rand.method_43048(commonOres.size()));
                        }
                    }
                    if (toPlace != null) {
                        worldIn.method_8652(blockPos, toPlace.method_9564(), 2);
                    } else {
                        worldIn.method_8652(blockPos, rand.method_43056() ? this.PALETTE_BLOCK1 : this.PALETTE_BLOCK2, 2);
                    }
                } else {
                    worldIn.method_8652(blockPos, rand.method_43056() ? this.PALETTE_BLOCK1 : this.PALETTE_BLOCK2, 2);
                }
            }
        });
    }

    private List<class_2248> getBlockList(class_6862<class_2248> tagKey) {
        return class_7923.field_41175.method_40266(tagKey).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElse(Collections.emptyList());
    }

    public void hollowOut(class_1936 worldIn, Set<class_2338> positions) {
        positions.forEach(blockPos -> {
            if (!(worldIn.method_8320(blockPos).method_26204() instanceof class_2237)) {
                worldIn.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
            }
        });
    }

    public void decorateCave(class_1936 worldIn, class_5819 rand, Set<class_2338> positions, List<SphereInfo> spheres, class_2338 center) {
        for (SphereInfo sphere : spheres) {
            class_2338 pos = sphere.pos;
            int radius = sphere.radius;
            for (int i = 0; i < 15 + rand.method_43048(10); ++i) {
                this.CEILING_DECO.generate(worldIn, rand, pos.method_10086(radius / 2 - 1).method_10069(rand.method_43048(radius) - radius / 2, 0, rand.method_43048(radius) - radius / 2));
            }
        }
        positions.forEach(blockPos -> {
            class_2680 stateBelow;
            if (blockPos.method_10264() < center.method_10264() && ((stateBelow = worldIn.method_8320(blockPos.method_10074())).method_26164(class_3481.field_25806) || stateBelow.method_26164(IafBlockTags.DRAGON_ENVIRONMENT_BLOCKS)) && worldIn.method_8320(blockPos).method_26215()) {
                this.setGoldPile(worldIn, (class_2338)blockPos, rand);
            }
        });
    }

    public void setGoldPile(class_1936 world, class_2338 pos, class_5819 rand) {
        if (!(world.method_8320(pos).method_26204() instanceof class_2237)) {
            int chance = rand.method_43048(99) + 1;
            if (chance < 60) {
                boolean generateGold = rand.method_43058() < (Double)IafCommonConfig.INSTANCE.dragon.generateDenGoldChance.getValue() * (double)(this.isMale ? 1 : 2);
                world.method_8652(pos, generateGold ? (class_2680)this.TREASURE_PILE.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.method_43048(7))) : class_2246.field_10124.method_9564(), 3);
            } else if (chance == 61) {
                class_2586 blockEntity;
                world.method_8652(pos, (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)HORIZONTALS[rand.method_43048(3)]), 2);
                if (world.method_8320(pos).method_26204() instanceof class_2281 && (blockEntity = world.method_8321(pos)) instanceof class_2595) {
                    class_2595 chestBlockEntity = (class_2595)blockEntity;
                    chestBlockEntity.method_11285(this.isMale ? this.DRAGON_MALE_CHEST : this.DRAGON_CHEST, rand.method_43055());
                }
            }
        }
    }

    private EntityDragonBase createDragon(class_5281 worldGen, class_5819 random, class_2338 position, int dragonAge) {
        EntityDragonBase dragon = (EntityDragonBase)this.getDragonType().method_5883((class_1937)worldGen.method_8410());
        assert (dragon != null);
        dragon.setGender(this.isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.method_6033(dragon.method_6063());
        List<DragonColor> colors = DragonColor.getColorsByType(DragonType.getTypeByEntityType(this.getDragonType()));
        dragon.setVariant(colors.get(random.method_43048(colors.size())).name());
        dragon.method_5641((double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5, random.method_43057() * 360.0f, 0.0f);
        dragon.method_6179(true);
        dragon.homePos = new HomePosition(position, (class_1937)worldGen.method_8410());
        dragon.setHunger(50);
        return dragon;
    }

    public abstract class_1299<? extends EntityDragonBase> getDragonType();

    @Override
    public IafWorldData.FeatureType getFeatureType() {
        return IafWorldData.FeatureType.UNDERGROUND;
    }

    @Override
    public String getId() {
        return "dragon_cave";
    }

    public record SphereInfo(int radius, class_2338 pos) {
    }
}

