/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.gen;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.util.WorldUtil;
import com.iafenvoy.iceandfire.world.IafWorldData;
import com.iafenvoy.iceandfire.world.gen.TypedFeature;
import com.iafenvoy.iceandfire.world.gen.WorldGenRoostArch;
import com.iafenvoy.iceandfire.world.gen.WorldGenRoostBoulder;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2488;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public abstract class WorldGenDragonRoosts
extends class_3031<class_3111>
implements TypedFeature {
    protected static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    protected final class_2248 treasureBlock;

    public WorldGenDragonRoosts(Codec<class_3111> configuration, class_2248 treasureBlock) {
        super(configuration);
        this.treasureBlock = treasureBlock;
    }

    @Override
    public String getId() {
        return "dragon_roost";
    }

    @Override
    public IafWorldData.FeatureType getFeatureType() {
        return IafWorldData.FeatureType.SURFACE;
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5819 random = context.method_33654();
        if (!WorldUtil.canGenerate((Double)IafCommonConfig.INSTANCE.dragon.generateRoostChance.getValue(), context.method_33652(), random, context.method_33655(), this.getId(), true)) {
            return false;
        }
        boolean isMale = random.method_43056();
        int radius = 12 + context.method_33654().method_43048(8);
        this.spawnDragon(context, random, radius, isMale);
        this.generateSurface(context, radius);
        this.generateShell(context, radius);
        this.hollowOut(context, radius -= 2);
        this.generateDecoration(context, random, radius += 15, isMale);
        return true;
    }

    protected void generateRoostPile(class_5281 level, class_5819 random, class_2338 position, class_2248 block) {
        int radius = random.method_43048(4);
        for (int i = 0; i < radius; ++i) {
            int layeredRadius = radius - i;
            double circularArea = this.getCircularArea(radius);
            class_2338 up = position.method_10086(i);
            for (class_2338 blockpos : class_2338.method_20437((class_2338)up.method_10069(-layeredRadius, 0, -layeredRadius), (class_2338)up.method_10069(layeredRadius, 0, layeredRadius)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)position) <= circularArea)) continue;
                level.method_8652(blockpos, block.method_9564(), 2);
            }
        }
    }

    protected double getCircularArea(int radius, int height) {
        double area = (float)(radius + height + radius) * 0.333f + 0.5f;
        return class_3532.method_15357((double)(area * area));
    }

    protected double getCircularArea(int radius) {
        double area = (float)(radius + radius) * 0.333f + 0.5f;
        return class_3532.method_15357((double)(area * area));
    }

    protected class_2338 getSurfacePosition(class_5281 level, class_2338 position) {
        return level.method_8598(class_2902.class_2903.field_13194, position);
    }

    protected class_2680 transform(class_2248 block) {
        return this.transform(block.method_9564());
    }

    private void generateDecoration(class_5821<class_3111> context, class_5819 random, int radius, boolean isMale) {
        int height = radius / 5;
        double circularArea = this.getCircularArea(radius, height);
        class_2338.method_20437((class_2338)context.method_33655().method_10069(-radius, -height, -radius), (class_2338)context.method_33655().method_10069(radius, height, radius)).map(class_2338::method_10062).forEach(position -> {
            if (position.method_10262((class_2382)context.method_33655()) <= circularArea) {
                class_2680 transformed;
                class_2680 state;
                double distance = position.method_10262((class_2382)context.method_33655()) / circularArea;
                if (!context.method_33652().method_22347(context.method_33655()) && context.method_33654().method_43058() > distance * 0.5 && !((state = context.method_33652().method_8320(position)).method_26204() instanceof class_2237) && state.method_26214((class_1922)context.method_33652(), position) >= 0.0f && (transformed = this.transform(state)) != state) {
                    context.method_33652().method_8652(position, transformed, 2);
                }
                this.handleCustomGeneration(context, (class_2338)position, distance);
                if (distance > 0.5 && context.method_33654().method_43048(1000) == 0) {
                    new WorldGenRoostBoulder(this.transform(class_2246.field_10445).method_26204(), context.method_33654().method_43048(3), true).generate((class_1936)context.method_33652(), context.method_33654(), this.getSurfacePosition(context.method_33652(), (class_2338)position));
                }
                if (distance < 0.3 && context.method_33654().method_43048(isMale ? 200 : 300) == 0) {
                    this.generateTreasurePile(context.method_33652(), context.method_33654(), (class_2338)position);
                }
                if (distance < 0.3 && context.method_33654().method_43048(isMale ? 500 : 700) == 0) {
                    class_2586 blockEntity;
                    class_2338 surfacePosition = context.method_33652().method_8598(class_2902.class_2903.field_13202, position);
                    boolean wasPlaced = context.method_33652().method_8652(surfacePosition, (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)HORIZONTALS[random.method_43048(3)]), 2);
                    if (wasPlaced && (blockEntity = context.method_33652().method_8321(surfacePosition)) instanceof class_2595) {
                        class_2595 chest = (class_2595)blockEntity;
                        chest.method_11285(this.getRoostLootTable(), context.method_33654().method_43055());
                    }
                }
                if (context.method_33654().method_43048(5000) == 0) {
                    new WorldGenRoostArch(this.transform(class_2246.field_10445).method_26204()).generate((class_1936)context.method_33652(), context.method_33654(), this.getSurfacePosition(context.method_33652(), (class_2338)position));
                }
            }
        });
    }

    private void hollowOut(class_5821<class_3111> context, int radius) {
        int height = 2;
        double circularArea = this.getCircularArea(radius, height);
        class_2338 up = context.method_33655().method_10086(height - 1);
        class_2338.method_20437((class_2338)up.method_10069(-radius, 0, -radius), (class_2338)up.method_10069(radius, height, radius)).map(class_2338::method_10062).forEach(position -> {
            if (position.method_10262((class_2382)context.method_33655()) <= circularArea) {
                context.method_33652().method_8652(position, class_2246.field_10124.method_9564(), 2);
            }
        });
    }

    private void generateShell(class_5821<class_3111> context, int radius) {
        int height = radius / 5;
        double circularArea = this.getCircularArea(radius, height);
        class_2338.method_20437((class_2338)context.method_33655().method_10069(-radius, -height, -radius), (class_2338)context.method_33655().method_10069(radius, 1, radius)).map(class_2338::method_10062).forEach(position -> {
            if (position.method_10262((class_2382)context.method_33655()) < circularArea) {
                context.method_33652().method_8652(position, context.method_33654().method_43056() ? this.transform(class_2246.field_10255) : this.transform(class_2246.field_10566), 2);
            } else if (position.method_10262((class_2382)context.method_33655()) == circularArea) {
                context.method_33652().method_8652(position, this.transform(class_2246.field_10445), 2);
            }
        });
    }

    private void generateSurface(class_5821<class_3111> context, int radius) {
        int height = 2;
        double circularArea = this.getCircularArea(radius, height);
        class_2338.method_20437((class_2338)context.method_33655().method_10069(-radius, height, -radius), (class_2338)context.method_33655().method_10069(radius, 0, radius)).map(class_2338::method_10062).forEach(position -> {
            int heightDifference = position.method_10264() - context.method_33655().method_10264();
            if (position.method_10262((class_2382)context.method_33655()) <= circularArea && heightDifference < 2 + context.method_33654().method_43048(height) && !context.method_33652().method_22347(position.method_10074())) {
                if (context.method_33652().method_22347(position.method_10084())) {
                    context.method_33652().method_8652(position, this.transform(class_2246.field_10479), 2);
                } else {
                    context.method_33652().method_8652(position, this.transform(class_2246.field_10566), 2);
                }
            }
        });
    }

    private void generateTreasurePile(class_5281 level, class_5819 random, class_2338 origin) {
        int layers = random.method_43048(3);
        for (int i = 0; i < layers; ++i) {
            int radius = layers - i;
            double circularArea = this.getCircularArea(radius);
            for (class_2338 position : class_2338.method_20437((class_2338)origin.method_10069(-radius, i, -radius), (class_2338)origin.method_10069(radius, i, radius)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(position.method_10262((class_2382)origin) <= circularArea)) continue;
                position = level.method_8598(class_2902.class_2903.field_13202, position);
                if (!(this.treasureBlock instanceof BlockGoldPile)) continue;
                class_2680 state = level.method_8320(position);
                boolean placed = false;
                if (state.method_26215()) {
                    level.method_8652(position, (class_2680)this.treasureBlock.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + random.method_43048(7))), 2);
                    placed = true;
                } else if (state.method_26204() instanceof class_2488) {
                    level.method_8652(position.method_10074(), (class_2680)this.treasureBlock.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)((Integer)state.method_11654((class_2769)class_2488.field_11518))), 2);
                    placed = true;
                }
                if (!placed || !(level.method_8320(position.method_10074()).method_26204() instanceof BlockGoldPile)) continue;
                level.method_8652(position.method_10074(), (class_2680)this.treasureBlock.method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 2);
            }
        }
    }

    private void spawnDragon(class_5821<class_3111> context, class_5819 random, int ageOffset, boolean isMale) {
        EntityDragonBase dragon = (EntityDragonBase)this.getDragonType().method_5883((class_1937)context.method_33652().method_8410());
        assert (dragon != null);
        dragon.setGender(isMale);
        dragon.growDragon(40 + ageOffset);
        dragon.setAgingDisabled(true);
        dragon.method_6033(dragon.method_6063());
        List<DragonColor> colors = DragonColor.getColorsByType(DragonType.getTypeByEntityType(this.getDragonType()));
        dragon.setVariant(colors.get(random.method_43048(colors.size())).name());
        dragon.method_5641((double)context.method_33655().method_10263() + 0.5, (double)context.method_33652().method_8598(class_2902.class_2903.field_13194, context.method_33655()).method_10264() + 1.5, (double)context.method_33655().method_10260() + 0.5, context.method_33654().method_43057() * 360.0f, 0.0f);
        dragon.homePos = new HomePosition(context.method_33655(), (class_1937)context.method_33652().method_8410());
        dragon.hasHomePosition = true;
        dragon.setHunger(50);
        context.method_33652().method_8649((class_1297)dragon);
    }

    protected abstract class_1299<? extends EntityDragonBase> getDragonType();

    protected abstract class_2960 getRoostLootTable();

    protected abstract class_2680 transform(class_2680 var1);

    protected abstract void handleCustomGeneration(class_5821<class_3111> var1, class_2338 var2, double var3);
}

