/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.gen;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafFeatures;
import com.iafenvoy.iceandfire.world.IafWorldData;
import com.iafenvoy.iceandfire.world.gen.TypedFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2484;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6808;
import net.minecraft.class_7924;

public class WorldGenHydraCave
extends class_3031<class_3111>
implements TypedFeature {
    public static final class_2960 HYDRA_CHEST = new class_2960("iceandfire", "chest/hydra_cave");
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public WorldGenHydraCave(Codec<class_3111> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 worldIn = context.method_33652();
        class_5819 rand = context.method_33654();
        class_2338 position = context.method_33655();
        class_2794 generator = context.method_33653();
        if (rand.method_43058() >= (Double)IafCommonConfig.INSTANCE.hydra.spawnChance.getValue() || !IafFeatures.isFarEnoughFromSpawn((class_1936)worldIn, position) || !IafFeatures.isFarEnoughFromDangerousGen((class_5425)worldIn, position, this.getId())) {
            return false;
        }
        int i1 = 8;
        int i2 = i1 - 2;
        int dist = 6;
        if (worldIn.method_22347(position.method_10069(i1 - dist, -3, -i1 + dist)) || worldIn.method_22347(position.method_10069(i1 - dist, -3, i1 - dist)) || worldIn.method_22347(position.method_10069(-i1 + dist, -3, -i1 + dist)) || worldIn.method_22347(position.method_10069(-i1 + dist, -3, i1 - dist))) {
            return false;
        }
        int ySize = rand.method_43048(2);
        int j = i1 + rand.method_43048(2);
        int k = 5 + ySize;
        int l = i1 + rand.method_43048(2);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            boolean isNotInDoorway;
            boolean doorwayX = blockpos.method_10263() >= position.method_10263() - 2 + rand.method_43048(2) && blockpos.method_10263() <= position.method_10263() + 2 + rand.method_43048(2);
            boolean doorwayZ = blockpos.method_10260() >= position.method_10260() - 2 + rand.method_43048(2) && blockpos.method_10260() <= position.method_10260() + 2 + rand.method_43048(2);
            boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.method_10264() > position.method_10264() || blockpos.method_10264() > position.method_10264() + k - (1 + rand.method_43048(2));
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f))) continue;
            if (!(worldIn.method_8320(position).method_26204() instanceof class_2281) && isNotInDoorway) {
                worldIn.method_8652(blockpos, class_2246.field_10219.method_9564(), 3);
                if (worldIn.method_8320(position.method_10074()).method_26204() == class_2246.field_10219) {
                    worldIn.method_8652(blockpos.method_10074(), class_2246.field_10566.method_9564(), 3);
                }
                if (rand.method_43048(4) == 0) {
                    worldIn.method_8652(blockpos.method_10084(), class_2246.field_10479.method_9564(), 2);
                }
                if (rand.method_43048(9) == 0) {
                    context.method_33652().method_30349().method_30530(class_7924.field_41239).method_40264(class_6808.field_35919).ifPresent(holder -> ((class_2975)holder.comp_349()).method_12862(worldIn, generator, rand, blockpos.method_10084()));
                }
            }
            if (blockpos.method_10264() == position.method_10264()) {
                worldIn.method_8652(blockpos, class_2246.field_10219.method_9564(), 3);
            }
            if (blockpos.method_10264() > position.method_10264() - 1 || worldIn.method_8320(blockpos).method_26225()) continue;
            worldIn.method_8652(blockpos, class_2246.field_10340.method_9564(), 3);
        }
        ySize = rand.method_43048(2);
        j = i2 + rand.method_43048(2);
        k = 4 + ySize;
        l = i2 + rand.method_43048(2);
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f)) || blockpos.method_10264() <= position.method_10264() || worldIn.method_8320(position).method_26204() instanceof class_2281) continue;
            worldIn.method_8652(blockpos, class_2246.field_10124.method_9564(), 3);
        }
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k + 8, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f)) || blockpos.method_10264() != position.method_10264()) continue;
            if (rand.method_43048(30) == 0 && this.isTouchingAir((class_1936)worldIn, blockpos.method_10084())) {
                class_2586 tileentity1;
                worldIn.method_8652(blockpos.method_10086(1), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (!(worldIn.method_8320(blockpos.method_10086(1)).method_26204() instanceof class_2281) || !((tileentity1 = worldIn.method_8321(blockpos.method_10086(1))) instanceof class_2595)) continue;
                ((class_2595)tileentity1).method_11285(HYDRA_CHEST, rand.method_43055());
                continue;
            }
            if (rand.method_43048(45) == 0 && this.isTouchingAir((class_1936)worldIn, blockpos.method_10084())) {
                worldIn.method_8652(blockpos.method_10084(), (class_2680)class_2246.field_10481.method_9564().method_11657((class_2769)class_2484.field_11505, (Comparable)Integer.valueOf(rand.method_43048(15))), 2);
                continue;
            }
            if (rand.method_43048(35) == 0 && this.isTouchingAir((class_1936)worldIn, blockpos.method_10084())) {
                worldIn.method_8652(blockpos.method_10084(), (class_2680)class_2246.field_10503.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)), 2);
                for (class_2350 facing : class_2350.values()) {
                    if (!(rand.method_43057() < 0.3f) || facing == class_2350.field_11033) continue;
                    worldIn.method_8652(blockpos.method_10084().method_10093(facing), class_2246.field_10503.method_9564(), 2);
                }
                continue;
            }
            if (rand.method_43048(15) == 0 && this.isTouchingAir((class_1936)worldIn, blockpos.method_10084())) {
                worldIn.method_8652(blockpos.method_10084(), class_2246.field_10214.method_9564(), 2);
                continue;
            }
            if (rand.method_43048(15) != 0 || !this.isTouchingAir((class_1936)worldIn, blockpos.method_10084())) continue;
            worldIn.method_8652(blockpos.method_10084(), rand.method_43056() ? class_2246.field_10251.method_9564() : class_2246.field_10559.method_9564(), 2);
        }
        EntityHydra hydra = new EntityHydra(IafEntities.HYDRA, (class_1937)worldIn.method_8410());
        hydra.setVariant(rand.method_43048(3));
        hydra.method_18408(position, 15);
        hydra.method_5641((double)position.method_10263() + 0.5, (double)position.method_10264() + 1.5, (double)position.method_10260() + 0.5, rand.method_43057() * 360.0f, 0.0f);
        worldIn.method_8649((class_1297)hydra);
        return true;
    }

    private boolean isTouchingAir(class_1936 worldIn, class_2338 pos) {
        boolean isTouchingAir = true;
        for (class_2350 direction : HORIZONTALS) {
            if (worldIn.method_22347(pos.method_10093(direction))) continue;
            isTouchingAir = false;
        }
        return isTouchingAir;
    }

    @Override
    public IafWorldData.FeatureType getFeatureType() {
        return IafWorldData.FeatureType.SURFACE;
    }

    @Override
    public String getId() {
        return "hydra_cave";
    }
}

