/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.gen;

import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import java.util.stream.Collectors;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public class WorldGenMyrmexDecoration {
    public static final class_2960 MYRMEX_GOLD_CHEST = new class_2960("iceandfire", "chest/myrmex_loot_chest");
    public static final class_2960 DESERT_MYRMEX_FOOD_CHEST = new class_2960("iceandfire", "chest/myrmex_desert_food_chest");
    public static final class_2960 JUNGLE_MYRMEX_FOOD_CHEST = new class_2960("iceandfire", "chest/myrmex_jungle_food_chest");
    public static final class_2960 MYRMEX_TRASH_CHEST = new class_2960("iceandfire", "chest/myrmex_trash_chest");
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public static void generateSkeleton(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
        if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
            class_2350 direction = class_2350.method_10139((int)rand.method_43048(3));
            class_2350.class_2351 oppositeAxis = direction.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
            int maxRibHeight = rand.method_43048(2);
            for (int spine = 0; spine < 5 + rand.method_43048(2) * 2; ++spine) {
                class_2338 segment = blockpos.method_10079(direction, spine);
                if (origin.method_10262((class_2382)segment) <= (double)(radius * radius)) {
                    worldIn.method_8652(segment, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()), 2);
                }
                if (spine % 2 == 0) continue;
                class_2338 rightRib = segment.method_10093(direction.method_10160());
                class_2338 leftRib = segment.method_10093(direction.method_10170());
                if (origin.method_10262((class_2382)rightRib) <= (double)(radius * radius)) {
                    worldIn.method_8652(rightRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                }
                if (origin.method_10262((class_2382)leftRib) <= (double)(radius * radius)) {
                    worldIn.method_8652(leftRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                }
                for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                    if (origin.method_10262((class_2382)rightRib.method_10086(ribHeight).method_10093(direction.method_10160())) <= (double)(radius * radius)) {
                        worldIn.method_8652(rightRib.method_10086(ribHeight).method_10093(direction.method_10160()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
                    }
                    if (!(origin.method_10262((class_2382)leftRib.method_10086(ribHeight).method_10093(direction.method_10170())) <= (double)(radius * radius))) continue;
                    worldIn.method_8652(leftRib.method_10086(ribHeight).method_10093(direction.method_10170()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
                }
                if (origin.method_10262((class_2382)rightRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius)) {
                    worldIn.method_8652(rightRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                }
                if (!(origin.method_10262((class_2382)leftRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                worldIn.method_8652(leftRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
            }
        }
    }

    public static void generateLeaves(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand, boolean jungle) {
        if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
            class_2680 leaf = (class_2680)class_2246.field_10503.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.TRUE);
            if (jungle) {
                leaf = (class_2680)class_2246.field_10335.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.TRUE);
            }
            int i1 = 0;
            for (int i = 0; i < 3; ++i) {
                int j = i1 + rand.method_43048(2);
                int k = i1 + rand.method_43048(2);
                int l = i1 + rand.method_43048(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (class_2338 pos : class_2338.method_20437((class_2338)blockpos.method_10069(-j, -k, -l), (class_2338)blockpos.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                    if (!(pos.method_10262((class_2382)blockpos) <= (double)(f * f)) || !worldIn.method_22347(pos)) continue;
                    worldIn.method_8652(pos, leaf, 4);
                }
                blockpos = blockpos.method_10069(-(i1 + 1) + rand.method_43048(2), -rand.method_43048(2), -(i1 + 1) + rand.method_43048(2));
            }
        }
    }

    public static void generatePumpkins(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand, boolean jungle) {
        if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
            worldIn.method_8652(blockpos, jungle ? class_2246.field_10545.method_9564() : class_2246.field_10261.method_9564(), 2);
        }
    }

    public static void generateCocoon(class_1936 worldIn, class_2338 blockpos, class_5819 rand, boolean jungle, class_2960 lootTable) {
        if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
            worldIn.method_8652(blockpos, jungle ? IafBlocks.JUNGLE_MYRMEX_COCOON.method_9564() : IafBlocks.DESERT_MYRMEX_COCOON.method_9564(), 3);
            if (worldIn.method_8321(blockpos) != null && worldIn.method_8321(blockpos) instanceof class_2621) {
                class_2586 tileentity1 = worldIn.method_8321(blockpos);
                assert (tileentity1 != null);
                ((class_2621)tileentity1).method_11285(lootTable, rand.method_43055());
            }
        }
    }

    public static void generateMushrooms(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
        if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
            worldIn.method_8652(blockpos, rand.method_43056() ? class_2246.field_10251.method_9564() : class_2246.field_10559.method_9564(), 2);
        }
    }

    public static void generateGold(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
        class_2680 gold = IafBlocks.GOLD_PILE.method_9564();
        int choice = rand.method_43048(2);
        if (choice == 1) {
            gold = IafBlocks.SILVER_PILE.method_9564();
        } else if (choice == 2) {
            gold = IafBlocks.COPPER_PILE.method_9564();
        }
        if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
            worldIn.method_8652(blockpos, (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
            worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10095()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
            worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10072()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
            worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10067()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
            worldIn.method_8652(MyrmexHive.getGroundedPos(worldIn, blockpos.method_10078()), (class_2680)gold.method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + class_5819.method_43047().method_43048(7))), 3);
            if (rand.method_43048(3) == 0) {
                class_2586 tileentity1;
                worldIn.method_8652(blockpos.method_10084(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)HORIZONTALS[class_5819.method_43047().method_43048(3)]), 2);
                if (worldIn.method_8320(blockpos.method_10084()).method_26204() instanceof class_2281 && (tileentity1 = worldIn.method_8321(blockpos.method_10084())) instanceof class_2595) {
                    ((class_2595)tileentity1).method_11285(MYRMEX_GOLD_CHEST, rand.method_43055());
                }
            }
        }
    }

    public static void generateTrashHeap(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
        if (worldIn.method_8320(blockpos.method_10074()).method_26206((class_1922)worldIn, blockpos.method_10074(), class_2350.field_11036)) {
            class_2248 blob = switch (rand.method_43048(3)) {
                case 0 -> class_2246.field_10566;
                case 1 -> class_2246.field_10102;
                case 2 -> class_2246.field_10445;
                case 3 -> class_2246.field_10255;
                default -> class_2246.field_10124;
            };
            int i1 = 0;
            for (int i = 0; i < 3; ++i) {
                int j = i1 + rand.method_43048(2);
                int k = i1 + rand.method_43048(2);
                int l = i1 + rand.method_43048(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (class_2338 pos : class_2338.method_20437((class_2338)blockpos.method_10069(-j, -k, -l), (class_2338)blockpos.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                    if (!(pos.method_10262((class_2382)blockpos) <= (double)(f * f))) continue;
                    worldIn.method_8652(pos, blob.method_9564(), 4);
                }
                blockpos = blockpos.method_10069(-(i1 + 1) + rand.method_43048(2), -rand.method_43048(2), -(i1 + 1) + rand.method_43048(2));
            }
        }
    }

    public static void generateTrashOre(class_1936 worldIn, class_2338 blockpos, class_2338 origin, int radius, class_5819 rand) {
        class_2248 current = worldIn.method_8320(blockpos).method_26204();
        if (origin.method_10262((class_2382)blockpos) <= (double)(radius * radius) && (current == class_2246.field_10566 || current == class_2246.field_10102 || current == class_2246.field_10445 || current == class_2246.field_10255)) {
            class_2248 ore = class_2246.field_10080;
            if (rand.method_43048(3) == 0) {
                class_2248 class_22482 = ore = rand.method_43056() ? class_2246.field_10571 : IafBlocks.SILVER_ORE;
                if (rand.method_43048(2) == 0) {
                    ore = class_2246.field_27120;
                }
            } else if (rand.method_43048(3) == 0) {
                ore = class_2246.field_10442;
            } else if (rand.method_43048(2) == 0) {
                class_2248 class_22483 = ore = rand.method_43056() ? class_2246.field_10013 : IafBlocks.SAPPHIRE_ORE;
                if (rand.method_43048(2) == 0) {
                    ore = class_2246.field_27161;
                }
            }
            worldIn.method_8652(blockpos, ore.method_9564(), 2);
        }
    }
}

