/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.gen;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexQueen;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSentinel;
import com.iafenvoy.iceandfire.entity.EntityMyrmexSoldier;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexBiolight;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexConnectedResin;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexResin;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafFeatures;
import com.iafenvoy.iceandfire.world.IafWorldData;
import com.iafenvoy.iceandfire.world.MyrmexWorldData;
import com.iafenvoy.iceandfire.world.gen.TypedFeature;
import com.iafenvoy.iceandfire.world.gen.WorldGenMyrmexDecoration;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class WorldGenMyrmexHive
extends class_3031<class_3111>
implements TypedFeature {
    private static final class_2680 DESERT_RESIN = IafBlocks.MYRMEX_DESERT_RESIN.method_9564();
    private static final class_2680 STICKY_DESERT_RESIN = IafBlocks.MYRMEX_DESERT_RESIN_STICKY.method_9564();
    private static final class_2680 JUNGLE_RESIN = IafBlocks.MYRMEX_JUNGLE_RESIN.method_9564();
    private static final class_2680 STICKY_JUNGLE_RESIN = IafBlocks.MYRMEX_JUNGLE_RESIN_STICKY.method_9564();
    private final boolean jungle;
    public MyrmexHive hive;
    private int entrances = 0;
    private int totalRooms;
    private boolean hasFoodRoom;
    private boolean hasNursery;
    private boolean small;
    private class_2338 centerOfHive;

    public WorldGenMyrmexHive(boolean small, boolean jungle, Codec<class_3111> configFactoryIn) {
        super(configFactoryIn);
        this.small = small;
        this.jungle = jungle;
    }

    public void placeSmallGen(class_5281 worldIn, class_5819 rand, class_2338 pos) {
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        this.entrances = 0;
        this.centerOfHive = pos;
        this.generateMainRoom((class_5425)worldIn, rand, pos);
        this.small = false;
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 worldIn = context.method_33652();
        class_5819 rand = context.method_33654();
        class_2338 pos = context.method_33655();
        if (!this.small) {
            if (rand.method_43058() < (Double)IafCommonConfig.INSTANCE.myrmex.colonyGenChance.getValue() || !IafFeatures.isFarEnoughFromSpawn((class_1936)worldIn, pos) || !IafFeatures.isFarEnoughFromDangerousGen((class_5425)worldIn, pos, this.getId())) {
                return false;
            }
            if (MyrmexWorldData.get((class_1937)worldIn.method_8410()) != null && MyrmexWorldData.get((class_1937)worldIn.method_8410()).getNearestHive(pos, 200) != null) {
                return false;
            }
        }
        if (!this.small && !worldIn.method_8316(pos.method_10074()).method_15769()) {
            return false;
        }
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        int down = Math.max(15, pos.method_10264() - 20 + rand.method_43048(10));
        class_2338 undergroundPos = new class_2338(pos.method_10263(), down, pos.method_10260());
        this.entrances = 0;
        this.centerOfHive = undergroundPos;
        this.generateMainRoom((class_5425)worldIn, rand, undergroundPos);
        this.small = false;
        return true;
    }

    private void generateMainRoom(class_5425 world, class_5819 rand, class_2338 position) {
        this.hive = new MyrmexHive((class_1937)world.method_8410(), position, 100);
        MyrmexWorldData.addHive((class_1937)world.method_8410(), this.hive);
        class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphere((class_1936)world, rand, position, 14, 7, resin, sticky_resin);
        this.generateSphere((class_1936)world, rand, position, 12, 5, class_2246.field_10124.method_9564());
        this.decorateSphere((class_1936)world, rand, position, 12, 5, RoomType.QUEEN);
        this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11043, 9).method_10074(), 15 + rand.method_43048(10), class_2350.field_11043, 100);
        this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11035, 9).method_10074(), 15 + rand.method_43048(10), class_2350.field_11035, 100);
        this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11039, 9).method_10074(), 15 + rand.method_43048(10), class_2350.field_11039, 100);
        this.generatePath((class_1936)world, rand, position.method_10079(class_2350.field_11034, 9).method_10074(), 15 + rand.method_43048(10), class_2350.field_11034, 100);
        if (!this.small) {
            EntityMyrmexBase myrmex;
            int i;
            EntityMyrmexQueen queen = new EntityMyrmexQueen(IafEntities.MYRMEX_QUEEN, (class_1937)world.method_8410());
            class_2338 ground = MyrmexHive.getGroundedPos((class_1936)world, position);
            queen.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
            queen.setHive(this.hive);
            queen.setJungleVariant(this.jungle);
            queen.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
            world.method_8649((class_1297)queen);
            for (i = 0; i < 4 + rand.method_43048(3); ++i) {
                myrmex = new EntityMyrmexWorker(IafEntities.MYRMEX_WORKER, (class_1937)world.method_8410());
                myrmex.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
                myrmex.setHive(this.hive);
                myrmex.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.method_8649((class_1297)myrmex);
            }
            for (i = 0; i < 2 + rand.method_43048(2); ++i) {
                myrmex = new EntityMyrmexSoldier(IafEntities.MYRMEX_SOLDIER, (class_1937)world.method_8410());
                myrmex.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
                myrmex.setHive(this.hive);
                myrmex.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.method_8649((class_1297)myrmex);
            }
            for (i = 0; i < rand.method_43048(2); ++i) {
                myrmex = new EntityMyrmexSentinel((class_1299)IafEntities.MYRMEX_SENTINEL, (class_1937)world.method_8410());
                myrmex.method_5943(world, world.method_8404(ground), class_3730.field_16472, null, null);
                myrmex.setHive(this.hive);
                myrmex.method_5641((double)ground.method_10263() + 0.5, (double)ground.method_10264() + 1.0, (double)ground.method_10260() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.method_8649((class_1297)myrmex);
            }
        }
    }

    private void generatePath(class_1936 world, class_5819 rand, class_2338 offset, int length, class_2350 direction, int roomChance) {
        if (roomChance == 0) {
            return;
        }
        if (this.small) {
            length /= 2;
            if (this.entrances < 1) {
                for (int i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.method_10079(direction, i), direction);
                }
                this.generateEntrance(world, rand, offset.method_10079(direction, length), direction);
            } else if (this.totalRooms < 2) {
                int i;
                for (i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.method_10079(direction, i), direction);
                }
                this.generateRoom(world, rand, offset.method_10079(direction, length), 6, roomChance / 2, direction);
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, offset.method_10079(direction, i), direction);
                    this.generateCircleAir(world, rand, offset.method_10079(direction, length + i), direction);
                }
                ++this.totalRooms;
            }
        } else if (rand.method_43048(100) < roomChance) {
            if (this.entrances < 3 && rand.method_43048(1 + this.entrances * 2) == 0 && this.hasFoodRoom && this.hasNursery && this.totalRooms > 3 || this.entrances == 0) {
                this.generateEntrance(world, rand, offset.method_10079(direction, 1), direction);
            } else {
                int i;
                for (i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.method_10079(direction, i), direction);
                }
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, offset.method_10079(direction, length + i), direction);
                }
                ++this.totalRooms;
                this.generateRoom(world, rand, offset.method_10079(direction, length), 7, roomChance / 2, direction);
            }
        }
    }

    private void generateRoom(class_1936 world, class_5819 rand, class_2338 position, int size, int roomChance, class_2350 direction) {
        class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        RoomType type = RoomType.random(rand);
        if (!this.hasFoodRoom) {
            type = RoomType.FOOD;
            this.hasFoodRoom = true;
        } else if (!this.hasNursery) {
            type = RoomType.NURSERY;
            this.hasNursery = true;
        }
        this.generateSphereRespectResin(world, rand, position, size + 2, 6, resin, sticky_resin);
        this.generateSphere(world, rand, position, size, 3, class_2246.field_10124.method_9564());
        this.decorateSphere(world, rand, position, size, 3, type);
        this.hive.addRoom(position, type);
        if (!this.small) {
            if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11043) {
                this.generatePath(world, rand, position.method_10079(class_2350.field_11043, size - 2), 5 + rand.method_43048(20), class_2350.field_11043, roomChance);
            }
            if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11035) {
                this.generatePath(world, rand, position.method_10079(class_2350.field_11035, size - 2), 5 + rand.method_43048(20), class_2350.field_11035, roomChance);
            }
            if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11039) {
                this.generatePath(world, rand, position.method_10079(class_2350.field_11039, size - 2), 5 + rand.method_43048(20), class_2350.field_11039, roomChance);
            }
            if (rand.method_43048(3) == 0 && direction.method_10153() != class_2350.field_11034) {
                this.generatePath(world, rand, position.method_10079(class_2350.field_11034, size - 2), 5 + rand.method_43048(20), class_2350.field_11034, roomChance);
            }
        }
    }

    private void generateEntrance(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
        class_2338 up = position.method_10084();
        this.hive.getEntranceBottoms().put(up, direction);
        while (up.method_10264() < world.method_8598(this.small ? class_2902.class_2903.field_13203 : class_2902.class_2903.field_13194, up).method_10264() && !world.method_8320(up).method_26164(class_3481.field_15475)) {
            this.generateCircleRespectSky(world, rand, up, direction);
            up = up.method_10084().method_10093(direction);
        }
        class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphereRespectAir(world, rand, up, 8, 6, resin, sticky_resin);
        this.generateSphere(world, rand, up.method_10084(), 4, 4, class_2246.field_10124.method_9564());
        this.decorateSphere(world, rand, up.method_10084(), 4, 3, RoomType.ENTERANCE);
        this.hive.getEntrances().put(up, direction);
        ++this.entrances;
    }

    private void generateCircle(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
        int z;
        int x;
        float j;
        float i;
        class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = 5;
        for (i = 0.0f; i < (float)radius; i += 0.5f) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(class_3532.method_15374((float)j) * i);
                z = (int)Math.floor(class_3532.method_15362((float)j) * i);
                if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                    world.method_8652(position.method_10069(0, x, z), rand.method_43048(3) == 0 ? sticky_resin : resin, 2);
                } else {
                    world.method_8652(position.method_10069(x, z, 0), rand.method_43048(3) == 0 ? sticky_resin : resin, 2);
                }
                j += 0.5f;
            }
        }
        radius -= 2;
        for (i = 0.0f; i < (float)radius; i += 0.5f) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(class_3532.method_15374((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(class_3532.method_15362((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                    world.method_8652(position.method_10069(0, x, z), class_2246.field_10124.method_9564(), 2);
                } else {
                    world.method_8652(position.method_10069(x, z, 0), class_2246.field_10124.method_9564(), 2);
                }
                j += 0.5f;
            }
        }
        this.decorateCircle(world, rand, position, 3, 5, direction);
    }

    private void generateCircleRespectSky(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
        int z;
        int x;
        float j;
        float i;
        class_2680 resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        class_2680 sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = 6;
        for (i = 0.0f; i < (float)radius; i += 0.5f) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(class_3532.method_15374((float)j) * i);
                z = (int)Math.floor(class_3532.method_15362((float)j) * i);
                if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                    if (!world.method_22348(position.method_10069(0, x, z))) {
                        world.method_8652(position.method_10069(0, x, z), rand.method_43048(3) == 0 ? sticky_resin : resin, 3);
                    }
                } else if (!world.method_22348(position.method_10069(x, z, 0))) {
                    world.method_8652(position.method_10069(x, z, 0), rand.method_43048(3) == 0 ? sticky_resin : resin, 3);
                }
                j += 0.5f;
            }
        }
        radius -= 2;
        for (i = 0.0f; i < (float)radius; i += 0.5f) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(class_3532.method_15374((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(class_3532.method_15362((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                    world.method_8652(position.method_10069(0, x, z), class_2246.field_10124.method_9564(), 3);
                } else {
                    world.method_8652(position.method_10069(x, z, 0), class_2246.field_10124.method_9564(), 3);
                }
                j += 0.5f;
            }
        }
        this.decorateCircle(world, rand, position, 4, 4, direction);
    }

    private void generateCircleAir(class_1936 world, class_5819 rand, class_2338 position, class_2350 direction) {
        for (float i = 0.0f; i < 3.0f; i += 0.5f) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(class_3532.method_15374((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                int z = (int)Math.floor(class_3532.method_15362((float)j) * i * class_3532.method_15363((float)rand.method_43057(), (float)0.5f, (float)1.0f));
                if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                    world.method_8652(position.method_10069(0, x, z), class_2246.field_10124.method_9564(), 2);
                } else {
                    world.method_8652(position.method_10069(x, z, 0), class_2246.field_10124.method_9564(), 2);
                }
                j += 0.5f;
            }
        }
        this.decorateCircle(world, rand, position, 3, 5, direction);
    }

    public void generateSphere(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill) {
        int ySize = rand.method_43048(2);
        int j = size + rand.method_43048(2);
        int k = height + ySize;
        int l = size + rand.method_43048(2);
        float f = (float)(j + k + l) * 0.333f;
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f))) || world.method_22347(blockpos)) continue;
            world.method_8652(blockpos, fill, 3);
        }
    }

    public void generateSphere(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill, class_2680 fill2) {
        int ySize = rand.method_43048(2);
        int j = size + rand.method_43048(2);
        int k = height + ySize;
        int l = size + rand.method_43048(2);
        float f = (float)(j + k + l) * 0.333f;
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f)))) continue;
            world.method_8652(blockpos, rand.method_43048(3) == 0 ? fill2 : fill, 2);
        }
    }

    public void generateSphereRespectResin(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill, class_2680 fill2) {
        int ySize = rand.method_43048(2);
        int j = size + rand.method_43048(2);
        int k = height + ySize;
        int l = size + rand.method_43048(2);
        float f = (float)(j + k + l) * 0.333f;
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f))) || world.method_22347(blockpos) && (!world.method_22347(blockpos) || this.hasResinUnder(blockpos, world))) continue;
            world.method_8652(blockpos, rand.method_43048(3) == 0 ? fill2 : fill, 2);
        }
    }

    public void generateSphereRespectAir(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2680 fill, class_2680 fill2) {
        int ySize = rand.method_43048(2);
        int j = size + rand.method_43048(2);
        int k = height + ySize;
        int l = size + rand.method_43048(2);
        float f = (float)(j + k + l) * 0.333f;
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f * class_3532.method_15363((float)rand.method_43057(), (float)0.75f, (float)1.0f))) || world.method_22347(blockpos)) continue;
            world.method_8652(blockpos, rand.method_43048(3) == 0 ? fill2 : fill, 2);
        }
    }

    private boolean hasResinUnder(class_2338 pos, class_1936 world) {
        class_2338 copy = pos.method_10074();
        while (world.method_22347(copy) && copy.method_10264() > 1) {
            copy = copy.method_10074();
        }
        return world.method_8320(copy).method_26204() instanceof BlockMyrmexResin || world.method_8320(copy).method_26204() instanceof BlockMyrmexConnectedResin;
    }

    private void decorateCircle(class_1936 world, class_5819 rand, class_2338 position, int size, int height, class_2350 direction) {
        int radius = size + 2;
        for (float i = 0.0f; i < (float)radius; i += 0.5f) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(class_3532.method_15374((float)j) * i);
                int z = (int)Math.floor(class_3532.method_15362((float)j) * i);
                if (direction == class_2350.field_11039 || direction == class_2350.field_11034) {
                    if (world.method_22347(position.method_10069(0, x, z))) {
                        this.decorate(world, position.method_10069(0, x, z), position, size, rand, RoomType.TUNNEL);
                    }
                } else if (world.method_22347(position.method_10069(x, z, 0))) {
                    this.decorate(world, position.method_10069(x, z, 0), position, size, rand, RoomType.TUNNEL);
                }
                if (world.method_22347(position.method_10069(0, x, z))) {
                    this.decorateTubers(world, position.method_10069(0, x, z), rand, RoomType.TUNNEL);
                }
                j += 0.5f;
            }
        }
    }

    private void decorateSphere(class_1936 world, class_5819 rand, class_2338 position, int size, int height, RoomType roomType) {
        int ySize = rand.method_43048(2);
        int j = size + rand.method_43048(2);
        int k = height + ySize;
        int l = size + rand.method_43048(2);
        float f = (float)(j + k + l) * 0.333f;
        for (class_2338 blockpos : class_2338.method_20437((class_2338)position.method_10069(-j, -k, -l), (class_2338)position.method_10069(j, k + 1, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
            if (!(blockpos.method_10262((class_2382)position) <= (double)(f * f))) continue;
            if (world.method_8320(blockpos.method_10074()).method_26225() && world.method_22347(blockpos)) {
                this.decorate(world, blockpos, position, size, rand, roomType);
            }
            if (!world.method_22347(blockpos)) continue;
            this.decorateTubers(world, blockpos, rand, roomType);
        }
    }

    private void decorate(class_1936 world, class_2338 blockpos, class_2338 center, int size, class_5819 random, RoomType roomType) {
        switch (roomType) {
            case FOOD: {
                if (random.method_43048(45) == 0 && world.method_8320(blockpos.method_10074()).method_26204() instanceof BlockMyrmexResin) {
                    WorldGenMyrmexDecoration.generateSkeleton(world, blockpos, center, size, random);
                }
                if (random.method_43048(13) == 0) {
                    WorldGenMyrmexDecoration.generateLeaves(world, blockpos, center, size, random, this.jungle);
                }
                if (random.method_43048(12) == 0) {
                    WorldGenMyrmexDecoration.generatePumpkins(world, blockpos, center, size, random, this.jungle);
                }
                if (random.method_43048(6) == 0) {
                    WorldGenMyrmexDecoration.generateMushrooms(world, blockpos, center, size, random);
                }
                if (random.method_43048(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, this.jungle ? WorldGenMyrmexDecoration.JUNGLE_MYRMEX_FOOD_CHEST : WorldGenMyrmexDecoration.DESERT_MYRMEX_FOOD_CHEST);
                break;
            }
            case SHINY: {
                if (random.method_43048(12) != 0) break;
                WorldGenMyrmexDecoration.generateGold(world, blockpos, center, size, random);
                break;
            }
            case TRASH: {
                if (random.method_43048(24) == 0) {
                    WorldGenMyrmexDecoration.generateTrashHeap(world, blockpos, center, size, random);
                }
                if (random.method_43056()) {
                    WorldGenMyrmexDecoration.generateTrashOre(world, blockpos, center, size, random);
                }
                if (random.method_43048(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, WorldGenMyrmexDecoration.MYRMEX_TRASH_CHEST);
                break;
            }
        }
    }

    private void decorateTubers(class_1936 world, class_2338 blockpos, class_5819 random, RoomType roomType) {
        if (world.method_8320(blockpos.method_10084()).method_26225() && random.method_43048(roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 20 : 6) == 0) {
            int tuberLength = roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 1 : (roomType == RoomType.QUEEN ? 1 + random.method_43048(5) : 1 + random.method_43048(3));
            for (int i = 0; i < tuberLength; ++i) {
                if (!world.method_22347(blockpos.method_10087(i))) continue;
                boolean connected = i != tuberLength - 1;
                world.method_8652(blockpos.method_10087(i), this.jungle ? (class_2680)IafBlocks.MYRMEX_JUNGLE_BIOLIGHT.method_9564().method_11657((class_2769)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)) : (class_2680)IafBlocks.MYRMEX_DESERT_BIOLIGHT.method_9564().method_11657((class_2769)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)), 2);
            }
        }
    }

    @Override
    public IafWorldData.FeatureType getFeatureType() {
        return IafWorldData.FeatureType.SURFACE;
    }

    @Override
    public String getId() {
        return "myrmex_hive";
    }

    public static enum RoomType {
        DEFAULT(false),
        TUNNEL(false),
        ENTERANCE(false),
        QUEEN(false),
        FOOD(true),
        EMPTY(true),
        NURSERY(true),
        SHINY(true),
        TRASH(true);

        final boolean random;

        private RoomType(boolean random) {
            this.random = random;
        }

        public static RoomType random(class_5819 rand) {
            ArrayList<RoomType> list = new ArrayList<RoomType>();
            for (RoomType type : RoomType.values()) {
                if (!type.random) continue;
                list.add(type);
            }
            return (RoomType)((Object)list.get(rand.method_43048(list.size())));
        }
    }
}

