/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import com.iafenvoy.iceandfire.world.structure.IafStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class GraveyardStructure
extends IafStructure {
    public static final Codec<GraveyardStructure> ENTRY_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GraveyardStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, GraveyardStructure::new)).codec();

    public GraveyardStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter);
    }

    @Override
    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 pContext) {
        if (!((Boolean)IafCommonConfig.INSTANCE.ghost.generateGraveyards.getValue()).booleanValue()) {
            return Optional.empty();
        }
        class_2338 blockpos = pContext.comp_568().method_33943(1);
        if (this.biomeIsIn(pContext, IafBiomeTags.NO_GRAVEYARD, blockpos)) {
            return Optional.empty();
        }
        return class_3778.method_30419((class_3195.class_7149)pContext, (class_6880)this.startPool, (Optional)this.startJigsawName, (int)this.size, (class_2338)blockpos, (boolean)false, (Optional)this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    @Override
    public class_7151<?> method_41618() {
        return IafStructureTypes.GRAVEYARD;
    }
}

