/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.revelationary.compat.jei;

import de.dafuqs.revelationary.api.revelations.CloakSetChanged;
import de.dafuqs.revelationary.config.RevelationaryConfig;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class RevelationaryJEIPlugin
implements IModPlugin {
    private IJeiRuntime runtime;
    private Set<class_1792> stacksCache;

    public RevelationaryJEIPlugin() {
        if (!RevelationaryConfig.get().HideCloakedEntriesFromRecipeViewers) {
            return;
        }
        if (FabricLoader.getInstance().isModLoaded("emi")) {
            return;
        }
        CloakSetChanged.EVENT.register((added, removed, newStacks) -> {
            this.stacksCache = newStacks;
            if (this.runtime != null) {
                IIngredientManager manager = this.runtime.getIngredientManager();
                if (added != null && !added.isEmpty()) {
                    manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)added.stream().map(class_1799::new).collect(Collectors.toList()));
                }
                if (removed != null && !removed.isEmpty()) {
                    manager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)removed.stream().map(class_1799::new).collect(Collectors.toList()));
                }
            }
        });
    }

    @NotNull
    public class_2960 getPluginUid() {
        return new class_2960("revelationary", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.runtime = jeiRuntime;
        if (!RevelationaryConfig.get().HideCloakedEntriesFromRecipeViewers) {
            return;
        }
        if (this.stacksCache != null && !this.stacksCache.isEmpty()) {
            this.runtime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)this.stacksCache.stream().map(class_1799::new).collect(Collectors.toList()));
        }
    }

    public void onRuntimeUnavailable() {
        this.runtime = null;
    }
}

