/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.core.object.DataTicket;
import mod.azure.azurelibarmor.network.SerializableDataTicket;
import mod.azure.azurelibarmor.util.AzureLibUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public final class DataTickets {
    private static final Map<String, SerializableDataTicket<?>> SERIALIZABLE_TICKETS = new ConcurrentHashMap();
    public static final DataTicket<class_1799> ITEMSTACK = new DataTicket<class_1799>("itemstack", class_1799.class);
    public static final DataTicket<class_1297> ENTITY = new DataTicket<class_1297>("entity", class_1297.class);
    public static final DataTicket<class_1304> EQUIPMENT_SLOT = new DataTicket<class_1304>("equipment_slot", class_1304.class);
    public static final DataTicket<Double> TICK = new DataTicket<Double>("tick", Double.class);
    public static final DataTicket<class_811> ITEM_RENDER_PERSPECTIVE = new DataTicket<class_811>("item_render_perspective", class_811.class);
    public static final SerializableDataTicket<Integer> ANIM_STATE = AzureLibUtil.addDataTicket(SerializableDataTicket.ofInt(new class_2960("azurelibarmor", "anim_state")));
    public static final SerializableDataTicket<String> ANIM = AzureLibUtil.addDataTicket(SerializableDataTicket.ofString(new class_2960("azurelibarmor", "anim")));
    public static final SerializableDataTicket<Integer> USE_TICKS = AzureLibUtil.addDataTicket(SerializableDataTicket.ofInt(new class_2960("azurelibarmor", "use_ticks")));
    public static final SerializableDataTicket<Boolean> ACTIVE = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new class_2960("azurelibarmor", "active")));
    public static final SerializableDataTicket<Boolean> OPEN = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new class_2960("azurelibarmor", "open")));
    public static final SerializableDataTicket<Boolean> CLOSED = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new class_2960("azurelibarmor", "closed")));
    public static final SerializableDataTicket<class_2350> DIRECTION = AzureLibUtil.addDataTicket(SerializableDataTicket.ofEnum(new class_2960("azurelibarmor", "direction"), class_2350.class));

    @Nullable
    public static SerializableDataTicket<?> byName(String id) {
        return SERIALIZABLE_TICKETS.getOrDefault(id, null);
    }

    public static <D> SerializableDataTicket<D> registerSerializable(SerializableDataTicket<D> ticket) {
        SerializableDataTicket<D> existingTicket = SERIALIZABLE_TICKETS.putIfAbsent(ticket.id(), ticket);
        if (existingTicket != null) {
            AzureLib.LOGGER.error("Duplicate SerializableDataTicket registered! This will cause issues. Existing: {}, New: {}", (Object)existingTicket.id(), (Object)ticket.id());
        }
        return ticket;
    }

    private DataTickets() {
        throw new UnsupportedOperationException();
    }
}

