/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks;

import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.base.Wrenchable;
import earth.terrarium.adastra.common.blocks.properties.SlidingDoorPartProperty;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlidingDoorBlock
extends BasicEntityBlock
implements Wrenchable {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2746 LOCKED = class_2741.field_12502;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<SlidingDoorPartProperty> PART = class_2754.method_11850((String)"part", SlidingDoorPartProperty.class);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);

    public SlidingDoorBlock(class_4970.class_2251 properties) {
        super(properties.method_50012(class_3619.field_15972), true);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657(PART, (Comparable)((Object)SlidingDoorPartProperty.BOTTOM)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, OPEN, LOCKED, POWERED, PART});
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            default -> NORTH_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
        };
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.SLIDING_DOOR_INFO);
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_2680 controllerState = level.method_8320(this.getController(state, pos));
        if (!controllerState.method_11656().containsKey(PART)) {
            return super.method_9549(state, level, pos, context);
        }
        return (Boolean)controllerState.method_11654((class_2769)OPEN) != false || (Boolean)controllerState.method_11654((class_2769)POWERED) != false ? class_259.method_1073() : super.method_9549(state, level, pos, context);
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case class_10.field_50, class_10.field_51 -> {
                if (((Boolean)state.method_11654((class_2769)OPEN)).booleanValue() || ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case class_10.field_48 -> false;
        };
    }

    @Override
    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ((SlidingDoorPartProperty)((Object)state.method_11654(PART))).isController() ? super.method_10123(pos, state) : null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2338 controllerPos = this.getController(state, pos);
        class_2680 controllerState = level.method_8320(controllerPos);
        if (controllerState.method_26215()) {
            return class_1269.field_5811;
        }
        boolean locked = (Boolean)controllerState.method_11654((class_2769)LOCKED);
        if (level.method_8608()) {
            return locked ? class_1269.field_5811 : class_1269.field_5812;
        }
        if (locked) {
            return class_1269.field_5811;
        }
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10170();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            class_2338 partPos = controllerPos.method_10079(direction, part.xOffset()).method_10086(part.yOffset());
            class_2680 partState = level.method_8320(partPos);
            level.method_8501(partPos, (class_2680)partState.method_28493((class_2769)OPEN));
        }
        return class_1269.field_5812;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10170();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            class_2338 partPos = pos.method_10079(direction.method_10153(), part.xOffset()).method_10086(part.yOffset());
            level.method_8652(partPos, (class_2680)state.method_11657(PART, (Comparable)((Object)part)), 2);
        }
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        class_2338 controllerPos;
        class_2680 controllerState;
        if (!level.method_8608() && (controllerState = level.method_8320(controllerPos = this.getController(state, pos))).method_26204() instanceof SlidingDoorBlock) {
            level.method_8652(controllerPos, (class_2680)controllerState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(level.method_49803(pos))), 2);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        if (!class_2248.method_16361((class_1922)level, (class_2338)pos.method_10074())) {
            return false;
        }
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10170();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            class_2338 offset = pos.method_10079(direction, part.xOffset()).method_10086(part.yOffset());
            if (level.method_8320(offset).method_26215()) continue;
            return false;
        }
        return true;
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        this.destroy(level, pos, state);
        super.method_9576(level, pos, state, player);
    }

    public void method_9586(class_1937 level, class_2338 pos, class_1927 explosion) {
        if (!level.method_8608()) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 offset = pos.method_10093(direction);
                class_2680 state = level.method_8320(offset);
                if (!state.method_26204().equals(this)) continue;
                this.destroy(level, offset, state);
                break;
            }
        }
        super.method_9586(level, pos, explosion);
    }

    private void destroy(class_1937 level, class_2338 pos, class_2680 state) {
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10170();
        class_2338 controllerPos = this.getController(state, pos);
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            class_2338 partPos = controllerPos.method_10079(direction, part.xOffset()).method_10086(part.yOffset());
            level.method_22352(partPos, true);
        }
    }

    private class_2338 getController(class_2680 state, class_2338 pos) {
        SlidingDoorPartProperty part = (SlidingDoorPartProperty)((Object)state.method_11654(PART));
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10170();
        return pos.method_10079(direction.method_10153(), -part.xOffset()).method_10087(part.yOffset());
    }

    @Override
    public void onWrench(class_1937 level, class_2338 pos, class_2680 state, class_2350 side, class_1657 user, class_243 hitPos) {
        class_2338 controllerPos = this.getController(state, pos);
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10170();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            class_2338 partPos = controllerPos.method_10079(direction, part.xOffset()).method_10086(part.yOffset());
            class_2680 partState = level.method_8320(partPos);
            level.method_8501(partPos, (class_2680)partState.method_28493((class_2769)LOCKED));
            if (((Boolean)partState.method_11654((class_2769)LOCKED)).booleanValue()) {
                user.method_7353(ConstantComponents.DOOR_UNLOCKED, true);
                continue;
            }
            user.method_7353(ConstantComponents.DOOR_LOCKED, true);
        }
        level.method_8396(null, pos, (class_3414)ModSoundEvents.WRENCH.get(), class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
    }
}

