/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks.pipes;

import earth.terrarium.adastra.common.blockentities.pipes.PipeBlockEntity;
import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.base.Wrenchable;
import earth.terrarium.adastra.common.blocks.pipes.TransferablePipe;
import earth.terrarium.adastra.common.blocks.properties.PipeProperty;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class PipeBlock
extends BasicEntityBlock
implements class_3737,
Wrenchable,
TransferablePipe {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<PipeProperty> CONNECTED_UP = class_2754.method_11850((String)"connected_up", PipeProperty.class);
    public static final class_2754<PipeProperty> CONNECTED_DOWN = class_2754.method_11850((String)"connected_down", PipeProperty.class);
    public static final class_2754<PipeProperty> CONNECTED_NORTH = class_2754.method_11850((String)"connected_north", PipeProperty.class);
    public static final class_2754<PipeProperty> CONNECTED_EAST = class_2754.method_11850((String)"connected_east", PipeProperty.class);
    public static final class_2754<PipeProperty> CONNECTED_SOUTH = class_2754.method_11850((String)"connected_south", PipeProperty.class);
    public static final class_2754<PipeProperty> CONNECTED_WEST = class_2754.method_11850((String)"connected_west", PipeProperty.class);
    public static final EnumMap<class_2350, class_2754<PipeProperty>> DIRECTION_TO_CONNECTION = (EnumMap)class_156.method_654(new EnumMap(class_2350.class), map -> {
        map.put(class_2350.field_11036, CONNECTED_UP);
        map.put(class_2350.field_11033, CONNECTED_DOWN);
        map.put(class_2350.field_11043, CONNECTED_NORTH);
        map.put(class_2350.field_11034, CONNECTED_EAST);
        map.put(class_2350.field_11035, CONNECTED_SOUTH);
        map.put(class_2350.field_11039, CONNECTED_WEST);
    });
    private final Map<class_2680, class_265> shapes = new HashMap<class_2680, class_265>();
    private final long transferRate;
    private final TransferablePipe.Type type;

    public PipeBlock(long transferRate, TransferablePipe.Type type, double size, class_4970.class_2251 properties) {
        super(properties, true);
        this.transferRate = transferRate;
        this.type = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(CONNECTED_UP, (Comparable)((Object)PipeProperty.NONE))).method_11657(CONNECTED_DOWN, (Comparable)((Object)PipeProperty.NONE))).method_11657(CONNECTED_NORTH, (Comparable)((Object)PipeProperty.NONE))).method_11657(CONNECTED_EAST, (Comparable)((Object)PipeProperty.NONE))).method_11657(CONNECTED_SOUTH, (Comparable)((Object)PipeProperty.NONE))).method_11657(CONNECTED_WEST, (Comparable)((Object)PipeProperty.NONE)));
        if (size > 0.0) {
            this.field_10647.method_11662().forEach(state -> this.shapes.put((class_2680)state, PipeBlock.makeShape(state, size)));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, CONNECTED_UP, CONNECTED_DOWN, CONNECTED_NORTH, CONNECTED_EAST, CONNECTED_SOUTH, CONNECTED_WEST});
    }

    public void method_9568(class_1799 stack, class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        if (this.type == TransferablePipe.Type.ENERGY) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.ad_astra.energy_transfer_tick", (Object[])new Object[]{this.transferRate}).method_27692(class_124.field_1065));
            TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.CABLE_INFO);
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.ad_astra.fluid_transfer_tick", (Object[])new Object[]{FluidConstants.toMillibuckets((long)this.transferRate)}).method_27692(class_124.field_1065));
            TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.FLUID_PIPE_INFO);
        }
    }

    @Override
    public long transferRate() {
        return this.transferRate;
    }

    @Override
    public TransferablePipe.Type type() {
        return this.type;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapes.getOrDefault(state, class_259.method_1077());
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772().equals(class_3612.field_15910)));
    }

    public static Optional<class_2350> getDirectionByVec(class_243 hit, class_2338 pos) {
        class_243 relativePos = hit.method_1031((double)(-pos.method_10263()), (double)(-pos.method_10264()), (double)(-pos.method_10260()));
        if (relativePos.field_1352 < 0.125) {
            return Optional.of(class_2350.field_11039);
        }
        if (relativePos.field_1352 > 0.875) {
            return Optional.of(class_2350.field_11034);
        }
        if (relativePos.field_1350 < 0.125) {
            return Optional.of(class_2350.field_11043);
        }
        if (relativePos.field_1350 > 0.875) {
            return Optional.of(class_2350.field_11035);
        }
        if (relativePos.field_1351 < 0.125) {
            return Optional.of(class_2350.field_11033);
        }
        if (relativePos.field_1351 > 0.875) {
            return Optional.of(class_2350.field_11036);
        }
        return Optional.empty();
    }

    @Override
    public void onWrench(class_1937 level, class_2338 pos, class_2680 state, class_2350 side, class_1657 user, class_243 hitPos) {
        if (!level.method_8608()) {
            class_2754<PipeProperty> property = DIRECTION_TO_CONNECTION.get(PipeBlock.getDirectionByVec(hitPos, pos).orElse(user.method_5715() ? side.method_10153() : side));
            level.method_8501(pos, (class_2680)state.method_28493(property));
            level.method_8396(null, pos, (class_3414)ModSoundEvents.WRENCH.get(), class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
            user.method_7353(switch ((PipeProperty)((Object)level.method_8320(pos).method_11654(property))) {
                default -> throw new IncompatibleClassChangeError();
                case PipeProperty.NONE -> ConstantComponents.PIPE_NONE;
                case PipeProperty.NORMAL -> ConstantComponents.PIPE_NORMAL;
                case PipeProperty.INSERT -> ConstantComponents.PIPE_INSERT;
                case PipeProperty.EXTRACT -> ConstantComponents.PIPE_EXTRACT;
            }, true);
        }
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        this.update(level, pos);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        this.update((class_1937)level, pos, state, direction);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)class_25862;
            pipe.pipeChanged((class_1937)level, pos);
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    private void update(class_1937 level, class_2338 pos) {
        if (level.method_8608()) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            this.update(level, pos, level.method_8320(pos), direction);
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)class_25862;
            pipe.pipeChanged(level, pos);
        }
    }

    private void update(class_1937 level, class_2338 pos, class_2680 state, class_2350 direction) {
        if (level.method_8608()) {
            return;
        }
        class_2754<PipeProperty> directionProperty = DIRECTION_TO_CONNECTION.get(direction);
        boolean canConnect = this.canConnect(level, pos, direction);
        PipeProperty pipe = (PipeProperty)((Object)state.method_11654(directionProperty));
        if ((pipe.isInsert() || pipe.isExtract()) && canConnect) {
            return;
        }
        level.method_8501(pos, (class_2680)state.method_11657(directionProperty, (Comparable)((Object)(canConnect ? PipeProperty.NORMAL : PipeProperty.NONE))));
    }

    private boolean canConnect(class_1937 level, class_2338 pos, class_2350 direction) {
        class_2338 connectPos = pos.method_10093(direction);
        class_2680 connectState = level.method_8320(connectPos);
        class_2248 class_22482 = connectState.method_26204();
        if (class_22482 instanceof TransferablePipe) {
            TransferablePipe pipe = (TransferablePipe)class_22482;
            return pipe.type() == this.type;
        }
        class_2586 entity = level.method_8321(connectPos);
        if (entity == null) {
            return false;
        }
        if (this.type == TransferablePipe.Type.ENERGY) {
            return EnergyContainer.holdsEnergy((class_2586)entity, (class_2350)direction.method_10153());
        }
        if (this.type == TransferablePipe.Type.FLUID) {
            return FluidContainer.holdsFluid((class_2586)entity, (class_2350)direction.method_10153());
        }
        return false;
    }

    public static class_2350[] getConnectedDirections(class_2680 state) {
        return (class_2350[])DIRECTION_TO_CONNECTION.entrySet().stream().filter(entry -> !((PipeProperty)((Object)((Object)state.method_11654((class_2769)entry.getValue())))).isNone()).map(Map.Entry::getKey).toArray(class_2350[]::new);
    }

    public static class_265 makeShape(class_2680 state, double size) {
        class_265 shape = class_259.method_1081((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size));
        if (!((PipeProperty)((Object)state.method_11654(CONNECTED_UP))).isNone()) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)size, (double)(1.0 - size), (double)1.0, (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.method_11654(CONNECTED_DOWN))).isNone()) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)0.0, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.method_11654(CONNECTED_NORTH))).isNone()) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)0.0, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.method_11654(CONNECTED_EAST))).isNone()) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)size, (double)1.0, (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.method_11654(CONNECTED_SOUTH))).isNone()) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)1.0));
        }
        if (!((PipeProperty)((Object)state.method_11654(CONNECTED_WEST))).isNone()) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        return shape;
    }
}

