/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.blocks;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.createcobblestone.CreateCobblestoneMod;
import net.createcobblestone.data.GeneratorType;
import net.createcobblestone.index.Config;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class MechanicalGeneratorBlockEntity
extends KineticBlockEntity
implements class_1263 {
    final class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final int size = 1;
    private double available = 0.0;
    public GeneratorType type = GeneratorType.NONE;

    public MechanicalGeneratorBlockEntity(class_2591<? extends MechanicalGeneratorBlockEntity> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        if (this.type == null) {
            throw new IllegalStateException("Generator type cannot be null (GeneratorTypes not initialized but mechanicalGeneratorBlockEntity created)");
        }
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10582("type", this.type.getId());
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        try {
            this.updateType(GeneratorType.fromId(compound.method_10558("type")));
        }
        catch (IllegalArgumentException e) {
            CreateCobblestoneMod.LOGGER.error("Invalid generator type \"{}\", setting type to NONE", (Object)compound.method_10558("type"));
            this.type = GeneratorType.NONE;
            this.method_5431();
        }
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.items) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    @NotNull
    public class_1799 method_5434(int index, int count) {
        class_1799 itemstack = class_1262.method_5430(this.items, (int)index, (int)count);
        if (!itemstack.method_7960()) {
            this.method_5431();
        }
        return itemstack;
    }

    @NotNull
    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.items, (int)index);
    }

    public void method_5447(int index, @NotNull class_1799 stack) {
        this.items.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
    }

    public void tick() {
        class_2248 generatorBlock;
        super.tick();
        try {
            generatorBlock = this.type.getBlock();
            if (!Config.common().isEnabled(this.type)) {
                this.updateType(GeneratorType.NONE);
                return;
            }
        }
        catch (NullPointerException e) {
            CreateCobblestoneMod.LOGGER.error("Tried accessing generator block before world was loaded");
            return;
        }
        if (generatorBlock != class_2246.field_10124) {
            if (!this.type.isLoaded()) {
                this.updateType(GeneratorType.NONE);
                return;
            }
            if (this.available < (double)this.type.getStorage()) {
                this.available += (double)Math.abs(this.getSpeed() / this.type.getGeneratorRatio());
            }
            int current = ((class_1799)this.items.get(0)).method_7947();
            int added = (int)this.available;
            this.available -= (double)added;
            this.items.set(0, (Object)new class_1799((class_1935)generatorBlock, Math.min(current + added, this.type.getStorage())));
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)this.type.getGeneratorStress();
        return impact;
    }

    public void updateType(GeneratorType newType) {
        if (newType == null) {
            CreateCobblestoneMod.LOGGER.error("Attempted to update generator type to null");
            return;
        }
        CreateCobblestoneMod.LOGGER.info("Trying to update generator type from \"{}\" to \"{}\"", (Object)this.type.getId(), (Object)newType.getId());
        if (!Config.common().isEnabled(newType)) {
            if (!Config.common().isEnabled(this.type)) {
                newType = GeneratorType.NONE;
            } else {
                CreateCobblestoneMod.LOGGER.error("Disabled generator type \"{}\", not changing old generator type. ({})", (Object)newType.getId(), (Object)this.type.getId());
                return;
            }
        }
        CreateCobblestoneMod.LOGGER.info("Changing generator type from \"{}\" to \"{}\"", (Object)this.type.getId(), (Object)newType.getId());
        this.type = newType;
        this.available = 0.0;
        this.items.clear();
        this.method_5431();
    }
}

