/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry;

import com.simibubi.create.foundation.ponder.PonderRegistrationHelper;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.registry.GarnishedBlocks;
import net.dakotapride.garnished.registry.GarnishedItems;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_3611;

public class NewIndex {
    static final PonderRegistrationHelper HELPER = new PonderRegistrationHelper("garnished");

    public static void index() {
        NewIndex.forComponents(new ItemProviderEntry[]{GarnishedItems.CRACKED_ALMOND, GarnishedItems.CRACKED_BUHG, GarnishedItems.CRACKED_CASHEW, GarnishedItems.CRACKED_CHESTNUT, GarnishedItems.CRACKED_HAZELNUT, GarnishedItems.CRACKED_MACADAMIA, GarnishedItems.CRACKED_PECAN, GarnishedItems.CRACKED_PISTACHIO, GarnishedItems.CRACKED_WALNUT}).addStoryBoard(IndexUtils.TUTORIAL + "/nut_tree", ScenesAndInteractions::nutTreeScene).addStoryBoard(IndexUtils.TUTORIAL + "/garnished_nut_blocks", ScenesAndInteractions::garnishedNutBlockScene).addStoryBoard(IndexUtils.TUTORIAL + "/ungarnished_nut_blocks", ScenesAndInteractions::ungarnishedNutBlockScene);
        NewIndex.forComponents(new ItemProviderEntry[]{GarnishedBlocks.GARNISHED_NUT_BLOCK, GarnishedBlocks.UNGARNISHED_NUT_BLOCK}).addStoryBoard(IndexUtils.TUTORIAL + "/garnished_nut_blocks", ScenesAndInteractions::garnishedNutBlockScene).addStoryBoard(IndexUtils.TUTORIAL + "/ungarnished_nut_blocks", ScenesAndInteractions::ungarnishedNutBlockScene);
    }

    public static PonderRegistrationHelper.MultiSceneBuilder forComponents(ItemProviderEntry<?> ... entries) {
        return HELPER.forComponents(entries);
    }

    public static class IndexUtils {
        public static String INCINERATION = "incineration";
        public static String DESOLATION = "desolation";
        public static String SNARE_TEAR = "snare_tear";
        public static String NUT_TYPING = "nut_typing";
        public static String SUGARCOATED = "sugarcoated";
        public static String GLOOMY_MEATS = "gloomy_meats";
        public static String BOUNDLESS_SEA = "boundless_sea";
        public static String BEFOULED = "befouled";
        public static String GLACIAL_EDGE = "glacial_edge";
        public static String TUTORIAL = "tutorial";
    }

    public static class PonderIndexTags {
        public static PonderTag CRACKED_NUTS = PonderIndexTags.create("cracked_nuts", "cracked_nuts_description", (class_1792)GarnishedItems.CRACKED_WALNUT.get());

        private static PonderTag create(String id, String desc, class_1792 representedItem) {
            return new PonderTag(CreateGarnished.asResource(id)).item((class_1935)representedItem).defaultLang(id, desc).addToIndex();
        }

        public static void tags() {
            PonderRegistry.TAGS.forTag(CRACKED_NUTS).add(GarnishedItems.CRACKED_ALMOND).add(GarnishedItems.CRACKED_BUHG).add(GarnishedItems.CRACKED_CASHEW).add(GarnishedItems.CRACKED_CHESTNUT).add(GarnishedItems.CRACKED_HAZELNUT).add(GarnishedItems.CRACKED_MACADAMIA).add(GarnishedItems.CRACKED_PECAN).add(GarnishedItems.CRACKED_PISTACHIO).add(GarnishedItems.CRACKED_WALNUT);
        }
    }

    public static class ScenesAndInteractions {
        public static void nutTreeScene(SceneBuilder scene, SceneBuildingUtil util) {
            ScenesAndInteractions.showBaseArea("nut_tree", scene, util);
            ScenesAndInteractions.markFinished(scene);
        }

        public static void garnishedNutBlockScene(SceneBuilder scene, SceneBuildingUtil util) {
            ScenesAndInteractions.showBaseArea("garnished_nut_block", scene, util);
            ScenesAndInteractions.markFinished(scene);
        }

        public static void ungarnishedNutBlockScene(SceneBuilder scene, SceneBuildingUtil util) {
            ScenesAndInteractions.showBaseArea("ungarnished_nut_block", scene, util);
            ScenesAndInteractions.markFinished(scene);
        }

        public static void markFinished(SceneBuilder scene) {
            scene.idle(ScenesAndInteractions.sec(6));
            scene.markAsFinished();
        }

        public static void showBaseArea(String title, SceneBuilder scene, SceneBuildingUtil util) {
            scene.title(title, title);
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
        }

        private static int sec(int seconds) {
            return 20 * seconds;
        }

        private static FluidStack fluid(class_3611 source, int mb) {
            return new FluidStack(source, (long)mb);
        }
    }
}

