/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl;

import com.google.common.base.Suppliers;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.ThreadClientHelper;
import compasses.expandedstorage.impl.ThreadMain;
import compasses.expandedstorage.impl.block.entity.ChestBlockEntity;
import compasses.expandedstorage.impl.client.ChestBlockEntityRenderer;
import compasses.expandedstorage.impl.client.compat.inventory_tabs.ExpandedBlockTabProvider;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.entity.ChestMinecart;
import compasses.expandedstorage.impl.item.ChestMinecartItem;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import compasses.expandedstorage.impl.registration.Content;
import compasses.expandedstorage.impl.registration.ModItems;
import compasses.expandedstorage.impl.registration.NamedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_5616;
import net.minecraft.class_634;
import net.minecraft.class_811;
import net.minecraft.class_925;

public class ThreadClient
implements ClientModInitializer {
    public void onInitializeClient() {
        CommonClient.initialize(new ThreadClientHelper());
        class_3929.method_17542(CommonMain.platformHelper().getScreenHandlerType(), AbstractScreen::createScreen);
        Content content = ThreadMain.getContentForClient();
        ThreadClient.registerChestBlockEntityRenderer();
        ThreadClient.registerItemRenderers(content.getChestItems());
        ThreadClient.registerMinecartEntityRenderers(content.getChestMinecartEntityTypes());
        ThreadClient.registerMinecartItemRenderers(content.getChestMinecartAndTypes());
        ThreadClient.registerInventoryTabsCompat();
        class_5272.method_27881((class_2960)Utils.id("sparrow"), CommonClient::hasSparrowProperty);
        class_5272.method_27879((class_1792)ModItems.STORAGE_MUTATOR, (class_2960)Utils.id("tool_mode"), CommonClient::currentMutatorToolMode);
        ClientPlayConnectionEvents.INIT.register((_listener, _client) -> ClientPlayNetworking.registerReceiver((class_2960)ThreadMain.UPDATE_RECIPES_ID, (client, listener, buffer, responseSender) -> ThreadClient.handleUpdateRecipesPacket(client, listener, buffer)));
    }

    public static void handleUpdateRecipesPacket(class_310 client, class_634 listener, class_2540 buffer) {
        ArrayList blockRecipes = new ArrayList(buffer.method_34068(ArrayList::new, BlockConversionRecipe::readFromBuffer));
        ArrayList entityRecipes = new ArrayList(buffer.method_34068(ArrayList::new, EntityConversionRecipe::readFromBuffer));
        client.execute(() -> ConversionRecipeManager.INSTANCE.replaceAllRecipes(blockRecipes, entityRecipes));
    }

    public static void registerChestBlockEntityRenderer() {
        class_5616.method_32144(CommonMain.getChestBlockEntityType(), ChestBlockEntityRenderer::new);
    }

    public static void registerItemRenderers(List<NamedValue<class_1747>> items) {
        for (NamedValue<class_1747> item : items) {
            ChestBlockEntity renderEntity = (ChestBlockEntity)CommonMain.getChestBlockEntityType().method_11032(class_2338.field_10980, item.getValue().method_7711().method_9564());
            BuiltinItemRendererRegistry.INSTANCE.register((class_1935)item.getValue(), (itemStack, context, stack, source, light, overlay) -> {
                renderEntity.setCustomName(itemStack.method_7964());
                class_310.method_1551().method_31975().method_23077((class_2586)renderEntity, stack, source, light, overlay);
            });
        }
        EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.SINGLE_LAYER, ChestBlockEntityRenderer::createSingleBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.LEFT_LAYER, ChestBlockEntityRenderer::createLeftBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.RIGHT_LAYER, ChestBlockEntityRenderer::createRightBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.TOP_LAYER, ChestBlockEntityRenderer::createTopBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.BOTTOM_LAYER, ChestBlockEntityRenderer::createBottomBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.FRONT_LAYER, ChestBlockEntityRenderer::createFrontBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.BACK_LAYER, ChestBlockEntityRenderer::createBackBodyLayer);
    }

    public static void registerMinecartEntityRenderers(List<NamedValue<class_1299<ChestMinecart>>> chestMinecartEntityTypes) {
        for (NamedValue<class_1299<ChestMinecart>> type : chestMinecartEntityTypes) {
            EntityRendererRegistry.register(type.getValue(), context -> new class_925(context, class_5602.field_27690));
        }
    }

    public static void registerMinecartItemRenderers(List<Map.Entry<NamedValue<ChestMinecartItem>, NamedValue<class_1299<ChestMinecart>>>> chestMinecartAndTypes) {
        for (Map.Entry<NamedValue<ChestMinecartItem>, NamedValue<class_1299<ChestMinecart>>> pair : chestMinecartAndTypes) {
            com.google.common.base.Supplier renderEntity = Suppliers.memoize(() -> (ChestMinecart)((class_1299)((NamedValue)pair.getValue()).getValue()).method_5883((class_1937)class_310.method_1551().field_1687));
            BuiltinItemRendererRegistry.INSTANCE.register((class_1935)pair.getKey().getValue(), (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ThreadClient.lambda$registerMinecartItemRenderers$6((Supplier)renderEntity, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
        }
    }

    public static void registerInventoryTabsCompat() {
        if (FabricLoader.getInstance().isModLoaded("inventory-tabs")) {
            ExpandedBlockTabProvider.register();
        }
    }

    private static /* synthetic */ void lambda$registerMinecartItemRenderers$6(Supplier renderEntity, class_1799 itemStack, class_811 transform, class_4587 stack, class_4597 source, int light, int overlay) {
        class_310.method_1551().method_1561().method_3954((class_1297)((ChestMinecart)renderEntity.get()), 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, source, light);
    }
}

