/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.FakePickScreen;
import compasses.expandedstorage.impl.client.gui.MiniStorageScreen;
import compasses.expandedstorage.impl.client.gui.PageScreen;
import compasses.expandedstorage.impl.client.gui.PickScreen;
import compasses.expandedstorage.impl.client.gui.ScrollScreen;
import compasses.expandedstorage.impl.client.gui.SingleScreen;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.misc.Utils;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends class_465<AbstractHandler> {
    protected final int inventoryWidth;
    protected final int inventoryHeight;
    protected final int totalSlots;
    protected final class_2960 textureLocation;
    protected final int textureWidth;
    protected final int textureHeight;

    protected AbstractScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title, ScreenSize screenSize) {
        super((class_1703)handler, playerInventory, title);
        this.totalSlots = handler.getInventory().method_5439();
        this.inventoryWidth = screenSize.width();
        this.inventoryHeight = screenSize.height();
        if (this instanceof MiniStorageScreen) {
            this.textureLocation = Utils.id("textures/gui/container/mini_chest_screen.png");
            this.textureHeight = 176;
            this.textureWidth = 176;
        } else if (this instanceof FakePickScreen) {
            this.textureLocation = null;
            this.textureHeight = 0;
            this.textureWidth = 0;
        } else {
            this.textureLocation = Utils.id("textures/gui/container/shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png");
            if (this.inventoryHeight == 3) {
                this.textureWidth = 176;
            } else if (this.inventoryWidth == 9) {
                this.textureWidth = 208;
            } else if (this.inventoryWidth == 12) {
                this.textureWidth = 256;
            } else if (this.inventoryWidth == 15) {
                this.textureWidth = 320;
            } else if (this.inventoryWidth == 18) {
                this.textureWidth = 368;
            } else {
                throw new IllegalStateException("Unable to determine width for screen texture: " + this.textureLocation);
            }
            this.textureHeight = switch (this.inventoryHeight) {
                case 3 -> 192;
                case 5, 6 -> 240;
                case 9 -> 304;
                case 12 -> 352;
                case 15 -> 416;
                default -> throw new IllegalStateException("Unable to determine height for screen texture: " + this.textureLocation);
            };
        }
    }

    public static AbstractScreen createScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title) {
        class_2960 forcedScreenType = handler.getForcedScreenType();
        class_2960 preference = forcedScreenType != null ? forcedScreenType : CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int scaledWidth = class_310.method_1551().method_22683().method_4486();
        int scaledHeight = class_310.method_1551().method_22683().method_4502();
        int slots = handler.getInventory().method_5439();
        if (forcedScreenType == null && AbstractScreen.canSingleScreenDisplay(slots, scaledWidth, scaledHeight) && AbstractScreen.shouldPreferSingleScreen(preference)) {
            preference = Utils.SINGLE_SCREEN_TYPE;
        }
        if (preference == null) {
            return new FakePickScreen(handler, playerInventory, title);
        }
        ScreenSize screenSize = AbstractScreen.getScreenSize(preference, slots, scaledWidth, scaledHeight);
        if (screenSize == null) {
            throw new IllegalStateException("screenSize should never be null...");
        }
        if (Utils.PAGINATED_SCREEN_TYPE.equals((Object)preference)) {
            return new PageScreen(handler, playerInventory, title, screenSize);
        }
        if (Utils.SCROLLABLE_SCREEN_TYPE.equals((Object)preference)) {
            return new ScrollScreen(handler, playerInventory, title, screenSize);
        }
        if (Utils.SINGLE_SCREEN_TYPE.equals((Object)preference)) {
            return new SingleScreen(handler, playerInventory, title, screenSize);
        }
        if (Utils.MINI_STORAGE_SCREEN_TYPE.equals((Object)preference)) {
            return new MiniStorageScreen(handler, playerInventory, title, screenSize);
        }
        throw new IllegalArgumentException("Unknown preference.");
    }

    private static boolean shouldPreferSingleScreen(class_2960 type) {
        return Utils.PAGINATED_SCREEN_TYPE.equals((Object)type) || Utils.SCROLLABLE_SCREEN_TYPE.equals((Object)type);
    }

    private static boolean canSingleScreenDisplay(int slots, int scaledWidth, int scaledHeight) {
        if (slots <= 54) {
            return true;
        }
        if (CommonClient.platformHelper().configWrapper().fitVanillaConstraints()) {
            return false;
        }
        if (scaledHeight >= 276) {
            if (slots <= 81) {
                return true;
            }
            if (scaledWidth >= 230 && slots <= 108) {
                return true;
            }
            if (scaledWidth >= 284 && slots <= 135) {
                return true;
            }
            if (scaledWidth >= 338 && slots <= 162) {
                return true;
            }
        }
        if (scaledWidth >= 338) {
            if (scaledHeight >= 330 && slots <= 216) {
                return true;
            }
            return scaledHeight >= 384 && slots <= 270;
        }
        return false;
    }

    @Nullable
    public static ScreenSize getScreenSize(class_2960 type, int slots, int scaledWidth, int scaledHeight) {
        if (Utils.PAGINATED_SCREEN_TYPE.equals((Object)type)) {
            return PageScreen.retrieveScreenSize(slots, scaledWidth, scaledHeight);
        }
        if (Utils.SCROLLABLE_SCREEN_TYPE.equals((Object)type)) {
            return ScrollScreen.retrieveScreenSize(slots, scaledWidth, scaledHeight);
        }
        if (Utils.SINGLE_SCREEN_TYPE.equals((Object)type)) {
            return SingleScreen.retrieveScreenSize(slots, scaledWidth, scaledHeight);
        }
        if (Utils.MINI_STORAGE_SCREEN_TYPE.equals((Object)type)) {
            return new ScreenSize(1, 1);
        }
        return null;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    public final boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (CommonClient.platformHelper().isConfigKeyPressed(keyCode, scanCode, modifiers) && ((AbstractHandler)this.field_2797).getForcedScreenType() == null && CommonClient.platformHelper().configWrapper().getPreferredScreenType() != null) {
            this.field_22787.method_1507((class_437)new PickScreen(this));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<class_768> getExclusionZones() {
        return List.of();
    }

    public int getInventoryWidth() {
        return this.inventoryWidth;
    }
}

