/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.widget.PickButton;
import compasses.expandedstorage.impl.client.gui.widget.ScreenPickButton;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.misc.Utils;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public final class PickScreen
extends class_437 {
    public static final class_2561 CURRENT_OPTION_TEXT = class_2561.method_43471((String)"screen.expandedstorage.current_option_notice").method_27692(class_124.field_1065);
    public static final Map<class_2960, PickButton> BUTTON_SETTINGS = Map.of(Utils.PAGINATED_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/page_button.png"), (class_2561)class_2561.method_43471((String)"screen.expandedstorage.page_screen"), new class_2561[0]), Utils.SCROLLABLE_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/scroll_button.png"), (class_2561)class_2561.method_43471((String)"screen.expandedstorage.scroll_screen"), new class_2561[0]), Utils.SINGLE_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/single_button.png"), (class_2561)class_2561.method_43471((String)"screen.expandedstorage.single_screen"), new class_2561[]{class_2561.method_43471((String)"screen.expandedstorage.off_screen_warning_1").method_27692(class_124.field_1080), class_2561.method_43471((String)"screen.expandedstorage.off_screen_warning_2").method_27692(class_124.field_1080)}){

        @Override
        public boolean shouldShowWarning(int scaledWidth, int scaledHeight) {
            return scaledWidth < 370 || scaledHeight < 386;
        }
    });
    private final Set<class_2960> options = ImmutableSortedSet.copyOf(BUTTON_SETTINGS.keySet());
    private final Supplier<class_437> returnToScreen;
    private final AbstractHandler handler;
    private int topPadding;

    public PickScreen(AbstractScreen currentScreen) {
        this((AbstractHandler)currentScreen.method_17577(), () -> AbstractScreen.createScreen((AbstractHandler)currentScreen.method_17577(), class_310.method_1551().field_1724.method_31548(), currentScreen.method_25440()));
    }

    public PickScreen(class_437 returnToScreen) {
        this(null, () -> returnToScreen);
    }

    private PickScreen(@Nullable AbstractHandler handler, Supplier<class_437> returnToScreen) {
        super((class_2561)class_2561.method_43471((String)"screen.expandedstorage.screen_picker_title"));
        this.handler = handler;
        this.returnToScreen = returnToScreen;
    }

    public void method_25419() {
        if (this.handler != null) {
            class_2960 preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
            if (preference == null) {
                this.field_22787.field_1724.method_7346();
                return;
            }
            if (AbstractScreen.getScreenSize(preference, this.handler.getInventory().method_5439(), this.field_22787.method_22683().method_4486(), this.field_22787.method_22683().method_4502()) == null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.expandedstorage.short_prefix").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43469((String)"chat.expandedstorage.cannot_display_screen", (Object[])new Object[]{class_2561.method_43471((String)("screen." + preference.method_12836() + "." + preference.method_12832() + "_screen"))}).method_27692(class_124.field_1068)), false);
                this.field_22787.field_1724.method_7346();
                return;
            }
            this.handler.clearSlots();
        }
        this.field_22787.method_1507(this.returnToScreen.get());
    }

    public boolean method_25421() {
        return this.field_22787.field_1687 == null;
    }

    protected void method_25426() {
        int topPadding;
        super.method_25426();
        class_2960 preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Math.floorDiv(this.field_22789, 96), choices);
        int innerPadding = Math.min((this.field_22789 - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.field_22789 - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.field_22790 - 96) / 2;
        for (class_2960 option : this.options) {
            PickButton settings = BUTTON_SETTINGS.get(option);
            boolean isWarn = settings.shouldShowWarning(this.field_22789, this.field_22790);
            boolean isCurrent = option.equals((Object)preference);
            class_5250 tooltipMessage = class_2561.method_43470((String)"").method_10852(settings.getTitle());
            if (isCurrent) {
                tooltipMessage.method_27693("\n");
                tooltipMessage.method_10852(CURRENT_OPTION_TEXT);
            }
            if (isWarn) {
                tooltipMessage.method_27693("\n");
                settings.getWarningText().forEach(arg_0 -> ((class_5250)tooltipMessage).method_10852(arg_0));
            }
            this.method_37063((class_364)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, __ -> this.updatePlayerPreference(option), class_7919.method_47408((class_2561)tooltipMessage, (class_2561)tooltipMessage)));
            ++x;
        }
    }

    private void updatePlayerPreference(class_2960 selection) {
        CommonClient.platformHelper().configWrapper().setPreferredScreenType(selection);
        this.method_25419();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, Math.max(this.topPadding / 2, 0), -1);
    }
}

