/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory;

import compasses.expandedstorage.impl.inventory.handler.InventorySlotFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableSidedInventory
implements class_1278 {
    private final class_1278[] parts;
    private final int size;
    private final int maxStackCount;
    private final Map<class_2350, int[]> slotsAccessibleThroughFace = new HashMap<class_2350, int[]>();

    private VariableSidedInventory(class_1278 ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            assert (parts[i] != null) : "part at index " + i + " must not be null";
        }
        this.parts = parts;
        this.size = Arrays.stream(parts).mapToInt(class_1263::method_5439).sum();
        this.maxStackCount = parts[0].method_5444();
        for (class_1278 part : parts) {
            assert (part.method_5444() == this.maxStackCount) : "all parts must have equal max stack counts.";
        }
    }

    public static class_1278 of(class_1278 ... parts) {
        assert (parts.length > 0) : "parts must contain at least 1 inventory";
        if (parts.length == 1) {
            return parts[0];
        }
        return new VariableSidedInventory(parts);
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (class_1278 part : this.parts) {
            if (part.method_5442()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, class_1263::method_5438);
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.method_5434(rSlot, amount));
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, class_1263::method_5441);
    }

    public void method_5447(int slot, class_1799 stack) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
        this.consumeSlot(slot, (part, rSlot) -> part.method_5447(rSlot, stack));
    }

    public int method_5444() {
        return this.maxStackCount;
    }

    public void method_5431() {
        for (class_1278 part : this.parts) {
            part.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        for (class_1278 part : this.parts) {
            if (part.method_5443(player)) continue;
            return false;
        }
        return true;
    }

    public void method_5435(class_1657 player) {
        for (class_1278 part : this.parts) {
            part.method_5435(player);
        }
    }

    public void method_5432(class_1657 player) {
        for (class_1278 part : this.parts) {
            part.method_5432(player);
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.method_5437(rSlot, stack));
    }

    public int method_18861(class_1792 item) {
        int count = 0;
        for (class_1278 part : this.parts) {
            count += part.method_18861(item);
        }
        return count;
    }

    public boolean method_18862(Set<class_1792> set) {
        for (class_1278 part : this.parts) {
            if (!part.method_18862(set)) continue;
            return true;
        }
        return false;
    }

    public void method_5448() {
        for (class_1278 part : this.parts) {
            part.method_5448();
        }
    }

    public int @NotNull [] method_5494(class_2350 direction) {
        return this.slotsAccessibleThroughFace.computeIfAbsent(direction, dir -> {
            int previousSize = 0;
            IntArrayList list = new IntArrayList();
            for (class_1278 part : this.parts) {
                for (int i : part.method_5494(dir)) {
                    list.add(i + previousSize);
                }
                previousSize += part.method_5439();
            }
            return list.toIntArray();
        });
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 direction) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.method_5492(rSlot, stack, direction));
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.method_5493(rSlot, stack, direction));
    }

    private void consumeSlot(int slot, ObjIntConsumer<class_1278> consumer) {
        for (class_1278 part : this.parts) {
            int inventorySize = part.method_5439();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            consumer.accept(part, slot);
            return;
        }
        throw new IllegalStateException("consumeSlot called without validating slot bounds.");
    }

    private <T> T applyFunctionToSlot(int slot, InventorySlotFunction<class_1278, T> function) {
        for (class_1278 part : this.parts) {
            int inventorySize = part.method_5439();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            return function.apply(part, slot);
        }
        throw new IllegalStateException("applyFunctionToSlot called without validating slot bounds.");
    }

    public boolean containsPart(class_1278 part) {
        for (class_1278 inventory : this.parts) {
            if (inventory != part) continue;
            return true;
        }
        return false;
    }
}

