/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.conditions.RecipeCondition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class HasPropertyCondition
implements RecipeCondition {
    public static final class_2960 NETWORK_ID = Utils.id("has_property");
    private final class_2960 blockId;
    private final Map<class_2769<?>, Object> properties;
    private final boolean optional;

    public HasPropertyCondition(class_2960 blockId, Map<class_2769<?>, Object> properties, boolean optional) {
        this.blockId = blockId;
        this.properties = properties;
        this.optional = optional;
    }

    @Override
    public boolean isExactMatch() {
        return false;
    }

    @Override
    public boolean test(Object subject) {
        class_2680 state = (class_2680)subject;
        for (Map.Entry<class_2769<?>, Object> entry : this.properties.entrySet()) {
            if (!(state.method_28498(entry.getKey()) ? !state.method_11654(entry.getKey()).equals(entry.getValue()) : !this.optional)) continue;
            return false;
        }
        return true;
    }

    @Override
    public class_2960 getNetworkId() {
        return NETWORK_ID;
    }

    @Override
    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10812(this.blockId);
        buffer.writeBoolean(this.optional);
        buffer.writeInt(this.properties.size());
        for (Map.Entry<class_2769<?>, Object> property : this.properties.entrySet()) {
            buffer.method_10814(property.getKey().method_11899());
            buffer.method_10814(property.getValue().toString());
        }
    }

    public static HasPropertyCondition readFromBuffer(class_2540 buffer) {
        class_2960 blockId = buffer.method_10810();
        if (!class_7923.field_41175.method_10250(blockId)) {
            throw new IllegalStateException("Received an unknown block: " + blockId);
        }
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
        boolean optional = buffer.readBoolean();
        int numProperties = buffer.readInt();
        HashMap properties = Maps.newHashMapWithExpectedSize((int)numProperties);
        for (int i = 0; i < numProperties; ++i) {
            class_2769 key = block.method_9595().method_11663(buffer.method_19772());
            Object value = key.method_11900(buffer.method_19772()).orElseThrow();
            properties.put(key, value);
        }
        return new HasPropertyCondition(blockId, properties, optional);
    }

    @Override
    @Nullable
    public JsonElement toJson(@Nullable JsonObject object) {
        if (object != null) {
            this.writeToJsonObject(object);
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        this.writeToJsonObject(jsonObject);
        return jsonObject;
    }

    private void writeToJsonObject(JsonObject object) {
        JsonObject state = new JsonObject();
        for (Map.Entry<class_2769<?>, Object> entry : this.properties.entrySet()) {
            state.addProperty(entry.getKey().method_11899(), entry.getValue().toString());
        }
        object.add("state", (JsonElement)state);
    }
}

