/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import compasses.expandedstorage.impl.item.StorageConversionKit;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.misc.JsonHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class RecipeTool {
    private final class_2960 toolId;

    private RecipeTool(class_2960 toolId) {
        this.toolId = toolId;
    }

    public boolean isMatchFor(class_1799 tool) {
        return tool.method_7909().method_40131().method_40226(this.toolId);
    }

    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10812(this.toolId);
    }

    public JsonObject toJson() {
        JsonObject tool = new JsonObject();
        tool.addProperty("id", this.toolId.toString());
        return tool;
    }

    public static RecipeTool fromJsonObject(JsonObject object) {
        class_2960 toolId = JsonHelper.getJsonResourceLocation(object, "id");
        if (toolId.toString().equals("expandedstorage:storage_mutator")) {
            if (object.has("name")) {
                JsonElement name = object.get("name");
                if (name.isJsonPrimitive() && name.getAsJsonPrimitive().isString()) {
                    return new MutatorTool(name.getAsString());
                }
                throw new JsonSyntaxException("Tool's name entry must be a string");
            }
            return new MutatorTool(null);
        }
        if (class_7923.field_41178.method_10223(toolId) instanceof StorageConversionKit) {
            return new UpgradeTool(toolId);
        }
        throw new IllegalArgumentException("Tool id supplied is not a conversion kit or the storage mutator.");
    }

    public static RecipeTool fromNetworkBuffer(class_2540 buffer) {
        class_2960 toolId = buffer.method_10810();
        if (toolId.toString().equals("expandedstorage:storage_mutator")) {
            String name = (String)buffer.method_43827(class_2540::method_19772);
            return new MutatorTool(name);
        }
        if (class_7923.field_41178.method_10223(toolId) instanceof StorageConversionKit) {
            return new UpgradeTool(toolId);
        }
        throw new IllegalArgumentException("Invalid tool id sent by the server.");
    }

    public static final class MutatorTool
    extends RecipeTool {
        private final String requiredName;

        public MutatorTool(String requiredName) {
            super(Utils.id("storage_mutator"));
            this.requiredName = requiredName;
        }

        @Override
        public boolean isMatchFor(class_1799 tool) {
            boolean isNameMatch = true;
            if (this.requiredName != null) {
                isNameMatch = tool.method_7964().getString().equalsIgnoreCase(this.requiredName);
            }
            return isNameMatch && super.isMatchFor(tool);
        }

        @Override
        public void writeToBuffer(class_2540 buffer) {
            super.writeToBuffer(buffer);
            buffer.method_43826((Object)this.requiredName, class_2540::method_10814);
        }

        @Override
        public JsonObject toJson() {
            JsonObject tool = super.toJson();
            if (this.requiredName != null) {
                tool.addProperty("name", this.requiredName);
            }
            return tool;
        }

        public String getRequiredName() {
            return this.requiredName;
        }
    }

    public static final class UpgradeTool
    extends RecipeTool {
        public UpgradeTool(class_2960 toolId) {
            super(toolId);
        }

        public UpgradeTool(class_1792 item) {
            super(item.method_40131().method_40237().method_29177());
        }
    }
}

