/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.common.ai;

import com.obscuria.obscureapi.common.ai.TreeFlow;
import com.obscuria.obscureapi.common.ai.tasks.AITask;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;

public class AIBranch<T extends class_1297> {
    protected final String NAME;
    protected final Predicate<T> CONDITION;
    protected final List<AIBranch<T>> BEHAVIORS = new ArrayList<AIBranch<T>>();
    protected final List<AITask> TASKS = new ArrayList<AITask>();

    protected AIBranch(String name, Predicate<T> condition) {
        this.NAME = name;
        this.CONDITION = condition;
    }

    protected void tick(TreeFlow<T> handler) {
        this.TASKS.forEach(handler::tryUseTask);
        for (AIBranch<T> aiBranch : this.BEHAVIORS) {
            if (!aiBranch.CONDITION.test(handler.ENTITY)) continue;
            aiBranch.tick(handler);
            break;
        }
    }

    public AIBranch<T> addBehavior(String name, Predicate<T> condition) {
        AIBranch<T> branch = new AIBranch<T>(name, condition);
        this.BEHAVIORS.add(branch);
        return branch;
    }

    public AIBranch<T> getBehavior(String name) {
        for (AIBranch<T> aiBranch : this.BEHAVIORS) {
            if (!aiBranch.NAME.equals(name)) continue;
            return aiBranch;
        }
        return new AIBranch<class_1297>("null", entity -> true);
    }

    public AIBranch<T> addTask(int flow, AITask task) {
        this.TASKS.add(task.setFlow(flow));
        return this;
    }

    protected void tickCooldown() {
        this.TASKS.forEach(AITask::tickCooldown);
        this.BEHAVIORS.forEach(AIBranch::tickCooldown);
    }
}

